(function () {
    'use strict';

    BEM.DOM.decl({block: 'b-widget', modName: 'type', modVal: 'last-sets'}, {
        onSetMod: {
            js: function () {
                if (!this.hasMod('width', 'narrow')) {
                    this.setMod('width', 'wide');
                }
                this.__base.apply(this, arguments);
                this._load();
            }
        },

        _load: function () {
            this.setMod('state', 'loading');
            $.ajax({
                type: 'GET',
                url: '/distribution_set/widget_last/',
                dataType: 'json',
                contentType: 'application/json',
                data: {},
                success: $.proxy(this._onLoad, this)
            });
        },

        _onLoad: function (d) {
            if (!this.domElem) {
                return;
            }
            this.delMod('state');

            if (d && d.data && d.data.length) {
                BEM.DOM.init(this.elem('container').html(BEMHTML.apply({
                    block: 'b-table',
                    mods: {theme: 'gray'},
                    content: [
                        {
                            elem: 'header',
                            content: $.map( d.fields, function (col) {
                                return {
                                    elem: 'cell',
                                    content: col.caption
                                };
                            })
                        }
                    ].concat( $.map( d.data, function (set) {
                        return {
                            elem: 'row',
                            content: $.map( d.fields, function (col) {
                                var fields = col.getFrom.split('.'),
                                    field,
                                    value = set;

                                /*jshint boss:true*/
                                while (field = fields.shift()) {
                                    if (value) {
                                        value = value[field];
                                    }
                                }
                                /*jshint boss:false*/

                                return {
                                    elem: 'cell',
                                    content: col.formatAs ? {
                                        block: 'b-formatter',
                                        mods: {type: col.formatAs},
                                        value: col.formatAs === 'date' ?
                                            {date: value, type: 'day'} : value
                                    } : value
                                };
                            })
                        };
                    }))
                })));
            } else {
                this._onEmptyData();
            }
        }
    });

})();
