/*global console */
(function () {
    'use strict';

    var data = require('utils/data');

    BEM.DOM.decl({block: 'b-widget', modName: 'type', modVal: 'revenue'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                this._show();
            }
        },

        refresh: function () {
            this.__base.apply(this, arguments);
            this._show();
        },

        _initBlock: function () {
            this.__base.apply(this, arguments);
            this._resetVars();
        },

        _resetVars: function () {
            this._currencies = [];
            this._dataToRender = {};
            this._loadedRows = 0;
            this._loadedRowsWithData = 0;
            this._totalRows = this.params.rows.length;
        },

        _show: function () {
            if (!this.domElem || !this._opts.entities_tree) {
                return;
            }

            var _this = this;

            this._resetVars();
            this.setMod('state', 'loading');

            $.each(this.params.rows, function (i, row) {
                _this._load(row.request, i);
            });
        },

        _load: function (request, i) {
            data.getStatisticData([request])
                .then(function (d) {
                    var data = d && d[0] || {};
                    this._onLoad(i, data.data || [], data.currencies || []);
                }, this)
                .fail(function (e) {
                    console && console.error && console.error(e);
                    if (this._loadedRows == this._totalRows) {
                        this._renderContent();
                    }
                }, this);
        },

        _onLoad: function (i, data, currencies) {
            this._dataToRender[i] = data;
            if (data && data.length) {
                this._loadedRowsWithData++;
            }
            this._loadedRows++;
            this._currencies = this._currencies.length ? this._currencies : currencies;
            if (this._loadedRows == this._totalRows) {
                this._renderContent();
            }
        },

        _renderContent: function () {
            if (this._loadedRowsWithData === 0) {
                this.delMod('state');
                this._onEmptyData();
            } else {
                this._renderWidget();
            }
        },

        _renderWidget: function () {
            if (!this.domElem) {
                return;
            }
            var container,
                currencies = this._makeCurrenciesMap(),
                results = this._dataToRender,
                rows = this.params.rows;

            container = BEMHTML.apply({
                block: 'b-widget',
                elem: 'container',
                elemMods: {
                    type: 'revenue'
                },
                rows: rows,
                results: results,
                currencies: currencies
            });

            this.delMod('state');
            BEM.DOM.init(this.elem('container').replaceWith(container));
            this.dropElemCache('table container');
        },

        _makeCurrenciesMap: function () {
            var currencies = this._currencies;
            var currenciesMap = {};

            currencies.forEach(function (currencyDesc) {
                currenciesMap[currencyDesc.id] = currencyDesc.code;
            });

            return currenciesMap;
        }
    });
})();
