(function () {
    'use strict';

    var dataModule = require('utils/data');

    BEM.DOM.decl({block: 'b-widget', modName: 'type', modVal: 'statistics-rtb-internal-context-campaign'}, {
        onSetMod: {
            js: function () {
                if (!this.hasMod('width', 'narrow')) {
                    this.setMod('width', 'wide');
                }
                this._request = {
                    dimension_fields: ['date|day'],
                    entity_fields: [],
                    fields: ['rtb_block_shows', 'rtb_all_w_nds'],
                    levels: [{id: 'internal_advnet_context_on_site_rtb'}],
                    period: '30days',
                    total: 0,
                    vat: 0
                };
                this.__base.apply(this, arguments);
                this._load();
            }
        },

        refresh: function (options) {

            this.__base.apply(this, arguments);

            if (options.entities_tree_with_internal !== undefined) {
                this._load();
            }
        },

        _onResize: function () {
            this.__base.apply(this, arguments);
            // for chart to change width (redraw)
            $(window).trigger('resize');
        },

        _load: function () {
            // there is no fields tree
            if (!this._opts.entities_tree_with_internal || !this._opts.entities_tree_with_internal[0].length) {
                this._onEmptyData();
                return;
            } else {
                this.findElem('empty-result-msg').remove();
            }

            var bStatisticChartbox = this.findBlockInside('b-statistic-chartbox');
            if (bStatisticChartbox) {
                bStatisticChartbox.destruct();
            }

            this.setMod('state', 'loading');

            dataModule.getStatisticWidgetInternalCampaignData([this._request])
                .then(function (d) {
                    this._onLoad(this._request, d);
                }, this);
        },

        _getFieldsDesc: function (id, filterData) {
            return this._getData(this._opts.entities_tree_with_internal[0], id, filterData);
        },

        _getExtraOptions: function (data) {
            var options = {};

            $.each(this.fieldKinds, function (i, fieldKind) {
                var fields = data[fieldKind];

                $.each(fields, function (i, field) {
                    if (field.verbatim !== undefined) {
                        options[field.id] = {verbatim: field.verbatim};
                    }
                });
            });

            return options;
        }
    });
})();
