(function() {
    'use strict';

    var dataModule = require('utils/data');
    var lodash = require('lodash');

    BEM.DOM.decl({block: 'b-widget', modName: 'type', modVal: 'statistics'}, {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);
                this._load();
            }
        },

        refresh: function(options) {
            var newRequest,
                requestChanged = false,
                oldRequest = $.extend(true, {}, this._opts.js.request);

            if (!options) {
                return;
            }
            this.__base.apply(this, arguments);

            if (options.js !== undefined && options.js.request !== undefined) {
                newRequest = options.js.request;
            }
            requestChanged = !_isEqual(newRequest, oldRequest);

            if (options.entities_tree !== undefined || requestChanged) {
                this._load();
            }

            if (newRequest && requestChanged) {
                this._refreshTitle(newRequest, options.title);
            }
        },

        _onResize: function() {
            this.__base.apply(this, arguments);
            // for chart to change width (redraw)
            $(window).trigger('resize');
        },

        _load: function() {
            var ajaxReq = this._opts.js.request,
                bStatisticChartbox;

            // there are no request options
            if (!ajaxReq || $.isEmptyObject(ajaxReq)) {
                this._onEmptyData();
                return;
            }
            // there is no fields tree
            if (!this._opts.entities_tree || !this._opts.entities_tree[0].length) {
                this._onEmptyData();
                this.elem('action-setup').hide();
                return;
            } else {
                this.elem('action-setup').show();
            }

            bStatisticChartbox = this.findBlockInside('b-statistic-chartbox');
            if (bStatisticChartbox) {
                bStatisticChartbox.destruct();
            }

            this.findElem('empty-result-msg').remove();

            this.setMod('state', 'loading');

            var confs;

            if (Array.isArray(ajaxReq.period) && ajaxReq.period.length === 4) {
                confs = [
                    lodash.assign({}, ajaxReq, {period: ajaxReq.period.slice(0, 2)}),
                    lodash.assign({}, ajaxReq, {period: ajaxReq.period.slice(2)})
                ];
            } else {
                confs = [ajaxReq];
            }

            dataModule.getStatisticData(confs)
                .then(function (d) {
                    this._onLoad(ajaxReq, d);
                }, this);
        },

        _addEvents: function() {
            this.__base();
        },

        _getFieldsDesc: function (id, filterData) {
            return this._getData(this._opts.entities_tree[0], id, filterData);
        },

        _getExtraOptions: function (data) {
            var options = {};

            $.each(this.fieldKinds, function (i, fieldKind) {
                var fields = data[fieldKind];

                $.each(fields, function (i, field) {
                    if (field.verbatim !== undefined) {
                        options[field.id] = {verbatim: field.verbatim};
                    }
                });
            });

            return options;
        },

        _onEmptyData: function () {
            this.__base.apply(this, arguments);
            this._refreshTitle();
        },

        /**
         * @param {object} [request] - если не передан, заголовок будет отрисован без ссылки
         * @param {string} [title]
         */
        _refreshTitle: function (request, title) {
            if (title === undefined) {
                title = this.elem('title-content').text();
            }
            BEM.DOM.replace(this.elem('linked-title'), BEMHTML.apply({
                block: 'b-widget',
                elem: 'linked-title',
                title: title
            }));
            this.dropElemCache('linked-title title-content');
        }
    });

    function _isEqual(obj1, obj2) {
        var el,
            isEqual = true;

        if (typeof obj1 !== typeof obj2) {
            isEqual = false;
        } else if ($.isArray(obj1)) {
            if ($.isArray(obj2) && obj1.length === obj2.length) {
                obj1.forEach(function(el, i) {
                    isEqual = isEqual && _isEqual(el, obj2[i]);
                });
            } else {
                isEqual = false;
            }
        } else if (typeof obj1 === 'object') {
            for (el in obj1) {
                if (obj2[el] !== undefined) {
                    isEqual = isEqual && _isEqual(obj1[el], obj2[el]);
                } else {
                    isEqual = false;
                }
            }
            for (el in obj2) {
                if (obj1[el] === undefined) {
                    isEqual = false;
                }
            }
        } else {
            isEqual = obj1 === obj2;
        }
        return isEqual;
    }
})();
