/*jslint maxlen: 160 */
/**
 * Временный фикс ошибки отображения фона домика в islands-components:
 *
 * https://github.yandex-team.ru/lego/islands-components/commit/5bba2c99d7c586d9d4a05b6ed4be3072b5ca95ba#common.blocks/popup/_theme/popup_theme_ffffff.css
 */

(function () {

    'use strict';

    BEM.decl('domik_type_popup', {}, {
        /**
         * Создаёт DOM-дерево для домика внутри окошка
         *
         * priv.js на клиенте.
         *
         * @protected
         * @param {String} id — идентификатор блока домика
         * @param {Object} mods — модификаторы домика
         * @returns {Object} BEMJSON
         */
        _buildTypePopup: function(id, mods) {

            return {
                block: 'popup',
                mix: [{block: 'domik', elem: 'popup'}],
                mods: {
                    type: 'modal',
                    position: 'fixed',
                    'body-scroll': 'no',
                    theme: 'transparent'
                },
                underMods: {type: 'paranja'},
                content: {
                    elem: 'content',
                    content: {
                        block: 'domik',
                        js: {_uniqId: id},
                        mods: $.extend({type: 'popup'}, mods),
                        content: {
                            block: 'auth',
                            mods: {content: 'auto'}
                        }
                    }
                }
            };

        }

    });

})();
