(function (BEM, window) {
    'use strict';

    BEM.decl('i-clipboard', {
        onSetMod: {
            js: function () {
                var button = this.params.button,
                    clipboard = this.getZeroClipboard();

                clipboard.setHandCursor(true);
                clipboard.glue(button.get(0), button.parent().get(0));

                button.hover(function() {
                    clipboard.reposition(undefined, button.parent().get(0));
                });
            }
        },

        /**
         * Делает необходимые оверрайды для плагина клиента ZeroClipboard.
         * Сделано все для того, чтобы расширить функциональность
         * леговских b-clipboard и i-clipboard и заставить их работать так, как нам надо.
         *
         * @param  {ZeroClipboard.Client} client
         * @return {ZeroClibboard.Client}
         */
        _initZeroClient: function (client) {
            var baseGlue = client.glue;
            var ZeroClipboard = this.getZeroClipboardObject();

            client.glue = function (elem, appendElem) {
                this.appendElem = appendElem;
                return baseGlue.apply(this, arguments);
            };

            client.reposition = function (elem, parentElem) {
                if (typeof parentElem === 'undefined' && this.appendElem) {
                    parentElem = this.appendElem;
                }

                if (elem) {
                    this.domElement = ZeroClipboard.$(elem);
                    if (!this.domElement) {
                        this.hide();
                    }
                }

                if (this.domElement && this.div) {
                    var box = ZeroClipboard.getDOMObjectPosition(this.domElement, parentElem);
                    var style = this.div.style;
                    style.left = box.left + 'px';
                    style.top = box.top + 'px';
                    style.width = box.width + 'px';
                    style.height = box.height + 'px';
                }
            };

            return client;
        },

        getZeroClipboard: function () {
            var zeroObject = this.getZeroClipboardObject();

            if (typeof zeroObject === 'undefined') {
                this.zeroClient = this._initZeroClient(this.__base.apply(this, arguments));

                zeroObject = this.getZeroClipboardObject();
                zeroObject.setMoviePath('/i/blocks/i-clipboard/zeroclipboard/ZeroClipboard.swf');
            } else if (typeof zeroObject !== 'undefined' && !this.zeroClient) {
                this.zeroClient = this._initZeroClient(new zeroObject.Client());
            }
            return this.zeroClient;
        },

        getZeroClipboardObject: function () {
            return window.ZeroClipboard;
        }
    });
})(BEM, window);
