(function() {
    function buildModFnName(elemName, modName, modVal) {

        return (elemName? '__elem_' + elemName : '') +
               '__mod' +
               (modName? '_' + modName : '') +
               (modVal? '_' + modVal : '');

    }

    function makeModHandler(block, options){
        var o  = $.extend({
            elem: null,
            mod: '*',
            val: '*',
            after: false,
            handler: null
        }, options);
        var fnName = buildModFnName(o.elem, o.mod, o.val),
            fn = block[fnName],
            args = [].slice.call(arguments, 0);
        if ( o.after ) {
            var trueHandler = o.handler;
            o.handler = function() {
                block.afterCurrentEvent(function() {
                    trueHandler.apply(block, args);
                })
            }
        }
        if ( typeof fn == 'function' ) {
            block[fnName] = function() {
                var res;
                if ( (res = fn.apply(block, args)) !== false ) {
                    return o.handler.apply(block, args);
                }
                return res;
            }
        }
        else {
            block[fnName] = o.handler;
        }
    }

    _.mixin({
        onElemSetMod: function(block, el, mod, val, handler){
            if ( $.isFunction(val) ) {
                handler = val;
                val = '*';
            }
            makeModHandler(block, { elem: el, mod: mod, val: val, handler: handler });
        },
        onSetMod: function(block, mod, val, handler){
            if ( $.isFunction(val) ) {
                handler = val;
                val = '*';
            }
            makeModHandler(block, { mod: mod, val: val, handler: handler });
        },
        afterSetMod: function(block, mod, val, handler){
            if ( $.isFunction(val) ) {
                handler = val;
                val = '*';
            }
            makeModHandler(block, { mod: mod, val: val, handler: handler, after: true });
        },
        afterElemSetMod: function(block, el, mod, val, handler){
            if ( $.isFunction(val) ) {
                handler = val;
                val = '*';
            }
            makeModHandler(block, { elem: el, mod: mod, val: val, handler: handler, after: true });
        },
        filterEach: function(els, pred, iter) {
            return $.each(els, function() {
                if ( pred.call(this) ) {
                    return iter.apply(this, arguments);
                }
            });
        }
    });
})();
