(function (BEM) {
    'use strict';

    BEM.DOM.decl('pi-contract-form', {
        onSetMod: {
            js: function () {
                this.countrySelector = this.findBlockInside('pi-country-selector');
                this.submitButton = this.findBlockInside('submit-button', 'button');

                this.countrySelector.on('change', this._onCountryChanged, this);

                this._updateFormData();
            }
        },

        _onCountryChanged: function (e, data) {
            var country = data.country;
            var types = country && country.person_types ? country.person_types : [];
            types = Array.isArray(types) ? types : [types];

            this._renderLegalTypes(types);
            this._updateFormData();
        },

        _renderLegalTypes: function (types) {
            types = types || [];
            this.legalTypeRadio = null;
            BEM.DOM.update(this.elem('legal-types'), BEMHTML.apply(types.map(function (type) {
                return {
                    block: 'pi-contract-form',
                    elem: 'legal-type',
                    elemMods: {type: type.replace('_', '-')}
                };
            })));
            if (types.length > 0) {
                this.legalTypeRadio = this.findBlockInside('legal-types', 'radio-button');
                this.legalTypeRadio.on('change', this._onLegalTypeRadioChanged, this);
            }
            if (types.length === 1) {
                this.setMod('one-type', 'yes');
                this.legalTypeRadio.val(types[0]);
            } else if (types.length > 1) {
                this.delMod('one-type');
            }
        },

        _onLegalTypeRadioChanged: function () {
            this._updateFormData();
        },

        _updateFormData: function () {
            var country = this.countrySelector.val();
            var type = this.getLegalType();
            if (country) {
                var data = {
                    country_id: country.id,
                    person_type_id: type
                };

                this.elem('create-form').find('input').val(function () {
                    return data[this.name] || this.value;
                });
            }

            if (country && country.id && type) {
                this.elem('submit-button').show();
            } else {
                this.elem('submit-button').hide();
            }
        },

        getLegalType: function () {
            return this.legalTypeRadio && this.legalTypeRadio.val();
        }
    }, {});

})(BEM);
