(function (BEM) {
    'use strict';

    BEM.DOM.decl('pi-country-selector', {
        onSetMod: {
            js: function () {
                this.rowLength = this.params.rowLength || 16; // 16 letters in row by default
                this.columnCount = this.params.columnCount || 4;
                //Россия, Украина, Казахстан, Белоруссия, Турция
                this._specialCountries = this.params.special_countries || [225, 187, 159, 149, 983];
                this._specialKey = 'special';
                this._otherId = 'other';

                this._popup = this.findBlockInside('other-countries-popup', 'popup');

                this._initCountries();
                this._renderCountries();
                this._renderOtherCountriesLetters();
                this.setMod('state', 'special-countries');
            },
            state: {
                'special-countries': function () {
                    var uncheckRadios = [this.countryLettersRadio, this.otherCountriesRadio];

                    uncheckRadios.forEach(function (radio) {
                        if (radio) {
                            radio.uncheckAll();
                        }
                    });
                },

                'other-countries-letters': function () {
                    // Nothing to do, just to list this state here
                },

                'other-countries': function () {
                    // Nothing to do, just to list this state here
                },

                'other-country': function () {
                    // Nothing to do, just to list this state here
                }
            }
        },

        _initCountries: function () {
            var _this = this;

            var countries = this.params.countries.reduce(function (result, country) {
                var key;
                if (_this._specialCountries.indexOf(Number(country.id)) === -1) {
                    key = country.name.charAt(0);
                } else {
                    key = _this._specialKey;
                }

                result[key] = result[key] || [];
                result[key].push(country);

                return result;
            }, {});
            Object.keys(countries).forEach(function (key) {
                countries[key] = countries[key].sort(function (a, b) {
                    if (key !== _this._specialKey) {
                        if (a.name.toLowerCase() < b.name.toLowerCase()) {
                            return -1;
                        } else if (a.name.toLowerCase() > b.name.toLowerCase()) {
                            return 1;
                        }
                        return 0;
                    } else {
                        return _this._specialCountries.indexOf(Number(a.id)) -
                            _this._specialCountries.indexOf(Number(b.id));
                    }
                });
            });
            this.countries = countries;
        },

        _renderCountries: function () {
            var countryButtons = this.countries[this._specialKey].map(function (country) {
                return {
                    block: 'pi-country-selector',
                    elem: 'country-button',
                    id: country.id,
                    name: country.name
                };
            });
            countryButtons.push({
                block: 'pi-country-selector',
                elem: 'country-button',
                id: this._otherId,
                name: BEM.I18N('pi-country-selector', 'Other country')
            });
            BEM.DOM.update(this.elem('special-countries-buttons'), BEMHTML.apply(countryButtons));
            this.specialCountriesRadio = this.findBlockInside('special-countries-buttons', 'radio-button');
            this.specialCountriesRadio.on('change', this._onSpecialCountriesRadioChanged, this);
        },

        _renderOtherCountriesLetters: function () {
            var _this = this;
            var letters = Object.keys(this.countries)
                .filter(function (key) {return key !== _this._specialKey;})
                .sort();
            var rowCount = Math.ceil(letters.length / this.rowLength);
            var letterButtons = letters.map(function (key) {
                    return {
                        block: 'pi-country-selector',
                        elem: 'other-country-letter',
                        letter: key
                    };
                });
            var rows = [];
            for (var i = 0; i < rowCount; i++) {
                rows.push({
                    block: 'pi-country-selector',
                    elem: 'other-country-letter-row',
                    content: letterButtons.slice(i * this.rowLength, (i + 1) * this.rowLength)
                });
            }
            BEM.DOM.update(this.elem('other-countries-letters'), BEMHTML.apply(rows));

            this.countryLettersRadio = this.findBlockInside('other-countries-letters', 'radio-button');
            this.countryLettersRadio.on('change', this._onCountryLetterChanged, this);
        },

        _renderOtherCountries: function (key) {
            if (key) {
                var countries = this.countries[key].map(function (country) {
                    return {
                        block: 'pi-country-selector',
                        elem: 'other-country',
                        name: country.name,
                        id: country.id,
                        types: country.person_types
                    };
                });
                var columns = [];
                var countryInColumn = Math.max(5, Math.ceil(this.countries[key].length / this.columnCount));
                var insertBreaks = function (result, country, index, array) {
                    if (index === array.length - 1) {
                        return result.concat([country]);
                    } else {
                        return result.concat([country, {tag: 'br'}]);
                    }
                };
                for (var i = 0; i < this.columnCount; i++) {
                    columns.push({
                        block: 'pi-country-selector',
                        elem: 'other-country-column',
                        content: countries
                            .slice(i * countryInColumn, (i + 1) * countryInColumn)
                            .reduce(insertBreaks, [])
                    });
                }
                BEM.DOM.update(this.elem('other-countries'), BEMHTML.apply(columns));
                this.otherCountriesRadio = this.findBlockInside('other-countries', 'radio-button');
                this.otherCountriesRadio.on('change', this._onOtherCountryChanged, this);
            }
        },

        _onSpecialCountriesRadioChanged: function () {
            var id = this.specialCountriesRadio.val();
            if (id !== this._otherId) {
                this.trigger('change', {country: this.getCountryById(id)});
                if (this.countryLettersRadio) {
                    this.countryLettersRadio.uncheckAll();
                }
                this.setMod('state', 'special-countries');
            } else {
                this.trigger('change', {country: null});
                this.setMod('state', 'other-countries-letters');
            }
        },

        _onCountryLetterChanged: function (e, data) {
            if (!data.current) {
                return;
            }

            var letter = this.countryLettersRadio.val();
            this._renderOtherCountries(letter);
            this.trigger('change', {country: null});
            this.setMod('state', 'other-countries');
        },

        _onOtherCountryChanged: function (e, data) {
            if (!data.current) {
                return;
            }

            if (!this.hasTypes()) {
                this._popup.show(data.current);
            }

            var id = this.otherCountriesRadio.val();
            this.trigger('change', {country: this.getCountryById(id)});
            this.setMod('state', 'other-country');
        },

        getCountryById: function (id) {
            var _this = this;
            if (!this.countries) {
                return null;
            }
            var result = [];
            Object.keys(this.countries).forEach(function (key) {
                result = result.concat(_this.countries[key].filter(function (country) {
                    return Number(country.id) === Number(id);
                }));
            });
            return result[0];
        },

        val: function () {
            var id = this.specialCountriesRadio.val();
            if (id === this._otherId) {
                id = this.otherCountriesRadio ? this.otherCountriesRadio.val() : null;
            }
            return this.getCountryById(id);
        },

        hasTypes: function () {
            return this.val().person_types !== null;
        }

    }, {});

})(BEM);
