/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals BEM*/
(function(BEM, undefined) {

    'use strict';

    BEM.DOM.decl('pi-form-checkbox', {
        onSetMod: {
            js: function () {
                var _this = this;

                this._checkbox = this.findBlockInside('b-form-checkbox');
                this._checkbox.on('change', function() { _this.trigger('change'); });
            },
            disabled: {
                yes: function () {
                    this.disable();
                },
                '': function () {
                    this.enable();
                }
            }
        },

        val: function (val) {
            if (typeof val == 'undefined') {
                return this._checkbox.isChecked();
            }

            if (val) {
                this._checkbox.setMod('checked', 'yes');
            } else {
                this._checkbox.delMod('checked');
            }
        },

        disable: function () {
            this._checkbox.setMod('disabled', 'yes');
        },

        enable: function () {
            this._checkbox.delMod('disabled');
        }
    });

})(BEM);
