/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals BEM, jQuery*/
(function (BEM, $, undefined) {

    'use strict';

    BEM.DOM.decl({block: 'pi-form-colorpicker', modName: 'nullable', modVal: 'yes'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);

                this._$nullValue = this.elem('null-value');
                this._checkbox = this.findBlockOn('chk-hasvalue', 'b-form-checkbox');
                this._checkbox.on('change', this._onHasvalueChange, this);
                this._onHasvalueChange();
            }
        },

        destruct: function () {
            if (this.hasMod('nullable', 'yes')) {
                this._checkbox.un('change', this._onHasvalueChange, this);
            }
            this.__base.apply(this, arguments);
        },

        /**
         * @param {string} [val] Значение
         * @param {boolean} [checked] Отмечать ли
         **/
        val: function (val, checked) {
            if (arguments.length === 0) {
                if (this._checkbox.hasMod('checked', 'yes')) {
                    return this._colorpicker.val();
                } else {
                    return '';
                }
            }

            this._colorpicker.val(val);

            if (checked === undefined) {
                checked = Boolean(val);
            }

            if (checked) {
                this._checkbox.setMod('checked', 'yes');
            } else {
                this._checkbox.delMod('checked');
            }
        },

        disable: function () {
            this._checkbox.delMod('checked');
        },

        enable: function () {
            this._checkbox.setMod('checked', 'yes');
        },

        _disableInput: function () {
            this.__base.apply(this, arguments);
            if (this._$nullValue) {
                this._$nullValue.prop('disabled', false);
            }
        },

        _enableInput: function () {
            this.__base.apply(this, arguments);
            if (this._$nullValue) {
                this._$nullValue.prop('disabled', true);
            }
        },

        _onHasvalueChange: function () {
            if (this._checkbox.isChecked()) {
                this._enableInput();
            } else {
                this._disableInput();
            }
        }
    });

})(BEM, jQuery);
