/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals BEM, jQuery*/
(function (BEM, $, undefined) {

    'use strict';

    BEM.DOM.decl('pi-form-colorpicker', {
        onSetMod: {
            js: function () {
                this._colorpicker = this.findBlockInside('b-form-colorpicker');
            },
            disabled: {
                yes: function () {
                    this.disable();
                },
                '': function () {
                    this.enable();
                }
            }
        },

        /**
         * @param {string} [val] Значение
         **/
        val: function (val) {
            if (arguments.length === 0) {
                return this._colorpicker.val();
            }

            this._colorpicker.val(val);
        },

        validate: function () {
            this._colorpicker.validate();
        },

        isValid: function () {
            return this._colorpicker.isValid();
        },

        isDisabled: function () {
            return this._colorpicker.hasMod('disabled', 'yes');
        },

        disable: function () {
            this._disableInput();
        },

        enable: function () {
            this._enableInput();
        },

        _disableInput: function () {
            this._colorpicker.setMod('disabled', 'yes');
        },

        _enableInput: function () {
            this._colorpicker.delMod('disabled');
        }
    });

})(BEM, jQuery);
