/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals BEM, jQuery*/

(function (BEM, $, undefined) {

    'use strict';

    BEM.DOM.decl({block: 'pi-form-input'}, {
        onSetMod: {
            js: function () {
                this._input = this.findBlockInside('b-form-input');
                this._input.on('change', $.proxy(this._onChange, this));
            },
            disabled: {
                yes: function () {
                    this.disable();
                },
                '': function () {
                    this.enable();
                }
            }
        },

        val: function (val) {
            if (val === undefined) {
                return this._input.val();
            }
            this._input.val(val);
        },

        disable: function () {
            this._input.setMod('disabled', 'yes');
        },

        enable: function () {
            this._input.delMod('disabled');
        },

        _onChange: function () {
            this.trigger('change');
        }
    });

})(BEM, jQuery);
