/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals BEM, jQuery*/

(function (BEM, $, undefined) {

    'use strict';

    BEM.DOM.decl({block: 'pi-form-select'}, {
        onSetMod: {
            js: function () {
                this._select = this.findBlockInside('b-form-select');
                this._select.on('change', $.proxy(this._onChange, this));

                setTimeout(this._showError.bind(this), 2);
            }
        },

        val: function (val) {
            if (!val) {
                return this._select.val();
            }
            this._select.val(val);
        },

        setOptions: function (data) {
            this._select.setOptions(data);
        },

        _onChange: function () {
            this.trigger('change');
        },

        _showError: function () {
            var errorValue = this.params.errorValue;
            if (this.params.error && (errorValue === undefined || errorValue === this._select.val())) {
                this._select.preventErrorHide();
                this._select.showError(this.params.error);
            }
        }
    });

})(BEM, jQuery);
