(function () {
    'use strict';
    BEM.DOM.decl('pi-popup', {
        onSetMod: {
            js: function () {
                this._move();
                this._initBlock();
                this._addListeners();
            }
        },

        show: function () {
            this._show();
        },

        hide: function () {
            this._hide();
        },

        setContent: function (content) {
            BEM.DOM.update(this.elem('content'), content);
        },

        _move: function () {
            BEM.DOM.append($('body'), this.domElem);
        },

        _initBlock: function () {
            this.$html = $('html');
            this._htmlClass = this.buildSelector('overflow-hidden').slice(1);
            this._onScroll = $.throttle(this._onScroll, 500, this);
        },

        _addListeners: function () {
            this.bindTo('layout', 'click', $.proxy(this._onLayoutClick, this));
            this.bindTo('close', 'click', $.proxy(this._hide, this));
        },

        _show: function () {
            this.$html.addClass(this._htmlClass);
            this.setMod('visible', 'yes');
            this.elem('layout').on('scroll', $.proxy(this._onScroll, this));
        },

        _hide: function () {
            this.$html.removeClass(this._htmlClass);
            this.setMod('visible', 'no');
            this.elem('layout').off('scroll');
            this.trigger('hide');
        },

        _onLayoutClick: function (e) {
            if (e.target === e.currentTarget && $(e.target).hasClass('pi-popup__layout')) {
                this._hide();
            }
        },

        _onScroll: function () {
            this._closeBlocks('b-form-select');
            //this._closeBlocks('b-field-editor');
            this._closeBlocks({block: 'b-form-input', modName: 'multisuggest', modVal: 'yes'});
        },

        /**
         * @param {string|object} name
         */
        _closeBlocks: function (name) {
            var blockList = this.findBlocksInside(name);
            if (blockList) {
                blockList.forEach(function (block) {
                    if (block.popup) {
                        block.popup.hide();
                    } else if (block.close) {
                        block.close();
                    } else if (block.hide) {
                        block.hide();
                    }
                });
            }
        }
    });
})();
