(function (BEM) {
    'use strict';

    BEM.DOM.decl('pi-tabbed-pane', {
        onSetMod: {
            js: function () {
                this.radio = this.findBlockInside('radio-button');
                this.radio.on('change', this.onTabChanged, this);
                this.updatePanelsVisibility();
                this.updateTails();
            }
        },

        onTabChanged: function () {
            this.updatePanelsVisibility();
            this.updateTails();
        },

        updatePanelsVisibility: function () {
            var panelId = this.radio.val();
            if (panelId) {
                this.setMod('visible-panels', 'yes');
            } else {
                this.delMod('visible-panels');
            }
            this.elem('panel').hide();
            this.elem('panel', 'id', panelId).show();
        },

        updateTails: function () {
            var panelId = this.radio.val();
            if (panelId) {
                var tab = this.elem('tab', 'id', panelId);
                var tail = this.elem('panel', 'id', panelId).find(this.buildSelector('tail'));
                tail.css('left', Math.round(tab.position().left + tab.width() / 2));
            }
        }

    }, {});

})(BEM);
