#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use open qw(:std :utf8);

use File::Basename;
use Template;
use lib::abs;

# BASE_PORT is set by release-robot script
# to avoid port asking when generating configs
# for migration checker
my $port = $ENV{BASE_PORT};

my $project_root_path = lib::abs::path('../../..');
my $port_path         = lib::abs::path("../../../../../../..");

unless ($port) {
    if ($port_path =~ /(\d+)$/) {
        $port = $1;
        print "Port $port\n";
    } else {
        my $attempt = 0;
        while (!$port && $attempt < 3) {
            $attempt++;
            print "Attempt $attempt\nPort: ";
            $port = int(<STDIN>);
        }
    }
    die "Port is undefined. $port_path - cannot calculate automatically" unless $port;
}

my $hostname = qx(hostname -f);
chomp($hostname);

my $tt = Template->new(
    ABSOLUTE  => 1,
    VARIABLES => {
        dir      => $project_root_path,
        home     => $ENV{HOME},
        hostname => $hostname,

        port                    => $port,
        debugger_interface_port => $port + 200,
        swagger_port            => $port + 300,
        sslport                 => $port + 400,
        rosetta_port            => $port + 10_000,
        debugger_proxy_port     => $port + 15_000,
        node_port               => $port + 20_000,
        rest_api_port           => $port + 30_000,
        java_intapi_port        => $port + 40_000,
        # так же забирает порт + 40_100
        java_jsonapi_port => $port + 50_000,
        # так же забирает порт + 50_100
    },
);

while (my $path = glob("$project_root_path/configs/dev/templates/*")) {
    my $tt2_file_name = basename($path);
    my ($file_name) = $tt2_file_name =~ /(.*)\.tt2/;
    $tt->process($path, {}, "$project_root_path/nginx/$file_name") || die $tt->error();
}
