#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use SOAP::Transport::HTTP;
use Utils;
use YaBSSOAPContext;

sub main {

    if ($ENV{START_PAGE_ID}) {
        $YaBSSOAPContext::PAGE_ID = $ENV{START_PAGE_ID};
    } else {
        warn "You must specify env variable START_PAGE_ID\n";
        exit 1;
    }

    my $daemon = SOAP::Transport::HTTP::Daemon->new('LocalPort' => 80,)->dispatch_to('YaBSSOAPContext');

    output_log_with_time('SOAP server started');

    print "Contact to SOAP server at ", $daemon->url, "\n";

    $daemon->handle;

    say '#END';
}
main();
__END__
