package Utils;

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Moment;
use Exporter;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
  output_log
  output_log_with_time
  to_pretty_json
  );
our @EXPORT = @EXPORT_OK;

sub output_log {
    my ($message) = @_;

    warn $message . "\n";
}

sub output_log_with_time {
    my ($message) = @_;

    warn Moment->now()->get_iso_string() . ' ' . $message . "\n";
}

sub to_pretty_json {
    my ($data) = @_;

    my $json_coder = JSON::PP->new->pretty->canonical->indent_length(4);

    my $pretty_json = $json_coder->encode($data);
    return $pretty_json;
}

1;
