package YaBSSOAPContext;

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Utils;
use JSON::PP qw();

our $PAGE_ID;

sub EditPage {
    my ($soap_namespace, $request) = @_;

    output_log_with_time('EditPage');

    output_log('Request:');
    output_log(to_pretty_json($request));

    my $response;

    foreach my $key (keys %{$request}) {
        my $page_id = $request->{$key}->{PageID} ? $request->{$key}->{PageID} : _get_page_id();
        $response->{$key} = {
            'Error'    => '0',
            'PageID'   => $page_id,
            'ErrorStr' => ''
        };
    }

    output_log('Response:');
    output_log(to_pretty_json($response));

    return $response;
}

sub _get_page_id {
    my $pi = $PAGE_ID;

    $PAGE_ID++;
    return $pi;
}

1;
