#!/usr/bin/env python2.7
import sys
import os

def do_command(command):
    print('do command: {}'.format(command))
    os.system(command)

app_root = sys.argv[1]
app_name = sys.argv[2]
svn_revision = int(sys.argv[3])
app_root = '/java/{0}'.format(app_name)

# following python code can be replaced by single line:
#  do_command('perl bin/build_java.pl --dir={} --app={} --repo=$ARCADIA_ROOT --repo-ver={}'.format(app_root, app_name, svn_revision))
# but this file resides inside docker image while bin/build_java.pl resides in git

version_file = '{}/app/java/{}/version'.format(app_root, app_name)
need_rebuild = True
if os.path.isfile(version_file):
    cur_version = open(version_file, "r").read()[2:-2]
    print 'Build version: {}. Svn revision: {}.'.format(cur_version, svn_revision)
    if str(cur_version) == str(svn_revision):
        need_rebuild = False
else:
    print 'File not found: {}'.format(version_file)

if need_rebuild:
    print 'Start rebuild'
    do_command('rm -r {}/app/java/{}'.format(app_root, app_name))
    do_command('cd $ARCADIA_ROOT/partner/java/apps/{0}/ && $ARCADIA_ROOT/ya package --checkout package-{0}.json && cd -'.format(app_name))
    do_command('mkdir -p {}'.format(app_root))
    do_command('cd $ARCADIA_ROOT/partner/java/apps/{0}/ && tar -xzf yandex-partner-java-{0}.1.*-1.tar.gz --directory {1} && cd -'.format(app_name, app_root))
else:
    print 'Already up to date. Build is not needed'
