from subprocess import Popen
import os
import urllib2
import time
import json
import sys

app_root = sys.argv[1]
pid_file = sys.argv[2]

db_config_filename = './lib/DatabaseConfig.json'
with open(db_config_filename, "r") as read_file:
    db_config = json.load(read_file)

my_env = os.environ.copy()
my_env["JSONAPI_LOG_FILE"] = './nginx/java-mocked-jsonapi.log'
my_env["JSONAPI_PID_FILE"] = pid_file
my_env["MYSQL_HOST"] = str(db_config["partnerdb2"]["host"])
my_env["MYSQL_PORT"] = str(db_config["partnerdb2"]["port"])
my_env["MYSQL_USER"] = str(db_config["partnerdb2"]["user"])
my_env["MYSQL_PASSWORD"] = str(db_config["partnerdb2"]["password"])
my_env["JSONAPI_PROFILE"] = "mock"

command = ['{}/app/java/jsonapi/bin/yandex-partner-java-jsonapi.sh'.format(app_root), '{}/app/java/jsonapi'.format(app_root)]
print 'Start command: ' + ' '.join(command)
# print my_env
p = Popen(command, env=my_env)

management_port = os.environ.get('JSONAPI_MANAGEMENT_PORT')
for x in range(60):
    try:
        get_query = 'http://127.0.0.1:' + management_port + '/actuator/health'
        print 'GET ' + get_query
        contents = urllib2.urlopen(get_query).read()
        print contents
        if contents == '{"status":"UP"}':
            sys.exit()
    except SystemExit:
        raise
    except:
        print 'Gor error by request. Attempt: ' + str(x)
    time.sleep(2)
sys.exit('Jsonapi server still down')
