import ConfigParser
import os
import sys

file_properties = sys.argv[1]
branch_name = os.environ.get('BRANCH_NAME')
print 'Branch: ' + branch_name
if not os.path.isfile(file_properties):
    print 'File ' + file_properties + ' not found'
    file_properties = file_properties.replace(branch_name, 'master')

print 'Properties file: ' + file_properties

try:
    config = ConfigParser.RawConfigParser()
    config.read(file_properties)
    revision = config.get('global', 'revision')
except Exception as e:
    revision = 'trunk'
    print 'Error while read ' + file_properties
    print (e)


command = 'svn up'
if revision != 'trunk':
    command += ' -' + revision

command += ' ' + os.environ.get('ARCADIA_ROOT')
print 'Execute: ' + command
os.system(command)
