
var YA_DEV = true;

(function(window, document, undefined) {

    var Ya = window.Ya = window.Ya || {};

    // Код внутри этого условия выполняется один раз на страницу, остальной код по количеству блоков на странице.
    if (!Ya.Context) {

        Ya.Context = {
            _callbacks: [],
            // Счетчик для генерации id для синхронных подлкючений.
            _asyncIdCounter: 0,
            // Поднимается при первом вызове асинхронного блока. Если после этого последует синхронное подключение,
            // оно будет переведено в асинхронный режим.
            _asyncModeOn: false,
            /**
             * Делает две задачи:
             *  1. Если это синхронный код, то рисует текущий синхронный блок.
             *  2. Вызывает колбеки для асинхронных подлкючений.
             * Вызывается в конце context_static.js
             */
            _init: function () {
                for (var i = 0; i < this._callbacks.length; i++) {
                    this._callbacks[i]();
                }
                this._callbacks = [];
            }
        };

        Ya.Direct = {
            /**
             * Метод размещения асинхронного директа. Вызывается пользователями.
             * @param {Object} partnerId Идентификатор страницы.
             * @param {Object} elementId Идентификатор элемента, в котором нужно отрисовать блок.
             * @param {Object} settings Настройки блока.
             * @param {Object} [settings.data] Данные, которые нужно показать.
             * @param {Function} altCallback Обработчик, на случай пустого ответа БК.
             */
            insertInto: function (partnerId, elementId, settings, altCallback) {
                if (!Ya.Context._asyncModeOn) {
                    Ya.Context._asyncModeOn = true;
                    if (YA_DEV) {
                        if (window.console && console.log) {
                            console.log('Ya.Context: async mode on.');
                        }
                    }
                }
                // PCODE-340
                // Ошибка поймана на tv.yandex.ru
                // Они вызывают insertInto не из колбека, а сами, считая что _context_static.js уже загрузился,
                // что к сожалению не всегда так.
                if (!Ya.Context.AdvManager) {
                    if (YA_DEV) {
                        env.log('Ya.Direct.insertInto called early than _context_static has been loaded.');
                    }
                    Ya.Context._callbacks.push(function () {
                        Ya.Context.AdvManager.renderDirect(partnerId, elementId, settings, altCallback);
                    });
                } else {
                    Ya.Context.AdvManager.renderDirect(partnerId, elementId, settings, altCallback);
                }
            }
        }


        if (YA_DEV) {
            var div = document.createElement('div');
            div.id = 'debug_info';
            div.innerHTML = 'inline-sitelinks_PCODE-420';
            if(window.console && window.console.log) {
                console.log('YA_DEV: Current branch is "inline-sitelinks_PCODE-420"');
            }
            div.style.border = '1px solid red';
            div.style.font = '11px/1.3 sans-serif';
            div.style.padding = '0 7px';
            div.style.position = 'absolute';
            div.style.background = '#fff';
            div.style.left = 0;
            div.style.top = 0;
            div.style.zIndex = 10000;
            div.style.cursor = 'pointer';
            div.onclick = function() {
                this.parentNode.removeChild(this);
            };
            (document.body || document.documentElement).appendChild(div);
        }

         if (!Ya.codeVer) {
            // Версия загрузчика, инкрементируется чаще чем версия кода.
            Ya.loaderVer = 622;
            // В природе есть еще настройка typeof window.yandex_new_code == 'number';
            // Но она сдвигает проценты и поэтому мы ее не используем.

            // Тестируемая версия на 5%.
            Ya.codeVer = Math.random() <= .05 ? 622 : 622;
        }
    }

    var asyncCallbacksContainers = [
        'yandex_context_callbacks', // Код подключения директа с Direct.insertInto.
        'yandexContextAsyncCallbacks' // Код подключения rtb c AdvManager.render.
    ];

    for (var i = 0; i < asyncCallbacksContainers.length; i++) {
        var callbacks = extractProp(asyncCallbacksContainers[i]);
        if (callbacks) {

            if (!Ya.Context._asyncModeOn) {
                Ya.Context._asyncModeOn = true;
                if (YA_DEV) {
                    if (window.console && console.log) {
                        console.log('Ya.Context: async mode on.');
                    }
                }
            }

            for (var j = 0; j < callbacks.length; j++) {
                Ya.Context._callbacks.push(callbacks[j]);
            }
        }
    }

    // Синхронное подключение RTB.
    if (window['yandexContextSyncCallbacks']) {
        var callbacks = extractProp('yandexContextSyncCallbacks');
        for (var i = 0; i < callbacks.length; i++) {
            Ya.Context._callbacks.push(callbacks[i]);
        }
    }

    var commonSettingsDict = [
        'ad_format',
        'site_bg_color',
        'font_size',
        'font_family',
        'stat_id',
        'no_sitelinks',
        'search_text',
        'search_page_number',
        'lang' // Язык интерфейса сайта, может не совпадать с языком браузера пользователя.
    ];

    var productSettingsDict = [
        'type',
        'border_type',
        'header_position',
        'bg_color',
        'border_radius',
        'bg_start_color',
        'bg_end_color',
        'border_color',
        'header_bg_color',
        'title_color',
        'text_color',
        'category_color',
        'url_color',
        'all_color',
        'hover_color',
        'limit',
        'place',
        'callback',
        'favicon',
        'show_how_link',
        'title_font_size',
        'grab',
        'c11n'
    ];

    // Синхронное подключение директа.
    if (window.yandex_ad_format) {
        var settings = {};
        // Сначала извлекаем общие настройки,
        // window.yandex_prop_name = value => settings.prop_name = value
        // ВНИМАНИЕ: если в списке есть yandex_product_prop_name, даже неустановленный, он затрёт yandex_prop_name
        extractSettings(settings, commonSettingsDict);
        // потом частные, частные могут переписать общие. Сейчас пересекается только свойство border_radius.
        // window.yandex_product_prop_name = value => settings.prop_name = value
        extractSettings(settings, productSettingsDict, settings.ad_format);

        var renderTo = settings.place;
        // Для сохранения обратной совместимости, считаем нормальной ситуацию, когда при синхронном подключении
        // в place указан id не существующего элемента.
        if (!renderTo || !document.getElementById(renderTo)) {
            renderTo = 'Ya_sync_' + Ya.Context._asyncIdCounter++;
            document.write('<div id="' + renderTo + '"></div>');
        }

        var pageId = extractPrefixedProp('partner_id');
        Ya.Context._callbacks.push(function () {
            Ya.Context.AdvManager.renderDirect(pageId, renderTo, settings);
        });
    }

    function extractProp(propName) {
        var propValue = window[propName];
        window[propName] = undefined;
        return propValue;
    }

    function extractPrefixedProp(propName, subPrefix) {
        return extractProp('yandex_' + (subPrefix ? subPrefix + '_' : '') + propName);
    }

    function extractSettings(settings, settingsNames, product) {
        for (var i = 0; i < settingsNames.length; i++) {
            settings[settingsNames[i]] = extractPrefixedProp(settingsNames[i], product);
        }
    }

    var protocol = window.location.protocol === 'https:' ? 'https:' : 'http:';
    var jsUrl = '/js/_context_static.js'
            .replace('<%= CODE_VER %>', Ya.codeVer)
            .replace('<%= PROTOCOL %>', 'http:');

    if (Ya.Context._asyncModeOn) {
        var script = document.createElement('script');
        var parentScript = document.getElementsByTagName("script")[0];

        script.charset = 'utf-8';
        script.src = jsUrl;

        parentScript.parentNode.insertBefore(script, parentScript);
    } else {
        // Для синхронного варианта загрузки (document.write) если в течении 8 секунд код не
        // загрузился, хаком разрываем соединение с сервером (не работает в Mozilla). Кроме того,
        // помечаем окно через window.name как плохое. В течении 15 минут в нем не будет показываться
        // контекст.
        setTimeout(function() {
            var scripts = document.getElementsByTagName('script');
            var script = scripts ? scripts[scripts.length - 1] : null;

            if (script && !window.Ya.Context.AdvManager && script.getAttribute('yandex_load_check') == 'yes') {
                // remove static
                script.parentNode.removeChild(script);
                setTerminatedByTimeout();
            }
        }, 8000); // 8 seconds

        if (!isTerminatedByTimeout()) {
            document.write('<script type="text/javascript" src="' + jsUrl + '" yandex_load_check="yes"><\/sc'+'ript>');
        }
    }

    function setTerminatedByTimeout() {
        if (!window.name) {
            window.name = '{"yandex_timeout":' + new Date() + '}';
        }
    }

    function isTerminatedByTimeout() {
        var match = (window.name + '').match(/"yandex_timeout":(\d+)/);
        if (match) {
            return match[1] + 1 > new Date() - 900000;
        }
    }

})(this, this.document);
