(function(window, document, undefined) {
    // do not redefine on succesive loads
    if (Ya.Context.AdvManager) {
        return;
    }

    var util = {};

/**
 * Генерирует уникальное чилсло. Используется для сброса кеша и составления уникальных id.
 * @return {Number} Случайное чило.
 */
util.genRnd = function() {
    return (Math.abs(+new Date()) + Math.round(Math.random() * 10000));
};

/**
 * Creates namespace.
 * @param {String} path
 */
util.ns = function(path) {
    path = path.split('.');

    for (var i = 0, subNs = window; i < path.length; i++) {
        subNs = subNs[path[i]] || (subNs[path[i]] = {});
    }
};

/**
 * Базовая функция, реализующая наследование в JavaScript.
 * Реализует наследование прототипа без исполнения конструктора родителя.
 *
 * К дочернему классу приписывается поле superclass, указывающее на
 * прототип родительского класса. И поле superConstructor указывающее на конструктор родителя.
 * @param {Function} ParentClass Родительский класс.
 * @param {Object} [overrides] Набор дополнительных полей и функций,
 * которые будут приписаны к прототипу дочернего класса.
 * @returns {Object} Дочерний класс.
 */
util.augment = function(ParentClass, overrides) {
    // Конструктор потомка. Если не задан создаем конструктор по умолчанию.
    var childClass = overrides.constructor;
    if (!overrides.hasOwnProperty('constructor')) {
        childClass = function() {childClass.superConstructor.apply(this, arguments)};
    };

    // Наследование
    var F = function() {};
    F.prototype = ParentClass.prototype;
    childClass.prototype = new F();

    // Восстанаваливаем конструктор
    childClass.prototype.constructor = childClass;

    // Ссылки на родительские прототип и конструктор
    childClass.superclass = ParentClass.prototype;
    childClass.superConstructor = ParentClass;

    // Дописываем методы и свойства
    util.extend(childClass.prototype, overrides);

    return childClass;
};

/**
 * Функция, копирующая свойства из одного или нескольких
 * JavaScript-объектов в другой JavaScript-объект.
 * @param {Object} target Целевой JavaScript-объект. Будет модифицирован
 * в результате работы функции.
 * @param {Object} source JavaScript-объект - источник. Все его свойства
 * будут скопированы. Источников может быть несколько (функция может иметь
 * произвольное число параметров), данные копируются справа налево (последний
 * аргумент имеет наивысший приоритет при копировании).
 *
 * @example
 * var options = util.extend({
 *      prop1: 'a',
 *      prop2: 'b'
 * }, {
 *      prop2: 'c',
 *      prop3: 'd'
 * }, {
 *      prop3: 'e'
 * });
 * // Получим в итоге: {
 * //     prop1: 'a',
 * //     prop2: 'c',
 * //     prop3: 'e'
 * // }
 */
 util.extend = function(target) {
    if (YA_DEV) {
        if (!target) {
            throw new Error("util.extend: не передан параметр target");
        }
    }

    for (var i = 1, l = arguments.length, arg; i < l; i++) {
        if (arg = arguments[i]) {
            for (var prop in arg) {
                if (arg.hasOwnProperty(prop)) {
                    target[prop] = arg[prop];
                }
            }
        }
    }
    return target;
};

var toString = {}.toString;

/**
 * Returns true if 'value' is an Array.
 * @param {Any} value
 * @return {Boolean}
 */
util.isArray = function(value) {
    return toString.call(value) === '[object Array]';
};

/**
 * Returns true if 'value' is Function.
 * @param {Any} value
 * @return {Boolean}
 */
util.isFunction = function(value) {
    return toString.call(value) === '[object Function]';
};

/**
 * Checks if value exist in array.
 * @param {Array} array
 * @param {Any} value Value to search
 * @param {Function} [callback]
 * @return {Number} Index in array, return -1 if value is not found.
 */
util.inArray = function(array, value, callback) {
    // Не знаю для чего такое приведение, но для того чтобы его удалить сейчас, нужно делать исследование.
    if (value === undefined || value === null) {
        value = '';
    }

    for (var i = 0; i < array.length; i++) {
        if (callback && callback(value, array[i]) || value === array[i]) {
            return i;
        }
    }

    return -1;
};

/**
 * Call's function for each array element.
 * @param {Array} array Array.
 * @param {Function} fn Callback-функция.
 * @param {Object} [scope] Контекст вызова callback-функции.
 */
util.each = function(array, fn, scope) {
    if (YA_DEV) {
        if (!array) {
            throw new Error("util.each: не передан параметр array");
        }
    }

    for (var i = 0, len = array.length; i < len; ++i) {
        fn.call(scope, array[i], i, array);
    }
};

/**
 * Do "map" operation for array.
 * @param {Array} array Array.
 * @param {Function} fn Callback-функция.
 * @param {Object} [scope] Контекст вызова callback-функции.
 * @return {Array} Результирующий массив.
 */
util.map = function(array, fn, scope) {
    var result = new Array(array.length),
        i,
        l;
    for (i = 0, l = array.length; i < l; i++) {
        if (i in array) {
            result[i] = fn.call(scope, array[i], i, array);
        }
    }
    return result;
};

/**
 * Do "filter" operation for array.
 * @param {Array} array Array.
 * @param {Function} fn Callback-функция.
 * @param {Object} [scope] Контекст вызова callback-функции.
 * @return {Array} Результирующий массив.
 */
util.filter = function(array, fn, scope) {
    var result = [];
    for (var i = 0, len = array.length; i < len; i++) {
        var item = array[i];
        if (fn.call(scope, item, i, array)) {
            result.push(item);
        }
    }
    return result;
};

/**
 * Return array of object props.
 * @param {Object} obj
 * @return {Array}
 */
util.keys = function(obj) {
    var keys = [];
    for (var name in obj) {
        if (obj.hasOwnProperty(name)) {
            keys.push(name);
        }
    }
    return keys;
};


/**
 * Глубокое копирование объектов.
 * TODO: нужно уничтожить этот метод. Вместо него нужно сделать рекурсивный extend.
 * Разница в том что если поле является объектом и его нет в obj, должно быть достаточно его скопировать целиком.
 * @param {Object} target
 * @param {Object} source
 * @return {Object} target
 */
util.deepCopy = function(obj, cfg) {
    // recursively copy objects
    if (cfg  && typeof cfg == 'object') {
        for (var prop in cfg) {
            if (!cfg.hasOwnProperty(prop)) {
                continue;
            }
            if (typeof cfg[prop] == 'object' && !util.isArray(cfg[prop])) {
                if (typeof obj[prop] != 'object') {
                    obj[prop] = {};
                }
                util.deepCopy(obj[prop], cfg[prop]);
            } else {
                obj[prop] = cfg[prop];
            }
        }
    }
    return obj;
};

/**
 * Возвращает нативный метод объекта. Например используется для обхода возможных проблем с перекрытыми
 * методами window и document.
 * Не помогает против изменений через прототип HTMLElement.prototype.getElementsByTagName = customFunction.
 * @param {Object} hostObject  Объект, нативный метод которого нужно получить.
 * @param {String} methodName Имя метода, который нужно получить.
 * @return {Function} Нативный метод.
 */
util.getNativeMethod = function(hostObject, methodName) {
    var nativeMethod = hostObject[methodName];
    if (!util.checkNativeCode(nativeMethod)) {
        var overridingMethod = nativeMethod;
        try {
            delete hostObject[methodName];
            nativeMethod = hostObject[methodName];
            hostObject[methodName] = overridingMethod;
        } catch (e) {
            // it was native, and deleting failed
        }
    }
    return nativeMethod;
};


/**
 * Проверяет является ли переданная функция нативной функцией браузера.
 * @param {Function} fn
 * @return {Boolean}
 */
util.checkNativeCode = function (fn) {
    if (!fn || !fn.toString) {
        return false;
    }
    var fnCode = fn.toString();
    return ( /\[native code\]/.test(fnCode) || /\/\* source code not available \*\//.test(fnCode) );
};

/**
 * Formating string with replace in it <ul>
 *     <li>templates like ${number}, where number -- positive number to number+1 argument.</li>
 *     <li>templates like ${string} on value of property string of second argument.</li>
 * </ul> patterns \$ won't be replaced.
 * TODO: Сложный и перегруженный функциональностью метод.
 * @return {String}
 */
util.format = function(str, data) {
    var args = Array.prototype.slice.call(arguments, 1);
    return str.toString().replace(/(^|.|\r|\n)(\$\{(.*?)\})/g, function(ignore, before, template, name) {
        if (before == '\\') {
            return template;
        } else if (/^[0-9]+$/.test(name)) {
            return before + [args[+name]].join('');
        } else {
            return before + [data && data[name]].join('');
        }
    });
};

/**
 * Removes whitespace characters from the beginning and end of the string.
 * @param {String} str
 * @return {String} trimmed str
 */
util.trim = function(str) {
    return str.replace(/^\s+|\s+$/g, "");
};

/**
 * Переводит в camelСase.
 * @param {String} str
 * @return {String}
 */
util.camelize = function(str) {
    return str.replace(/[-|_]([a-z])/g, function() {
        return arguments[1].toUpperCase();
    });
};

/**
 * Переводит camelCase в строку с дефисами.
 * @param {String} str
 * @return {String}
 */
util.uncamelize = function(str) {
    return str.replace(/[A-Z]/g, function(letter) {
        return '-' + letter.toLowerCase();
    });
};

/**
 * Делает первую букву заглавной.
 * @param {String} str
 * @return {String}
 */
util.capitalize = function(str) {
    return str.charAt(0).toUpperCase() + str.substring(1, str.length);
};

/**
 * Хеш параметров превращается в строку например для Get запроса, все кодируется и т.д.
 * @param {Object} params
 * @return {String}
 */
util.toQueryParams = function(params) {
    var res = [];
    util.each(util.keys(params), function(name) {
        if (params[name] != undefined && params[name] !== '') {
            res.push(name + '=' + encodeURIComponent(params[name]));
        }
    })
    return res.join('&');
};

/**
 * Проверяет значение на диапазон и если не укладываемся, то возвращает дефалтовое
 * написан отдельный метод потому что часто приходится так проверять настройки блока.
 * @param {Number} val
 * @param {Number} minVal
 * @param {Number} maxVal
 * @param {Number} defVal
 * @return {Number}
 */
util.checkValue = function(val, minVal, maxVal, defVal) {
    if (val >= minVal && val <= maxVal) {
        return val;
    }
    return defVal !== undefined ? defVal : (val < minVal ? minVal : maxVal);
};

// version 11
util.prettify = function(text, options) {
    options = options || {};
    options = util.extend({
        gluePrepositions: true
    }, options);

    // проверка на укр. буквы
    if (/[\u0404\u0406\u0407\u0454\u0456\u0457\u0490\u0491]/.test(text)) return text;

    // меняем quot; на обычную кавычку, чтобы коррекция типографики работала
    text = text.replace(/&quot;/g, '"');

    var rusLetters = '\u0430-\u043F\u0440-\u044F\u0410-\u042F\u0451\u0401',
        rusLatLetters = 'a-zA-Z' + rusLetters,
        dashRegexp = new RegExp( '([' + rusLatLetters + ']) - ([' + rusLatLetters + '])', 'g'),
        // [Аа]|[Бб]ез|[Вв](?:|ы|ас|ам|се|сё)|[Гг]де|[Дд](?:о|ля)|[Зз]а|[Ии](?:|з)|[Кк](?:|о|ак)|[Мм]ы|[Нн](?:а|ам|ас|е|и|о)|[Оо](?:|б|т)|[Пп](?:о|ро)|[Сс](?:|о)|[Тт](?:о|ут|ы)|[Уу]|[Чч]то|[Ээ]то
        rusPrepositions = '[\u0410\u0430]|[\u0411\u0431]\u0435\u0437|[\u0412\u0432](?:|\u044B|\u0430\u0441|\u0430\u043C|\u0441\u0435|\u0441\u0451)|[\u0413\u0433]\u0434\u0435|[\u0414\u0434](?:\u043E|\u043B\u044F)|[\u0417\u0437]\u0430|[\u0418\u0438](?:|\u0437)|[\u041A\u043A](?:|\u043E|\u0430\u043A)|[\u041C\u043C]\u044B|[\u041D\u043D](?:\u0430|\u0430\u043C|\u0430\u0441|\u0435|\u0438|\u043E)|[\u041E\u043E](?:|\u0431|\u0442)|[\u041F\u043F](?:\u043E|\u0440\u043E)|[\u0421\u0441](?:|\u043E)|[\u0422\u0442](?:\u043E|\u0443\u0442|\u044B)|[\u0423\u0443]|[\u0427\u0447]\u0442\u043E|[\u042D\u044D]\u0442\u043E',
        nbsp = '\u00A0',
        dash = '\u2013', // &ndash;, если надо &mdash;, то будет \u2014
        quoteMatches = text.match(/"/g),
        quotedWord = new RegExp('(^|\\s)"([.\\-\\s\\d' + rusLatLetters + ']{3,})"', 'g'),
        singleWordMatches = text.match(quotedWord);

    // если в тексте:
    //   * есть кавычки;
    //   * число кавычек чётное;
    //   * все кавычки относятся к одиночным словам или фразам,
    // то мы можем себе позволить завернуть их в ёлочки
    if (quoteMatches
          && singleWordMatches
          && quoteMatches.length % 2 == 0
          && quoteMatches.length / 2 == singleWordMatches.length) {
        text = text.replace(quotedWord, function(original, $1, $2) {
            // сначала проверяем условия, при которых мы не готовы делать замену
            if (/^[\-\s]|[\-\s]$|^[\-\s\d]+$/.test($2)) {
                return original;
            } else return $1 + '\u00AB' + $2 + '\u00BB';
        });
    }

    if (options.gluePrepositions) {
        // убираем висячие короткие союзы/частицы (склеиваем через nbsp)
        text = text.replace(new RegExp('(^|\\(|\\s)(' + rusPrepositions + ')\\s([\u00AB"$\\d' + rusLatLetters + '])', 'g'), '$1$2' + nbsp + '$3');
    }

    text = text
        // заменяем на ndash, потому что mdash обычно слишком широкий
        .replace(dashRegexp, '$1' + nbsp + dash + ' $2')
        // заменяем в инфе о скидках вида:
        //    Скидка -50%
        // дефис на нормальный минус (критично в шрифтах типа Arial)
        .replace(/ \-(\d\d?)%/g, ' \u2212$1%')
        // висячие слова в конце объявления длиной 1-2 символа склеиваем с основной строкой
        .replace(/ ([^\s]{1,2})$/, nbsp + '$1')
        // неразрываемый пробел в ценах в рублях, вида 5 000 руб
        .replace(/(\d+ (\d{3} ){0,2})\u0440\u0443\u0431([.,?!:;\s]|$)/g, function(str) {
            return str.replace(/ /g, nbsp);
        })
        // склеиваем неразрывным пробелом !
        .replace(/ !/, nbsp + '!');

    return text;
};;
    var browser;

(function() {

// private переменные, больше всего про версии браузеров
var nav = navigator,
    docMode = document.documentMode,
    compatMode = document.compatMode,
    userAgent = nav.userAgent.toLowerCase(),
    isOpera = userAgent.indexOf("opera") > -1,
    isOperaMini = userAgent.indexOf("opera mini") > -1,
    isIE7 = (!isOpera && userAgent.indexOf("msie 7") > -1 || docMode == 7),
    isIE8 = (!isOpera && userAgent.indexOf("msie 8") > -1 && docMode != 7 && docMode != 9 || docMode == 8),
    isIE9 = (!isOpera && userAgent.indexOf("msie 9") > -1 && docMode != 7 && docMode != 8 || docMode == 9),
    isIE6 = !isOpera && userAgent.indexOf("msie 6") > -1,
    isIE = ((!isOpera && userAgent.indexOf("msie") > -1) || isIE6 ||isIE7 ||isIE8 ||isIE9),
    isIEQuirks = (isIE && (compatMode == "BackCompat" || docMode == 5)),
    isChrome = userAgent.indexOf("chrome") > -1,
    isSafari = (!isChrome && (/webkit|khtml/).test(userAgent)),
    isGecko = (!isSafari && !isChrome && userAgent.indexOf("gecko") > -1),
    isSecure = (window.location.href.toLowerCase().indexOf("https") === 0),
    isWebkit = userAgent.indexOf('webkit') !== -1;

// copy properties to main object
browser = {
    /**
     * True if browser is Opera.
     * @type Boolean
     */
    isOpera : isOpera,
    /**
     * True if browser is Mozilla
     * @type Boolean
     */
    isGecko : isGecko,
    /**
     * True if browser is Safari.
     * @type Boolean
     */
    isSafari : isSafari,
    /**
     * True if browser is Internet Explorer.
     * @type Boolean
     */
    isIE : isIE,
    /**
     * True if browser is Internet Explorer
     * @type Boolean
     */
    isIE6 : isIE6,
    /**
     * True if browser is Internet Explorer 7++
     * @type Boolean
     */
    isIE7 : isIE7,
    /**
     * True if browser is Internet Explorer 8++
     * @type Boolean
     */
    isIE8 : isIE8,
    /**
     * True if browser is Internet Explorer 9++
     * @type Boolean
     */
    isIE9 : isIE9,
    /**
     * True if browser is All IEs and work in Quirks mode.
     * @type Boolean
     */
    isIEQuirks : isIEQuirks,

    isChrome : isChrome,
    isOperaMini: isOperaMini,
    isSecure : isSecure,
    isWebkit : isWebkit
};

// версия флеша для медийики
browser.flashVer = (function() {
    var plugins = nav.plugins || {};
    var OBJECT = "object",
        SHOCKWAVE_FLASH = "Shockwave Flash",
        SHOCKWAVE_FLASH_AX = "ShockwaveFlash.ShockwaveFlash",
        FLASH_MIME_TYPE = "application/x-shockwave-flash",
        playerVersion = [0, 0, 0],
        desc;

    if (typeof plugins[SHOCKWAVE_FLASH] == OBJECT) {
        desc = plugins[SHOCKWAVE_FLASH].description;
        if (desc && !(nav.mimeTypes === undefined && nav.mimeTypes[FLASH_MIME_TYPE] && !nav.mimeTypes[FLASH_MIME_TYPE].enabledPlugin)) {
            desc = desc.replace(/^.*\s+(\S+\s+\S+$)/, "$1");
            playerVersion[0] = parseInt(desc.replace(/^(.*)\..*$/, "$1"), 10);
            playerVersion[1] = parseInt(desc.replace(/^.*\.(.*)\s.*$/, "$1"), 10);
            playerVersion[2] = /[a-zA-Z]/.test(desc) ? parseInt(desc.replace(/^.*[a-zA-Z]+(.*)$/, "$1"), 10) : 0;
            return playerVersion;
        }
    } else if (window.ActiveXObject !== undefined) {
        try {
            var a = new ActiveXObject(SHOCKWAVE_FLASH_AX);
            if (a) { // a will return null when ActiveX is disabled
                desc = a.GetVariable("$version");
                if (desc) {
                    desc = desc.split(" ")[1].split(",");
                    return [parseInt(desc[0], 10), parseInt(desc[1], 10), parseInt(desc[2], 10)];
                }
            }
        }
        catch(e) {}
    }
    return playerVersion;
})();

})();;
    /**
 * Метод отправки кроссдоменных запросов методом POST. Использует
 * XMLHttpRequest или XDomainRequest. Нужен для логирования
 * ошибок. Они отправляются POST'ом, потому что много данных, а в IE 8
 * длина URL ограничена 2083 символами.
 *
 * @param {String} url Request URL
 * @param {Object} data Key-value map of data to post
 */
function post(url, data) {
    var encoded = util.toQueryParams(data);

    /* IE 8+ || W3C */
    try {
        var xhr = new (window.XDomainRequest || window.XMLHttpRequest)();
        xhr.open('post', url, true);
        if (xhr.setRequestHeader) {
            xhr.setRequestHeader('Content-Type', 'text/plain;charset=UTF-8');
        }
        xhr.send(encoded);
    /* IE 6-7 */
    } catch (_) {
        // URL may come without the protocol part
        var maxLen = 2083 - location.protocol.length;
        var reqUrl = url + '?' + encoded;
        if (reqUrl.length > maxLen) {
            var trimIndex = reqUrl.lastIndexOf('%', maxLen - 1);
            if (trimIndex < 0) {
                trimIndex = maxLen - 1;
            }
            reqUrl = reqUrl.substring(0, trimIndex);
        }
        (new Image()).src = reqUrl;
    }
}
;
    // работа с JSON
var json;
(function() {
    if (window.JSON !== undefined && window.JSON.stringify) {
        json = window.JSON;
        return;
    } else {
        json = {};
    }

    var _toString = Object.prototype.toString,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        meta = {
            '\b' : '\\b',
            '\t' : '\\t',
            '\n' : '\\n',
            '\f' : '\\f',
            '\r' : '\\r',
            '"'  : '\\"',
            '\\' : '\\\\'
        };

    json.stringify = function(val) {
        if (val === null) {
            return 'null';
        }
        if (val === undefined) {
            return undefined;
        }
        switch(_toString.call(val)) {
            case '[object String]':
                return '"' +
                    (escapable.test(val)?
                        val.replace(escapable, function(a) {
                            var c = meta[a];
                            return typeof c === 'string'? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                        }) :
                        val) +
                    '"';
            case '[object Number]':
            case '[object Boolean]':
                return '' + val;
            case '[object Array]':
                var res = '[', i = 0, len = val.length, strVal;
                while(i < len) {
                    strVal = json.stringify(val[i]);
                    res += (i++? ',' : '') + (strVal === undefined ? 'null' : strVal);
                }
                return res + ']';
            case '[object Object]':
                var res = '{', i = 0, strVal;
                for(var key in val) {
                    if(val.hasOwnProperty(key)) {
                        strVal = json.stringify(val[key]);
                        strVal !== undefined && (res += (i++? ',' : '') + '"' + key + '":' + strVal);
                    }
                }
                return res + '}';
            default:
                return undefined;
        }
    };
})();;
    /**
 * Для доменов не в латинице.
 * @author https://github.com/bestiejs/punycode.js
 */
var punycode = (function () {
    /** Highest positive signed 32-bit float value */
    var maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1

    /** Bootstring parameters */
    base = 36,
    tMin = 1,
    tMax = 26,
    skew = 38,
    damp = 700,
    initialBias = 72,
    initialN = 128, // 0x80
    delimiter = '-', // '\x2D'

    /** Regular expressions */
    regexNonASCII = /[^ -~]/, // unprintable ASCII chars + non-ASCII chars
    regexSeparators = /\x2E|\u3002|\uFF0E|\uFF61/g, // RFC 3490 separators

    /** Error messages */
    errors = {
        'overflow': 'Overflow: input needs wider integers to process'
    },

    /** Convenience shortcuts */
    baseMinusTMin = base - tMin,
    floor = Math.floor,
    stringFromCharCode = String.fromCharCode;

    /*--------------------------------------------------------------------------*/

    /**
     * A generic error utility function.
     * @private
     * @param {String} type The error type.
     * @returns {Error} Throws a `RangeError` with the applicable error message.
     */
    function error(type) {
        throw RangeError(errors[type]);
    }

    /**
     * A simple `Array#map`-like wrapper to work with domain name strings.
     * @private
     * @param {String} domain The domain name.
     * @param {Function} callback The function that gets called for every
     * character.
     * @returns {Array} A new string of characters returned by the callback
     * function.
     */
    function mapDomain(string, fn) {
        return util.map(string.split(regexSeparators), fn).join('.');
    }

    /**
     * Creates an array containing the numeric code points of each Unicode
     * character in the string. While JavaScript uses UCS-2 internally,
     * this function will convert a pair of surrogate halves (each of which
     * UCS-2 exposes as separate characters) into a single code point,
     * matching UTF-16.
     * @see <http://mathiasbynens.be/notes/javascript-encoding>
     * @name decode
     * @param {String} string The Unicode input string (UCS-2).
     * @returns {Array} The new array of code points.
     */
    function ucs2decode(string) {
        var output = [],
            counter = 0,
            length = string.length,
            value,
            extra;
        while (counter < length) {
            value = string.charCodeAt(counter++);
            if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
                // high surrogate, and there is a next character
                extra = string.charCodeAt(counter++);
                if ((extra & 0xFC00) == 0xDC00) { // low surrogate
                    output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
                } else {
                    // unmatched surrogate; only append this code unit, in case the next
                    // code unit is the high surrogate of a surrogate pair
                    output.push(value);
                    counter--;
                }
            } else {
                output.push(value);
            }
        }
        return output;
    }

    /**
     * Converts a digit/integer into a basic code point.
     * @private
     * @param {Number} digit The numeric value of a basic code point.
     * @returns {Number} The basic code point whose value (when used for
     * representing integers) is `digit`, which needs to be in the range
     * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
     * used; else, the lowercase form is used. The behavior is undefined
     * if `flag` is non-zero and `digit` has no uppercase form.
     */
    function digitToBasic(digit, flag) {
        //  0..25 map to ASCII a..z or A..Z
        // 26..35 map to ASCII 0..9
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
    }

    /**
     * Bias adaptation function as per section 3.4 of RFC 3492.
     * http://tools.ietf.org/html/rfc3492#section-3.4
     * @private
     */
    function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
            delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
    }

    /**
     * Converts a string of Unicode symbols to a Punycode string of ASCII-only
     * symbols.
     * @param {String} input The string of Unicode symbols.
     * @returns {String} The resulting Punycode string of ASCII-only symbols.
     */
    function encode(input) {
        var n,
            delta,
            handledCPCount,
            basicLength,
            bias,
            j,
            m,
            q,
            k,
            t,
            currentValue,
            output = [],
            /** `inputLength` will hold the number of code points in `input`. */
            inputLength,
            /** Cached calculation results */
            handledCPCountPlusOne,
            baseMinusT,
            qMinusT;

        // Convert the input in UCS-2 to Unicode
        input = ucs2decode(input);

        // Cache the length
        inputLength = input.length;

        // Initialize the state
        n = initialN;
        delta = 0;
        bias = initialBias;

        // Handle the basic code points
        for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < 0x80) {
                output.push(stringFromCharCode(currentValue));
            }
        }

        handledCPCount = basicLength = output.length;

        // `handledCPCount` is the number of code points that have been handled;
        // `basicLength` is the number of basic code points.

        // Finish the basic string - if it is not empty - with a delimiter
        if (basicLength) {
            output.push(delimiter);
        }

        // Main encoding loop:
        while (handledCPCount < inputLength) {

            // All non-basic code points < n have been handled already. Find the next
            // larger one:
            for (m = maxInt, j = 0; j < inputLength; ++j) {
                currentValue = input[j];
                if (currentValue >= n && currentValue < m) {
                    m = currentValue;
                }
            }

            // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
            // but guard against overflow
            handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
                error('overflow');
            }

            delta += (m - n) * handledCPCountPlusOne;
            n = m;

            for (j = 0; j < inputLength; ++j) {
                currentValue = input[j];

                if (currentValue < n && ++delta > maxInt) {
                    error('overflow');
                }

                if (currentValue == n) {
                    // Represent delta as a generalized variable-length integer
                    for (q = delta, k = base; /* no condition */; k += base) {
                        t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
                        if (q < t) {
                            break;
                        }
                        qMinusT = q - t;
                        baseMinusT = base - t;
                        output.push(
                            stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                        );
                        q = floor(qMinusT / baseMinusT);
                    }

                    output.push(stringFromCharCode(digitToBasic(q, 0)));
                    bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                    delta = 0;
                    ++handledCPCount;
                }
            }

            ++delta;
            ++n;

        }
        return output.join('');
    }

    /**
     * Converts a Unicode string representing a domain name to Punycode. Only the
     * non-ASCII parts of the domain name will be converted, i.e. it doesn't
     * matter if you call it with a domain that's already in ASCII.
     * @param {String} domain The domain name to convert, as a Unicode string.
     * @returns {String} The Punycode representation of the given domain name.
     */
    function toASCII(domain) {
        return mapDomain(domain, function(string) {
            return regexNonASCII.test(string)
                ? 'xn--' + encode(string)
                : string;
        });
    }

    /*--------------------------------------------------------------------------*/

    /** Define the public API */
    return {
        'toASCII': toASCII,
        'regexNonASCII': regexNonASCII
    };
}());
;
    /**
 * Работа с цветами.
 * Конструктор принимает один или три параметра: значение каждого из кналав или hex строку.
 * @param {Number|String} r Значение красного канала или цвет в hex формате (#F0F0F0).
 * @param {Number} [g] Значение зеленого канала.
 * @param {Number} [b] Значение синего канала.
 */
var RGB = function(r, g, b) {
    if (arguments.length < 3) {
        // is color hash
        var colorHash = RGB.normalizeColorHash(r) || '#000000';
        r = parseInt(colorHash.substr(1, 2), 16);
        g = parseInt(colorHash.substr(3, 2), 16);
        b = parseInt(colorHash.substr(5, 2), 16);
    }
    this[0] = r;
    this[1] = g;
    this[2] = b;
};

/**
 * Приводит цвет к единому формату вида #XXXXXX, иначе возвращает undefined.
 * @param {String} colorHash
 * @return {String} normalizedColorHash
 */
RGB.normalizeColorHash = function(colorHash) {
    colorHash = (colorHash + '').toUpperCase().replace(/^#?/, '#');

    if (/^#[0-9A-F]{6}$/i.test(colorHash)) {
        return colorHash;
    } else if (/^#[0-9A-F]{3}$/i.test(colorHash)) {
        return colorHash.replace(/([0-9A-F])([0-9A-F])([0-9A-F])/i, '$1$1$2$2$3$3');
    } else {
        return undefined;
    }
};

RGB.prototype = {
    _dec2hex: function(hex) {
        var chars = '0123456789ABCDEF';
        return chars.charAt(hex / 16 << 0) + chars.charAt(hex % 16);
    },
    /**
     * Возвращает представление цвета в hex формате (#F0F0F0).
     * @return {String}
     */
    toString: function() {
        return '#' + this._dec2hex(this[0]) + this._dec2hex(this[1]) + this._dec2hex(this[2]);
    },
    /**
     * Используется в Warnings для определения якрости цвета. TODO: выпилить в счет luma.
     * @return {Number}
     */
    avg: function() {
        return (this[0] + this[1] + this[2]) / 3.0;
    },
    /**
     * Используется в isLight для определения якрости цвета. 
     * По сути делает тоже самое что и avg, просто по другим правилам. Правила luma правильней.
     * @return {Number}
     */
    luma: function() {
        return (this[0] * 299 + this[1] * 587 + this[2] * 114) / 1000.0;
    },
    /**
     * Возвращает true если цвет можно считать светлым.
     * @return {Boolean}
     */
    isLight: function(color) {
        return this.luma() > 127;
    }
};;
    // URL Safe Base64: + -> -; / -> _;
// кодирование и раскодирование
var base64 = new function() {
    // private property
    var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=",
        fromCharCode = String.fromCharCode;

    // public method for encoding
    this.encode = function (input, maxLength) {
        maxLength = maxLength || 1e6;
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = utf8_encode(input, maxLength*3/4 | 0);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output +
            keyStr.charAt(enc1) + keyStr.charAt(enc2) +
            keyStr.charAt(enc3) + keyStr.charAt(enc4);

        }

        return output;
    };

    function utf8_encode(string, maxLength) {
        string = string.replace(/\r\n/g,"\n");
        var utftext = "", nextChar;

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                nextChar = fromCharCode(c);
            }
            else if((c > 127) && (c < 2048)) {
                nextChar = fromCharCode((c >> 6) | 192);
                nextChar += fromCharCode((c & 63) | 128);
            }
            else {
                nextChar =  fromCharCode((c >> 12) | 224);
                nextChar += fromCharCode(((c >> 6) & 63) | 128);
                nextChar += fromCharCode((c & 63) | 128);
            }
            if (utftext.length + nextChar.length > maxLength) break;
            utftext += nextChar;
        }
        return utftext;
    };

    // public method for decoding
    this.decode = function(input) {
        var output = "",
            chr1, chr2, chr3,
            enc1, enc2, enc3, enc4,
            i = 0;

        input = input.replace(/[^A-Za-z0-9\-\_\=]/g, "");

        while (i < input.length) {
            enc1 = keyStr.indexOf(input.charAt(i++));
            enc2 = keyStr.indexOf(input.charAt(i++));
            enc3 = keyStr.indexOf(input.charAt(i++));
            enc4 = keyStr.indexOf(input.charAt(i++));

            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output += String.fromCharCode(chr1);

            if (enc3 != 64) {
                output += String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output += String.fromCharCode(chr3);
            }
        }

        return utf8_decode(output);
    };

    function utf8_decode(utftext) {
        var string = "",
            i = 0,
            c = 0, c1 = 0, c2 = 0;

        while (i < utftext.length) {
            c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            } else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i+1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            } else {
                c2 = utftext.charCodeAt(i+1);
                c3 = utftext.charCodeAt(i+2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }
};;

    /**
 * Работа с DOM, учитывает, что нативные методы могут быть переопределенны
 * или их может не быть в старых браузерах.
 */

// Для того чтобы в IE работаели кастомный тег, его нужно хоть раз создать через document.createElement
document.createElement('YATAG');

/**
 * Поиск элемента по ID или классу.
 * @param {String|HTMLElement} selector CSS-селектор или DOM-элемент
 * @param {HTMLElement} [container=document] Контейнер, внутри которого искать
 * @returns {HTMLElement|HTMLElement[]} Найденный элемент или массив
 * (NB: не live collection, a обычный массив!)
 */
var dom = function (selector, container) {
    /* Allow passing either an element or a CSS selector. */
    if (typeof selector !== 'string') {
        return selector;
    }

    var selectorType = selector.slice(0, 1);
    var selectorValue = selector.slice(1);

    switch (selectorType) {
        case '#': return document.getElementById(selectorValue);
        case '.': return dom.getElementsByClassName(selectorValue, container);
    }
};

/**
 * Берет элементы по классу, при этом понимает, что метода может не быть
 * или он переопределен.
 * @param {String} className Название класса
 * @param {Element} [node=document] Контейнер
 * @returns {Array} Массив найденных элементов
 */
dom.getElementsByClassName = function (className, node)  {
    node = node || document;

    // Native getElementsByClassName
    if (util.checkNativeCode(node.getElementsByClassName)) {
        // Copy to an array to conform with the non-native implementation
        return Array.prototype.slice.call(node.getElementsByClassName(className));
    }

    // Non-native implementation (iterate over all elements)
    var allElements = node.getElementsByTagName('*');
    var filtered = util.filter(allElements, function (el) {
        return dom.hasClass(el, className);
    });
    return filtered;
};

/**
 * Ставит стиль на элемент.
 */
dom.css = function (el, style) {
    util.each(util.keys(style), function (key) {
        var normalized = dom.normalizeCSSProperty(key, style[key]);
        var name = util.camelize(normalized[0]);
        el.style[name] = normalized[1];
    });
};

/**
 * Проверяет наличие класса на элементе.
 * @param {HTMLElement} el
 * @param {String} className
 * @returns {Boolean}
 */
dom.hasClass = function (el, className) {
    var clList = el.className.split(' ');
    for (var i = 0, len = clList.length; i < len; i++) {
        if (clList[i] == className) {
            return true;
        }
    }
    return false;
};

/**
 * Добавляет класс к элементу.
 * @param {HTMLElement} el
 * @param {String} className
 */
dom.addClass = function (el, className) {
    if (!dom.hasClass(el, className)) {
        el.className += ' ' + className;
    }
};

/**
 * Убирает класс с элемента.
 * @param {HTMLElement} el
 * @param {String} className
 */
dom.removeClass = function (el, className) {
    var clList = el.className.split(' ');
    var filtered = util.filter(clList, function (cl) {
        return cl != className;
    });
    if (filtered.length < clList.length) {
        el.className = filtered.join(' ');
    }
};

/**
 * Добавляет или убирает класс у элемента.
 * @param {HTMLElement} el
 * @param {String} className
 * @param {Boolean} [toggle] true – добавить класс, false – удалить
 */
dom.toggleClass = function (el, className, toggle) {
    if (undefined === toggle) {
        toggle = !dom.hasClass(el, className);
    }
    toggle ? dom.addClass(el, className) : dom.removeClass(el, className);
};

/**
 * Проверяет, есть ли `head' в документе, и если такого нет, то создает.
 * @returns {HTMLElement} head element
 */
dom.getHead = function () {
    // Check head object
    var head = document.getElementsByTagName('head')[0];
    if (!head) {
        head = document.createElement('head');
        document.documentElement.appendChild(head);
    }
    return head;
};

/**
 * Кроссбраузерно получаем координаты элемента.
 * Используется в проверке видимости.
 *
 * @see http://ejohn.org/blog/getboundingclientrect-is-awesome/
 * @see https://github.com/jquery/jquery/blob/1.x-master/src/offset.js
 *
 * @returns {Object} { offsetLeft: x, offsetTop: y }
 */
dom.getXY = function (elem) {
    var box = { top: 0, left: 0 };
    var doc = elem && elem.ownerDocument;
    var docElem = doc.documentElement;

    if (elem.getBoundingClientRect) {
        box = elem.getBoundingClientRect();
    }
    return {
        offsetTop: box.top + (window.pageYOffset || docElem.scrollTop) -
            (docElem.clientTop  || 0),
        offsetLeft: box.left + ( window.pageXOffset || docElem.scrollLeft ) -
            (docElem.clientLeft || 0)
    };
};

/**
 * Кроссбраузерно получаем стиль у элемента.
 * @returns {Object} CSS style declaration
 */
dom.getStyle = function (el, prop) {
    if (document.defaultView && document.defaultView.getComputedStyle) {
        dom.getStyle = function (el, prop) {
            if (!el || el == document) {
                return null;
            }
            prop = dom.normalizeCSSProperty(prop, undefined, el);
            return document.defaultView.getComputedStyle(el, null)[prop[0]];
        };
    } else if (el.currentStyle) {
        dom.getStyle = function (el, prop) {
            if (!el || el == document || !el.currentStyle) {
                return null;
            }
            prop = dom.normalizeCSSProperty(prop, undefined, el);
            return el.currentStyle[prop[0]];
        };
    } else {
        dom.getStyle = function (el, prop) {
            if (!el || el == document) {
                return null;
            }
            prop = dom.normalizeCSSProperty(prop, undefined, el);
            return el.style[prop[0]];
        };
    }
    return dom.getStyle(el, prop);
};

/**
 * Устанавливает css свойство с указанием important.
 * @param {DOMElement} element
 * @param {String} propertyName
 * @param {String} value
 */
dom.setImportantCssProperty = function (element, propertyName, value) {
    if (element.style.setProperty) {
        element.style.setProperty(propertyName, value, 'important');
    } else {
        element.style.cssText += ';' + propertyName + ':' + value + ' !important';
    }
};

/**
 * Returns name and value of CSS property normalized for current browser.
 * For example property opacity, for IE
 * turns into filter:Alpha(...). Supports: opacity, float, boxShadow.
 *
 * @param {String} name Property name.
 * @param {String} value Property value.
 * @param {Node} [el] DOM-elemnt for which need to setup property. Works only
 * for float propery, because in style it has name cssFloat/styleFloat.
 * @return {Array} Array, first element is prop name, second valye.
 */
dom.normalizeCSSProperty = function (name, value, el) {
    var etalon = el ? el.style : document.documentElement.style;
    name = util.camelize(name);

    if (name == 'opacity' && typeof etalon['opacity'] != 'string') {
        return [ 'filter', value == 1 ?
            '' : 'Alpha(opacity=' + (value * 100) + ')' ];
    }

    if (/^(float|(style|css)Float)$/.test(name)) {
        name = 'float';
        if (el) {
            name = typeof etalon['cssFloat'] == 'string' ?
                'cssFloat' : 'styleFloat';
        }
        return [ name, value ];
    }

    if (name == 'boxShadow') {
        util.each(
            [ 'MozBoxShadow', 'WebkitBoxShadow', 'boxShadow' ],
            function (property) {
                if (typeof etalon[property] == 'string') {
                    name = property;
                }
            }
        );
        return [ name, value ];
    }

    return [ name, value ];
};

// получает положение скролла у окна
dom.getWindowScroll = function () {
    if ((typeof window.pageXOffset == 'number') || (typeof window.pageYOffset == 'number')) {
        return [ window.pageXOffset, window.pageYOffset ];
    } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
        return [ document.body.scrollLeft, document.body.scrollTop ];
    } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
        return [ document.documentElement.scrollLeft, document.documentElement.scrollTop ];
    }
    return [ null, null ];
};

// получает размеры viewport
dom.getWindowSize = function () {
    if ((typeof window.innerWidth == 'number') || (typeof window.innerHeight == 'number')) {
        return [ window.innerWidth, window.innerHeight ];
    } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
        return [ document.documentElement.clientWidth, document.documentElement.clientHeight ];
    } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
        return [ document.body.clientWidth, document.body.clientHeight ];
    }
    return [ null, null ];
};

/**
 * Удаление элемента из DOM.
 */
dom.remove = function (el) {
    var pN = el.parentNode;
    pN && pN.removeChild(el);
};

/**
 * Bставка стилей в страницу.
 *
 * @param {Boolean} [sync] Синхронно или асинхронно.
 */
dom.appendStyle = function (css) {
    var style = document.createElement('style');
    style.setAttribute('type', 'text/css');

    if (style.styleSheet){ // IE
        style.styleSheet.cssText = css;
    } else { // W3C
        style.appendChild(document.createTextNode(css));
    }
    dom.getHead().appendChild(style);
    return style;
};

/**
 * Вставка скрипта в страницу.
 *
 * @param {Boolean} [sync] Синхронно или асинхронно.
 */
dom.addScript = function (src, sync) {
    if (sync) {
        document.write(
            '<script type="text/javascript" charset="utf-8" src="' + src + '"></script>'
        );
        return;
    }

    var script = document.createElement('script');
    // Кодировку выставляем прежде src, дабы если файл берется из кеша, он брался не в кодировке страницы.
    // Подобная проблема наблюдалась во всех IE как минимум до восьмой.
    script.charset = 'utf-8';
    script.src = src;
    dom.getHead().appendChild(script);
    return script;
};

dom.getScroll = function (el) {
    var origScroll = el.scrollTop;
    el.scrollTop += 20;
    var scrolled = el.scrollTop;
    el.scrollTop = origScroll;
    return scrolled;
};

/**
 * Проверяем, что как минимум часть площади элемента или весь элемент – во вьюпорте.
 *
 * @param {HTMLElement} element
 * @param {Number} [portion=1] Сколько процентов площади элемента должно
 * быть во вьюпорте (1 - весь элемент, 0.5 - 50% и т.д.)
 * @returns {Boolean}
 */
dom.isInViewport = function (element, portion) {
    portion = portion || Number.MIN_VALUE;

    // считаем перехлёст
    function clip(a, b) {
        return (a > b) ? (a - b) : 0;
    }

    var offset = dom.getXY(element),
        offsetLeft = offset.offsetLeft,
        offsetTop = offset.offsetTop,
        winWidth = dom.getWindowSize()[0],
        winHeight = dom.getWindowSize()[1],
        scrollLeft = dom.getWindowScroll()[0],
        scrollTop = dom.getWindowScroll()[1];

    // координаты вьюпорта отн. документа
    var viewport = {
        t: scrollTop,
        r: scrollLeft + winWidth,
        b: scrollTop + winHeight,
        l: scrollLeft
    };

    // координаты сторон объявления
    var banner = {
        t: offsetTop,
        r: offsetLeft + element.offsetWidth,
        b: offsetTop + element.offsetHeight,
        l: offsetLeft
    };

    // обкусывание баннера сторонами вьюпорта
    var clipping = {
        t: clip(viewport.t, banner.t),
        r: clip(banner.r, viewport.r),
        b: clip(banner.b, viewport.b),
        l: clip(viewport.l, banner.l)
    };

    var clippedArea = Math.floor((element.offsetWidth - clipping.r - clipping.l) *
        (element.offsetHeight - clipping.t - clipping.b));
    var fullArea = Math.floor(element.offsetWidth * element.offsetHeight);

    return (clippedArea / fullArea) >= portion;
};
;
    // Библиотека для работы с DOM событиями в том числе DOMContentLoaded, onLoad
var domEvent = {};

(function() {

// флаг используется здесь и ниже в методах ожидания ready
var documentHasAddEventListenerMethod = util.getNativeMethod(document, 'addEventListener');

// функции для навешивания и снятие событий с учетом кроссбраузерности и того
// что нативные методы могут быть переопределены.
var addEventListener = function(el, eventName, fn) {
    el.attachEvent('on' + eventName, fn);
};

var removeEventListener = function(el, eventName, fn) {
    el.detachEvent('on' + eventName, fn);
};

if (documentHasAddEventListenerMethod) {

    addEventListener = function(el, eventName, fn) {
        util.getNativeMethod(el, 'addEventListener').call(el, eventName, fn, false);
    };

    removeEventListener = function(el, eventName, fn) {
        util.getNativeMethod(el, 'removeEventListener').call(el, eventName, fn, false);
    };

};

/**
 * Add events to the DOM element. Events names should be similar to predefined
 * javascript DOM element event names.
 * @param {String} eventName Event name.
 * @param {Function} fn Event handler.
 * @param {Object} scope Event scope.
 * @param {Objects} [options] Options.
 * @param {Boolean} [options.onse] Pass true to fire event only once.
 * @return {Object} Описатель подписки, нужен если потребуется отписаться от события.
 */
domEvent.on = function(el, eventName, fn, scope, options) {
    if (!el || !fn) {
        return null;
    }

    // wrap provided handler into debugger-enabled container function
    var fireFn = env.protect(eventName + ' handler', fn, scope);
    // объект инкапсулирующий в себе логику отписки от события
    var descriptor = {
        un: function() {
            removeEventListener(el, eventName, fireFn);
        }
    }

    // function will clear itself after called, usefull when function need to be called once
    if (options && options.once) {
        fireFn = (function(origFireFn) {
            return function(e) {
                origFireFn(e);
                domEvent.un(descriptor);
            }
        })(fireFn)
    }

    addEventListener(el, eventName, fireFn);

    return descriptor;
};

/**
 * снимает обработчик на определенное ДОМ событие по описателю полученному из метода un
 * @param {Object} Описатель подписки, нужен если потребуется отписаться от события.
 */
domEvent.un = function(descriptor) {
    if (descriptor) {
        descriptor.un();
    }
};

/**
 * Добавляет обработчик на DOMContentLoaded с нужным scope, или выполняет его немедленно если событие отработало.
 * Код позаимствован из jQuery (https://github.com/jquery/jquery/blob/1.9-stable/src/core.js)
 * @param {Function} fn Event handler.
 * @param {Object} scope Event scope.
 */
domEvent.ready = function(callback, scope) {
    var protectedCallback = env.protect('ready', callback, scope);

    if (isReady) {
        protectedCallback();
    } else {
        callbacks.push(protectedCallback);
        if (!readyIsBound) {
            bindReady();
            readyIsBound = true;
        }
    }
};

var isReady = false;
var callbacks = [];
var readyIsBound = false;

function bindReady(callback) {
    // Catch cases where dom(document).ready() is called after the browser event has already occurred.
    // we once tried to use readyState "interactive" here, but it caused issues like the one
    // discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
    if ( document.readyState === "complete" ) {
        // Handle it asynchronously to allow scripts the opportunity to delay ready
        setTimeout( ready );

    // Standards-based browsers support DOMContentLoaded
    } else if ( documentHasAddEventListenerMethod ) {
        // Use the handy event callback
        addEventListener(document, "DOMContentLoaded", completed, false );

        // A fallback to window.onload, that will always work
        addEventListener(window, "load", completed, false );

    // If IE event model is used
    } else {
        // Ensure firing before onload, maybe late but safe also for iframes
        document.attachEvent( "onreadystatechange", completed );

        // A fallback to window.onload, that will always work
        window.attachEvent( "onload", completed );

        // If IE and not a frame
        // continually check to see if the document is ready
        var top = false;

        try {
            top = window.frameElement == null && document.documentElement;
        } catch(e) {}

        if ( top && top.doScroll ) {
            (function doScrollCheck() {
                if ( !isReady ) {

                    try {
                        // Use the trick by Diego Perini
                        // http://javascript.nwbox.com/IEContentLoaded/
                        top.doScroll("left");
                    } catch(e) {
                        return setTimeout( doScrollCheck, 50 );
                    }

                    // detach all dom ready events
                    detach();

                    // and execute any waiting functions
                    ready();
                }
            })();
        }
    }
}

function ready() {
    // Abort if there are pending holds or we're already ready
    if (isReady) {
        return;
    }

    // Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
    if ( !document.body ) {
        return setTimeout( ready );
    }

    // Remember that the DOM is ready
    isReady = true;

    for (var i = 0; i < callbacks.length; i++) {
        callbacks[i]();
    }
    callbacks = null;
}

function completed( event ) {
    // readyState === "complete" is good enough for us to call the dom ready in oldIE
    if ( documentHasAddEventListenerMethod || event.type === "load" || document.readyState === "complete" ) {
        detach();
        ready();
    }
}

// Clean-up method for dom ready events
function detach() {
    if ( documentHasAddEventListenerMethod ) {
        removeEventListener( document, "DOMContentLoaded", completed, false );
        removeEventListener( window, "load", completed, false );
    } else {
        document.detachEvent( "onreadystatechange", completed );
        window.detachEvent( "onload", completed );
    }
}

})();;
    var Observable;

(function() {
/**
 * Observer-subscriber class.
 * @class
 * @name Observable
 */
Observable = function() {
    this._listeners = {};
};

Observable.prototype = {
    /**
     * Выстреливает определенное событие, пробрасывая в слушателей неограниченное число парметров.
     * @function
     * @memberOf Observable
     * @param {String} eventName Event name.
     * @param {Any} [evData] Event data.
     * @returns {returnType} <краткое описание возвращаемого методом значения (если есть)>
     */
    fireEvent: function(eventName) {
        eventName = eventName.toLowerCase();

        var listeners = this._listeners[eventName];
        if (listeners) {
            listeners.fireEvent.apply(listeners, Array.prototype.slice.call(arguments, 1));
        }
    },
    /**
     * Подписка на событие.
     * @function
     * @memberOf Observable
     * @param {String} eventName Event name.
     * @param {Function} fn Event handler.
     * @param {Object} [scope] Event scope.
     * @param {Object} [options] Options.
     * @param {Boolean} [options.once] Event handler run once.
     */
    on: function(eventName, fn, scope, options) {
        if (!util.isFunction(fn)) {
            // это выход при подписке внешних обработчиков без проверки на их пустоту
            // в целом кажется это не то место где нужно это проверять
            // src/context/advmanager.js: block.on("afterRender", cfg.settings.onRender);
            return;
        }

        eventName = eventName.toLowerCase();
        scope = scope || this;

        var listeners = this._listeners[eventName];
        if (!listeners) {
            listeners = this._listeners[eventName] = new ListOfListeners();
        }
        listeners.on(fn, scope, options);
    },
    /**
     * Снятие слушателя с события.
     * @function
     * @memberOf Observable
     * @param {String} eventName Event name.
     * @param {Function} fn Event handler.
     * @param {Object} [scope] Event scope.
     */
    un: function(eventName, fn, scope) {
        eventName = eventName.toLowerCase();
        scope = scope || this;

        var listeners = this._listeners[eventName];
        if (listeners) {
            listeners.un(fn, scope);
        }
    }
};

/**
 * @class Класс список слушателей события.
 * @name ListOfListeners
 */
function ListOfListeners() {
    this._listeners = [];
};

ListOfListeners.prototype = {
    /**
     * Добавляет слушателя в список.
     * @param {Function} fn Event handler.
     * @param {Object} scope Event scope.
     * @param {Object} [options] Options.
     * @param {Boolean} [options.once] Event handler run once.
     */
    on: function(fn, scope, options) {
        options = options || {};

        if (this._getListenerIndex(fn, scope) === -1) {
            this._listeners.push(this._createListener(fn, scope, options));
        }
    },
    // ищет слушателя и возврает его индекс, если не найден возвращает -1
    _getListenerIndex: function(fn, scope) {
        for (var i = 0, l = this._listeners.length; i < l; i++) {
            if (this._listeners[i].fn == fn && this._listeners[i].scope == scope) {
                return i;
            }
        }
        return -1;
    },
    // создает слушателя из переданного хендлера учитывая парметры настроек
    _createListener: function(fn, scope, options) {
        var fireFn = fn;

        if (options.once) {
            var _this = this;
            fireFn = function () {
                _this.un(fn, scope);
                return fn.apply(scope, arguments);
            }
        }

        return {
            fn: fn, 
            scope: scope,
            fireFn: fireFn
        }
    },
    /**
     * Вызывает всех слушателей со списком переданных аргументов
     */
    fireEvent: function() {
        // создаем копию перед обходом, иначе если обработчик удалит сам себя, мы
        // пропустим один обработчик и попытаемся обратиться к не существующему элементу
        var ls = this._listeners.slice(0);

        for (var i = 0, l = ls.length; i < l; i++) {
            // TODO : понять пользуется ли кто-нибудь данным механизмом прерывания обработки
            // кажется в данном месте он будет скорее вреден чем полезен
            // данная логика используется в AdvManager, искать по слову suspendFiring
            if (ls[i].fireFn.apply(ls[i].scope, arguments) === false) {
                return;
            }
        }
    },
    /**
     * Удаляет слушателя из списка.
     * @param {Function} fn Event handler.
     * @param {Object} scope Event scope.
     */
    un: function(fn, scope) {
        var index = this._getListenerIndex(fn, scope);
        if (index !== -1) {
            this._listeners.splice(index, 1);
        }
    }
};

})();;

    /**
 * В данном объекте собраны методы которые меняют логику своей работы в зависимости от окружения.
 * Объект доступен только внутри партнерского кода.
 */
var env = {};

(function () {

/**
 * В DEV и DEBUG режимах пишет сообщения в лог. В RELEASE режиме игнорирует сообщения.
 * @param {String[]} arguments Текст сообщения.
 */
env.log = function () {
    if (isDebugMode() && window.console && console.log) {
        var message = Array.prototype.join.call(arguments, ' ');
        console.log('Ya:' + message);
    }
};

var DEBUG_TRIGGER_NAME = 'ya-context_debug_yes';
/**
 * true - если режимы DEV или DEBUG, false - если RELEASE.
 * Включить DEBUG можно добавив в урл строку ya-context_debug-mode_enabled.
 * А оперируя глобавльной переменной 'ya-context_debug-mode_enabled' режим отладки можно включать/выключать.
 */
function isDebugMode () {
    if (YA_DEV) {
        return true;
    }
    return window[DEBUG_TRIGGER_NAME] === true;
}

// При старте проверяем, не выставлен ли нужный нам флаг в урле
if (window.location.href.indexOf(DEBUG_TRIGGER_NAME) !== -1) {
    window[DEBUG_TRIGGER_NAME] = true;
    env.log('Debug mode has been enabled.');
}

/**
 * Пишет сообщение в удаленный лог. В DEV режиме переадресует сообщение в env.log.
 * В DEBUG и RELEASE режимах отправляет информацию об ошибке в удаленный лог.
 * Отправляет не более трех сообщений за сеанс. К каждому сообщению приписывается версия кода.
 * @param {String} message Текст сообщения.
 */
var remoteLogLimit = 3; 
env.remoteLog = function (message) {
    if (YA_DEV) {
        env.log('REMOTE_LOG:' + message);
        return;
    }

    if (remoteLogLimit-- > 0) {
        // раньше после jserr/ добавлялся parnterId, я его заменил на 1,
        // хотел на  0, но 0 не валидный pageId
        // потому что страницу можно будет взять из referer и этого должно
        // быть достаточно
        post('//an.yandex.ru/jserr/1', {
            // добавляем версию кода
            errmsg: 'v:' + Ya.codeVer + '::' + message
        });
    }
};

/**
 * Создает защищенную среду вокруг функции. В RELEASE режиме ловит возникающие исключения и передает 
 * их описание в env.remoteLog. В DEV и DEBUG режимах просто проксирует вызов.
 * @param {String} logPrefix Текст, который будет дописан в лог перед ошибкой.
 * @param {Function} func Функция.
 * @param {Object} [scope] Контекст.
 */
env.protect = function (logPrefix, func, scope) {
    return function () {
        if (isDebugMode()) {
            return func.apply(scope || this, arguments);
        }
        try {
            return func.apply(scope || this, arguments);
        } catch (e) {
            env.remoteLog('Error::' + logPrefix + '::' + e.message);
        }
    };
};

/**
 * Создает таймаут, окружая функцию защищенной средой.
 * @param {Function} func Функция.
 * @param {Number} timeout Время.
 * @param {Object} [scope] Контекст.
 */
env.setProtectedTimeout = function (func, timeout, scope) {
    return window.setTimeout(env.protect('timeout', func, scope), timeout);
};

})();
;
    util.ns('Ya.Context');

(function() {
    /**
     * Мгновенный контекст
     * Собирает заголовок страницы (title) и заголовки из текста (h123), 
     * пакует их в base64. Полученное знаечение передается при запросе баннеров
     * 
     * @param {Number} maxLength сколько у нас осталось места в урле запроса
     */
    Ya.Context.grab = function(maxLength, grab) {
        if (grab) {
            var allowedDomains = 'yandex.ru yandex.com yandex.ua yandex.by yandex.kz yandex.com.tr'.split(' '),
                host = document.location.host,
                i;
            for (i=0; i < allowedDomains.length; i++) {
                if (host.substr(host.length-allowedDomains[i].length, host.length) == allowedDomains[i]) {
                    return grab;
                }
            }
        }
        
        var parts = ['t' + (document.title || '')],
            totalLength = parts[0].length,
            i = 1, els, text;

        // собираем текст с h1 по h3
        while (i < 4 && totalLength < maxLength) {
            els = document.getElementsByTagName('h' + i);
            for (var j=0; j < els.length; j++) {
                text = getText(els[j]);
                totalLength += text.length;
                parts.push(i + '' + text);
            }
            i++;
        }

        var result = parts.join('\n');
        return base64.encode(result, maxLength);
    };    
    
    function getText (node) {
        return getTextRecursive(node, 0).replace(/\s+/, ' ');
    }

    /**
     * Максимальное число рекурсивных вызовов при формировании текста.
     * При нарушении вложенности тегов (кривая вёрстка) возможны ситуации,
     * когда "на ровном месте" образуется вложенность в несколько десятков элементов.
     * IE от этого зависает.
     */
    var maxRecursionDepth = 5;
    function getTextRecursive (node, depth) {
        if (!node || depth > maxRecursionDepth) return '';
        
        var result = "",
            children = node.childNodes,
            i = 0,
            child;

        while (i < children.length) {
            child = children[i];
            switch (child.nodeType) {
                case 1: // ELEMENT_NODE
                case 5: // ENTITY_REFERENCE_NODE
                    result += getTextRecursive(child, depth + 1);
                    break;
                case 3: // TEXT_NODE
                case 2: // ATTRIBUTE_NODE
                case 4: // CDATA_SECTION_NODE
                    result += child.nodeValue + ' ';
                    break;
            }
            i++;
        }
        return result;    
    }    
})();
;
    /**
 * Объект используемый для загрузки данных из БК.
 */
var advLoader;

(function () {
    advLoader = {
        loadRtb: loadRtb,
        loadDirect: loadDirect
    };

    /**
     * @param {Object} requestData
     * @param {String} requestData.pageId
     * @param {String} requestData.blockImpId
     * @param {String} [requestData.extParams]
     * @param {String} [requestData.skipToken]
     * @param {Function} callback
     */
    function loadRtb (requestData, callback) {
        request(getRtbUrl(requestData), callback);
    }

    /**
     * @param {Object} requestData
     * @param {String} requestData.pageId
     * @param {String} [requestData.skipBanner]
     * @param {String} [requestData.siteCharset]
     * @param {String} [requestData.statId]
     * @param {String} [requestData.grab]
     * @param {Function} callback
     */
    function loadDirect (requestData, callback) {
        request(getDirectUrl(requestData), callback);
    }

    /**
     * @param {String} url
     * @param {Function} callback
     */
    function request (url, callback) {
        var scriptTag;
        var callbackName = util.genRnd();
        // Если запрос сорвется, то это остановит все последующие обновления, чтобы это не
        // происходило, через 15 секунд эмулируем ответ без объявлений. Цифра 15 секунд взята
        // из головы, по соображению, что за это время ответ должен был загрузиться.
        var requestTimeout = env.setProtectedTimeout(function () {
            // Проверка продиктованная паранойей, теоретически если таймаут сработал, то
            // функция Ya[callbackName] должна существовать.
            if (Ya[callbackName]) {
                Ya[callbackName]('{}');
                // Возвращаем обработчик ответа в виде пустой функции, на тот случай если БК все-таки ответит,
                // т.е. по списку таких пустых обработчиков можно будет видеть сколько раз в этой сессии мы рвали
                // ожидание БК.
                Ya[callbackName] = function() {};
            }
        }, 15000);

        // JSONP callback эта функция вызовется при получении ответа от БК.
        Ya[callbackName] = function (dataStr) {
            env.log('loader.response: ' + url);

            // Сбрасываем таймаут если еще не сработал, или делаем
            // ненужный вызов если сработал, так как для
            // window.clearTimeout без разницы, то доп. проверок решил
            // не делать.
            window.clearTimeout(requestTimeout);

            // Кладем пустой объект в parsedData, если БК отдаст
            // невалидный ответ, это позволит нам не сломаться
            // и продолжить работу.
            var parsedData = {};

            // Парсинг данных полученных от БК, используется в таком
            // виде для отлова ошибок в выдаче от БК.
            try {
                delete Ya[callbackName];
                parsedData = (new Function('return ' + dataStr))();
            } catch (e) {
                env.remoteLog('JSONP parse::' + e.message + '::' + dataStr);
            }

            (env.protect('JSONP callback', function () {
                callback(parsedData);

                // Если есть указатель scriptTag, то удаляем
                // тег. Указателя не будет при синхронной загрузке
                // и если асинхронный запрос выполнится
                // синхронно. Последнее возможно только если наш
                // callbackName совпадет с ответом в кеше, вероятность
                // чего ничтожна.
                if (scriptTag) {
                    dom.remove(scriptTag);
                }
            })());
        };

        env.log('loader.request: ' + url);

        // При асинхронной загрузке возвращается указатель на тег, при синхронной undefined.
        // Синхронные подлючения не умеют обновляться, и для них проблема накопления тегов script в dom
        // не актуальна, а значит можно не чистить.
        scriptTag = dom.addScript(url + '&callback=Ya[' + callbackName + ']', !Ya.Context._asyncModeOn);
    }

    /**
     * @param {Object} requestData см. loadRtb
     * @return {String}
     */
    function getRtbUrl (requestData) {
        var url = '//bs-meta.yandex.ru/meta/' + requestData.pageId + '?';

        // генерируем параметры
        var params = getCommonParams(requestData);

        params['imp-id'] = requestData.blockImpId;
        params['flash-ver'] = browser.flashVer[0];

        if (requestData.skipToken) {
            params['skip-token'] = requestData.skipToken;
        }

        url += util.toQueryParams(params);

        // доп. параметры от пользователя, получаются в ставке кода
        url += requestData.extParams || '';

        // мгновенный контекст, граб со страницы
        if (location.protocol == 'http:') {
            url += '&grab=' + Ya.Context.grab(2040 - url.length);
        }

        return url;
    }

    /**
     * @param {Object} requestData см. loadDirect
     * @return {String}
     */
    function getDirectUrl (requestData) {
        var url = '//an.yandex.ru/page/' + requestData.pageId + '?';
        var params = getCommonParams(requestData);

        if (requestData.statId) {
            params['stat-id'] = requestData.statId;
        };

        if (requestData.skipBanner) {
            params['skip-banner'] = requestData.skipBanner;
        }

        if (requestData.searchText) {
            params['text'] = requestData.searchText;
            params['page-no'] = requestData.searchPageNumber;
        }

        // генерируем параметры
        url += util.toQueryParams(params);

        // мгновенный контекст, граб со страницы
        if (location.protocol == 'http:') {
            url += '&grab=' + Ya.Context.grab(2040 - url.length, requestData.grab);
        }

        return url;
    }

    /**
     * @param {Object} requestData см. getDirectUrl
     * @return {Object}
     */
    function getCommonParams (requestData) {
        var docRef;
        var targetRef;
        var regexNonASCII = punycode.regexNonASCII;
        // получаем данные о том откуда открыли страницу и т.д.
        // try catch на случай если мы стоим в ифрейме
        try {
            var host = window.top.document.location.host;
            docRef = window.top.document.referrer;
            targetRef = window.top.document.location.href;

            if (browser.isIE6 && targetRef === docRef) {
                docRef = '';
            }

            if (regexNonASCII.test(host)) {
                targetRef = targetRef.replace(host, punycode.toASCII(host));
            }

            // Следующая проверка работает корректно только, если хост реферера и текущий совпадают
            // или если реферер всегда в punycode. Решили выяснить, нужно ли вообще переводить домены для БК,
            // и взависимости от этого будем что-то делать.
            if (regexNonASCII.test(docRef)) {
                docRef = docRef.replace(host, punycode.toASCII(host));
            }

        } catch (e) {
            // если это ифрейм, то пробуем взять родительскую страницу из реферера
            targetRef = document.referrer || window.location.href;
            docRef = '';
        }

        var commonParams = {
            'target-ref': targetRef.substr(0, 512),
            'page-ref': docRef.substr(0, 512),
            'charset': 'utf-8'
        };

        if (requestData.lang) {
            commonParams['lang'] = requestData.lang;
        }

        return commonParams;
    }
})();
;
    /**
 * Рисуем предупреждения о табаке и алкоголе. Подбираем цвет рамки
 * и плашки так, чтобы она была контрастна к фону объявления
 *
 * Предупреждения иногда (маркет) приходят в виде текста, а иногда в виде
 * битовой маски. Если они приходят маской, то расшифровываем и выбираем одну
 * из сохраненных здесь строчек.
 */
Ya.Context.Warning = (function() {

    var IN  = [255, 247, 240, 231, 221, 210, 194, 174, 144, 112, 80, 35, 0],
        OUT = [255, 222, 190, 165, 139, 118, 102, 86,  75,  70,  68, 66, 64],
        bgK = 0.85;


    return {

        getBgColor: function(bgColor) {
            var color = new RGB(bgColor),
                grey  = color.avg(),
                i = 1;


            while (grey < IN[i]) {
                i++;
            }

            var smallerIn = IN[i],
                biggerIn  = IN[i - 1],
                smallerOut = OUT[i],
                biggerOut = OUT[i - 1],
                whiteAmmount = (smallerOut + 1.0 * (grey - smallerIn) / (biggerIn - smallerIn) * (biggerOut - smallerOut)) / 255,
                colorAmmount = 1.0 - whiteAmmount,
                whitePart = 255 * whiteAmmount;

            return new RGB(
                color[0] * colorAmmount + whitePart,
                color[1] * colorAmmount + whitePart,
                color[2] * colorAmmount + whitePart
            ).toString();
        },

        getBorderColor: function(bgColor, textColor) {
            var bgRGB = new RGB(bgColor),
                textRGB = new RGB(textColor);

            return new RGB(
                bgRGB[0] * bgK + textRGB[0] * (1-bgK),
                bgRGB[1] * bgK + textRGB[1] * (1-bgK),
                bgRGB[2] * bgK + textRGB[2] * (1-bgK)
            ).toString();
        }
    };
}());;

    /*
 Хранение всех контант в одном месте. Хорошее место для оптимизации по объему кода
 */

(function() {
util.ns('Ya.Const');

Ya.Const.BlockTypes = {
    VERTICAL: 'vertical',
    FLAT: 'flat',
    HORIZONTAL: 'horizontal',
    AUTO: 'auto',
    MOBILE: 'mobile',
    ROW: 'row',
    STRIPE: 'stripe'
};
// Расположение картинки:
Ya.Const.ImageLayout = {
    NONE: 'none', // без картинок
    FLOAT: 'float', // css float:left
    LEFT: 'left', // картинка слева, текст справа, обтекания нет
    FULL: 'full' // текст под картинкой
};
// Размер картинки в пикселях
// Значения доолжны, соответствовать ответу БК, менять нельзя
Ya.Const.ImageSize = {
    M: 'M', // 80px
    L: 'L' // 90px
};
// Ось для размера картинки
// Значения доолжны, соответствовать ответу БК, менять нельзя
Ya.Const.ImageAxis = {
    X: 'X',
    Y: 'Y'
};
Ya.Const.BorderTypes = {
    NONE: 'none',
    BLOCK: 'block',
    AD: 'ad'
};
Ya.Const.Products = {
    MARKET: 'market',
    PREMIUM: 'premium',
    DIRECT: 'direct'
};
// TODO : REMOVE UNUSED
Ya.Const.Header = {
    RIGHT: 'right',
    LEFT : 'left',
    BOTTOM: 'bottom',
    TOP: 'top',
    TOP_BOTTOM: 'top+bottom',
    TOP_RIGHT: 'top+right',
    BOTTOM_BOTTOM: 'bottom+bottom'
};




Ya.Const.Limits = {
    /**
     * @type Number
     * Интервал времени, не чаще которого можно перезагружать блок объявлений. При попытках обновлять блок чаще
     * ничего не будет происходить.
     */
    reloadTimeOut: 30000,
    /**
     * @type Number
     * Время зажержки перед проверкой видимости рекламного блока
     */
    visibCheckDelay: 2000,

    
    // @type Number
    // Время зажержки перед проверкой видимости промо-полоски     
    stripeVisibCheckDelay: 2000,

    minAdv: 1,

    maxAdv: 9
};

Ya.Const.Fonts = {
    fontNames: ['arial', 'courier new', 'tahoma', 'times new roman', 'verdana'],
    fontFamilies: ['sans-serif', 'serif', 'monospace'],
    fontSizeMin: 0.5,
    fontSizeMax: 2.5,
    fontSizeDef: 1,
    titleFontSizeSettingsDef: 3,
    titleFontSizeDef: '125%',
    fontSizeRanges: {
        1: [0 , 777],
        2: [0, 0.7, 0.8, 1.1, 777],
        3: [0, 0.9, 1.0, 1.1, 777]
    },
    titleFontSizes: {
        1: [107],
        2: [128, 125, 123, 116],
        3: [135, 130, 128, 125]
    }
};

var NONE    = 'none',
    INHERIT = 'inherit',
    AUTO    = 'auto',
    NORMAL = 'normal';

Ya.Const.cssReset = {
    background: 'transparent none no-repeat scroll 0 0',
    border: NONE,
    'border-radius': NONE,
    'border-spacing': 0,  // !!
    'border-collapse': 'collapse',  // !!
    '-moz-box-sizing': 'content-box',
    'box-sizing': 'content-box',
    clear: NONE,
    clip: AUTO,
    color: INHERIT,
    cursor: AUTO,
    'empty-cells': 'show',
    'float': NONE,
    font: INHERIT,
    'font-variant': NORMAL,
    'font-weight': NORMAL,
    height: AUTO,
    'letter-spacing': NORMAL,
    'line-height': NORMAL,
    margin: 0,
    'max-height': NONE,
    'max-width': NONE,
    'min-height': 0,
    'min-width': 0,
    outline: NONE,
    overflow: 'visible',
    padding: 0,
    position: 'static',
    'table-layout': AUTO,
    'text-align': 'left',
    'text-decoration': NONE,
    'text-indent': 0,
    'text-transform': NONE,
    'vertical-align': 'baseline',
    visibility: 'visible',
    'white-space': NORMAL,
    width: AUTO,
    'word-spacing': NORMAL,
    'z-index': AUTO
};

Ya.Const.config = {
    'autoRenderStripeBlock' : true
}

})();;
    /**
 * Adv blocks formats
 */
util.ns('Ya.Context.Direct');

(function () {

var BlockTypes = Ya.Const.BlockTypes;
var BorderTypes = Ya.Const.BorderTypes;
var HeaderTypes = Ya.Const.Header;

var formatsData = [
    {
        name:  BlockTypes.VERTICAL,
        fixed: false,
        type: BlockTypes.VERTICAL,
        limit: 9,
        header: [HeaderTypes.TOP, HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK, BorderTypes.AD]
    },
    {
        name: BlockTypes.FLAT,
        fixed: false,
        type: BlockTypes.FLAT,
        limit: 4,
        header: [HeaderTypes.TOP, HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK, BorderTypes.AD]
    },
    {
        name: BlockTypes.HORIZONTAL,
        fixed: false,
        type: BlockTypes.HORIZONTAL,
        limit: 4,
        header: [HeaderTypes.TOP, HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK, BorderTypes.AD]
    },
    {
        name: BlockTypes.AUTO,
        fixed: false,
        type: BlockTypes.HORIZONTAL,
        limit: 3,
        header: [HeaderTypes.TOP],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '160x600',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 5,
        header: [HeaderTypes.TOP_BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '240x400',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 4,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '200x300',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 3,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '300x300',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 4,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '300x250',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 3,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '250x250',
        fixed: true,
        type: BlockTypes.VERTICAL,
        limit: 3,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '728x90',
        fixed: true,
        type: BlockTypes.FLAT,
        limit: 3,
        header: [HeaderTypes.BOTTOM /*, HeaderTypes.TOP */],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '1000x120',
        fixed: true,
        type: BlockTypes.FLAT,
        limit: 4,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: BlockTypes.ROW,
        fixed: false,
        type: BlockTypes.ROW,
        limit: 1,
        skipWarnings: true,
        header: [HeaderTypes.LEFT],
        border: [BorderTypes.NONE]
    },
    {
        name: BlockTypes.MOBILE,
        fixed: false,
        type: BlockTypes.MOBILE,
        limit: 1,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: BlockTypes.STRIPE,
        fixed: false,
        type: BlockTypes.STRIPE,
        limit: 1,
        header: [HeaderTypes.BOTTOM],
        border: [BorderTypes.NONE]
    },
    {
        name: '100%x90',
        fixed: true,
        type: BlockTypes.FLAT,
        limit: 3,
        header: [HeaderTypes.BOTTOM /*, HeaderTypes.TOP */],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    },
    {
        name: '100%x120',
        fixed: true,
        type: BlockTypes.FLAT,
        limit: 4,
        header: [HeaderTypes.BOTTOM /*, HeaderTypes.TOP */],
        border: [BorderTypes.NONE, BorderTypes.BLOCK]
    }
];

// конструктор форматов, просто для удобства получения информации о правилах отрисовки каждого конкретного формата
function Format(data, index) {
    util.extend(this, data);
    this.index = index;
};

Format.prototype = {
    // размеры блока, метод для их получения
    getSize: function() {
        if (this.fixed) {
            return this.name.split('x');
        }
        return [-1, -1];
    }
};

var formatIndex = {};

util.each(formatsData, function(formatData, index) {
    formatIndex[formatData.name] = new Format(formatData, index);
});

// singleton менеджер форматов
Ya.Context.Direct.FormatManager = {
    // получение формата по имени
    getFormatByName: function(formatName) {
        return formatIndex[formatName] || null;
    },
    getDefaultFormat: function() {
        return formatIndex[BlockTypes.VERTICAL];
    }
};

})();
;
    (function () {

/**
 * Публичный интерфейс Ya.Context.AdvManager.
 */
Ya.Context.AdvManager = {
    // вызывается пользователями
    render: env.protect('AdvManager.render', renderRtb),
    // вызывается нами из метода Direct.insertInto (cм. context.js)
    renderDirect: env.protect('AdvManager.renderDirect', renderDirectCompat)
};

var queue = new Queue();

/**
 * Тут сохраняется последний полученный от БК adFilter для rtb.
 * В каждом следующем запросе к БК за rtb мы должны отправить adFilter полученный в ответе на предыдущий запрос.
 * Используется для борьбы с дублями.
 */
var rtbAdFilter = '';

// Индекс менеджеров rtb. По одному менеджеру на каждый блок.
var rtbProductManagers = {};
function getRtbManager (blockId) {
    return rtbProductManagers[blockId] || (rtbProductManagers[blockId] = new RtbManager(blockId));
}

// На все объявления директа один менеджер данных, потому что данные загружаются одной пачкой.
var globalDirectManager = null;
function getDirectManager () {
    return globalDirectManager || (globalDirectManager = new DirectManager('direct'));
}

/**
 * Отрисовывает блок rtb.
 * @param {Object} cfg
 * @param {Object} [cfg.data]
 * @param {String} cfg.blockId
 * @param {String} cfg.renderTo
 * @param {String} [cfg.extParams]
 * @param {Object} [cfg.externalParams]
 * @param {Function} altCallback
 */
function renderRtb (cfg, altCallback) {
    env.log('renderRtb ' + cfg.renderTo);

    var blockIdData = /^(\w)\-(\d+)\-(\d+)$/i.exec(cfg.blockId);
    cfg.pageId = blockIdData[2];
    cfg.blockImpId = blockIdData[3];

    callMetrikaHit(cfg.pageId);

    if (!Ya.Context._asyncModeOn) {
        window.yandex_rtb_is_displayed = true;

        // PCODE-322
        // На некоторых площадках стоит синхронное подлючение, при этом не указан или указан несуществующий
        // renderTo элемент.
        var renderToElement = dom('#' + cfg.renderTo);
        if (!renderToElement) {
            // Логируем плохое поведение, для дальнейшего обращения к площадке.
            // Нужно свести такие площадки на нет и убрать костыль.
            env.remoteLog('Warning:rtb.sync: unknown renderTo element ' + cfg.renderTo);
            // Создаем элемент сами, для обеспечения обратной совместимости.
            cfg.renderTo = 'Ya_sync_' + Ya.Context._asyncIdCounter++;
            document.write('<div id="' + cfg.renderTo + '"></div>');
        }
    }

    var noDataCallback = function () {
        if (!Ya.Context._asyncModeOn) {
            window.yandex_rtb_is_displayed = false;
        }
        if (altCallback) {
            altCallback();
        }
    }

    var rtbManager = getRtbManager(cfg.blockId);

    var parseData = function (data) {
        if (data.settings) {
            rtbAdFilter = data.settings[cfg.blockImpId].adFilter;
        }
        rtbManager.setData(data);
        rtbManager.render(cfg, noDataCallback);
    };

    if (cfg.data) {
        parseData(cfg.data);
        return;
    }

    if (!rtbManager.dataCanReload()) {
        rtbManager.render(cfg, noDataCallback);
        return;
    }

    queue.add(function (next) {
        advLoader.loadRtb(
            {
                pageId: cfg.pageId,
                blockImpId: cfg.blockImpId,
                extParams: cfg.extParams,
                skipToken: getRtbSkipToken(rtbManager),
                lang: cfg.lang
            },
            function (data) {
                checkStripe(data);
                parseData(data);
                next();
            }
        );
    });
}

function getRtbSkipToken (rtbManager) {
    var filterPaths = rtbAdFilter ? rtbAdFilter.split(':') : [];

    filterPaths = util.filter(filterPaths, function (filterSegment) {
        return !/^yabs\./.test(filterSegment);
    });

    var capturedAdIds = rtbManager.getSkipAds();
    if (capturedAdIds.length) {
        filterPaths.push('yabs.' + base64.encode(capturedAdIds.join('\n')));
    }

    return filterPaths.join(':');
}

/**
 * Метод размещения директа.
 * @param {Object} partnerId Идентификатор страницы.
 * @param {Object} elementId Идентификатор элемента, в котором нужно отрисовать блок.
 * @param {Object} settings Настройки блока.
 * @param {Object} [settings.data] Данные, которые нужно показать.
 * @param {Function} altCallback Обработчик, на случай пустого ответа БК.
 */
function renderDirectCompat (partnerId, elementId, settings, altCallback) {
    // PCODE-323
    // На e.mail.ru при обновлении блока не указан partnerId.
    // Так как раньше мы сохраняли partnerId глобально, это работало.
    // Для обратной совместимости делаем также.
    if (!partnerId) {
        partnerId = Ya.Context._globalPartnerId;
    } else {
        Ya.Context._globalPartnerId = partnerId;
    }

    var camelizedSettings = {};
    for (var name in settings) {
        if (settings.hasOwnProperty(name)) {
            camelizedSettings[util.camelize(name)] = settings[name];
        }
    }

    // переименования
    camelizedSettings.name = camelizedSettings.type;
    camelizedSettings.product = camelizedSettings.adFormat;

    renderDirect(
        {
            renderTo: elementId,
            pageId: partnerId,
            data: settings.data
        },
        camelizedSettings,
        altCallback
    );
};

/**
 * Отрисовывает блок директа.
 * @param {Object} cfg
 * @param {Object} [cfg.data]
 * @param {String} cfg.pageId
 * @param {String} cfg.renderTo
 * @param {Object} settings
 * @param {Function} altCallback
 */
function renderDirect (cfg, settings, altCallback) {
    env.log('renderDirect ' + cfg.renderTo);

    callMetrikaHit(cfg.pageId);

    settings = Ya.Context.AdvManager.settings.validate(settings);
    if (!settings) {
        env.log('renderDirect: incorrect block settings');
        return;
    }

    if (!Ya.Context._asyncModeOn) {
        window.yandex_ad_is_displayed = true;
    }

    var noDataCallback = function () {
        if (!Ya.Context._asyncModeOn) {
            window.yandex_ad_is_displayed = false;
        }
        if (altCallback) {
            altCallback();
        }
    }

    var directManager = getDirectManager();

    var parseData = function (data) {
        directManager.setData(data);
        directManager.render(cfg, settings, noDataCallback);
    }

    if (cfg.data) {
        parseData(cfg.data);
        return;
    }

    queue.add(function (next) {
        if (!directManager.dataCanReload()) {
            directManager.render(cfg, settings, noDataCallback);
            next()
            return;
        }

        advLoader.loadDirect(
            {
                pageId: cfg.pageId,
                skipBanner: directManager.getSkipBanners().join('\n'),
                siteCharset: settings.siteCharset,
                statId: settings.statId,
                grab: settings.grab,
                searchText: settings.searchText,
                searchPageNumber: settings.searchPageNumber || 1,
                lang: settings.lang
            },
            function (data) {
                checkStripe(data);
                parseData(data);
                next();
            }
        );
    });
}

/**
 * Если в ответе пришла полоска, показываем ее.
 */
function checkStripe (data) {
    if (data.stripe) {
        Ya.HeadStripe.loadStripeData(data);
    }
}

/**
 * Отправляет запрос метрики. Отправляться должен только один запрос за сессию.
 */
function callMetrikaHit (pageId) {
    metrikaHit(pageId);
    callMetrikaHit = function () {};
}

function metrikaHit (pageId) {
    (window['yandex_metrika_callbacks'] || (window['yandex_metrika_callbacks'] = [])).push(
        env.protect('mc', function () {
            // http://help.yandex.ru/metrika/objects/creating-object.xml
            // В качестве counterId передаем pageId.
            // type: 1 - это маркер счетчика РСЯ.
            // _exp - это флаг на время эксперимента, для отличия по логам.
            window['yaCounter' + pageId] = new Ya.Metrika({id: pageId, type: 1, _exp: true});
        })
    );

    dom.addScript('//mc.yandex.ru/metrika/watch.js');
}

/**
 * Класс организующий очередь исполнения.
 * @class
 */
function Queue () {
    var order = [];
    var executed = false;
    var finish = function () {
        if (order.length) {
            order.shift()(finish);
        } else {
            executed = false;
        }
    };

    return {
        /**
         * Добавляет задачу в очередь исполнения.
         * Когда приходит очередь задачи, функция задачи будет вызвана с параметром finish.
         * Когда задача завершит работу, она должна вызвать параметр finish.
         * @param {function} task Задача на исполнение.
         * @example
         * queue.add(function (finish) {
         *   // do something async
         *   finish();
         * });
         */
        add: function (task) {
            if (!executed) {
                executed = true;
                task(finish);
            } else {
                order.push(task);
            }
        }
    }
};

})();
;
    var RtbManager;
(function () {

/**
 * Менеджер rtb. По одной инстанции на каждый блок rtb.
 * @class
 * @param {String} key Ключ инстанции.
 */
RtbManager = function (key) {
    // Ответ БК.
    var data;
    // Дата последнего обновления data.
    var timestamp;
    // Ссылка на инстанциб лока.
    var block;
    // Источник данныз для rtb блока.
    var rtbDataSource;
    // Менеджер директа.
    var directManager = new DirectManager(key);

    /**
     * Метод задания данных. Может вызываться много раз.
     * @param {Object} data
     * @param {Object} data.rtb
     * @param {String} data.rtb.html
     * @param {Object} data.settings
     * @param {Object} data.settings[blockImpId]
     */
    this.setData = function (newData) {
        data = newData;
        timestamp = new Date();

        rtbDataSource = null;
        directManager.setData({});

        if (data.direct) {
            directManager.setData(data);
        }
    };

    /**
     * Можно ли обновлять данные.
     * @return {Boolean} true - можно, false - нет.
     */
    this.dataCanReload = function () {
        return !timestamp || new Date() - timestamp > Ya.Const.Limits.reloadTimeOut;
    };

    /**
     * Метод отрисовки блока.
     * @param {Object} cfg
     * @param {String} cfg.blockId
     * @param {String} cfg.renderTo
     * @param {Object} [cfg.externalParams]
     * @param {Function} noDataCallback
     */
    this.render = function (cfg, noDataCallback) {
        if (block) {
            block.destructor();
        }

        if (data.rtb) {
            if (!rtbDataSource) {
                var settings = Ya.Context.AdvManager.settings.validate(data.settings[cfg.blockImpId]);
                rtbDataSource = new RtbDataSource(data, settings);
            }

            block = new RtbBlock(rtbDataSource, cfg.renderTo, cfg.blockId, cfg.externalParams);
            block.render();
            return;
        }

        if (data.direct) {
            var directSettings = Ya.Context.AdvManager.settings.validate(data.settings[cfg.blockImpId]);
            var directCfg = {
                renderTo: cfg.renderTo
            };
            directManager.render(directCfg, directSettings);

            // В качестве блока используем заглушку, целью которой будет обнулить директ.
            block = {
                destructor: function () {
                    if (!data.direct) {
                        directManager.render(directCfg, directSettings);
                    }
                }
            }
            return;
        }

        noDataCallback();
    }

    /**
     * Возвращает данные для параметра skipToken - список идентификаторов объявлений используемых
     * в других менеджерах директа.
     * @return {Array} Список идентификаторов объявлений для параметра skipToken.
     */
    this.getSkipAds = function () {
        return directManager.getSkipBanners();
    };
};

/**
 * Источник данных для продукта "Rtb".
 * @class
 * @param {Object} data
 * @param {Object} data.rtb
 * @param {String} data.rtb.html
 */
function RtbDataSource (data, settings) {
    var decodedHtml;

    /**
     * @return {Object} Настройки блока.
     */
    this.getSettings = function () {
        return settings;
    };

    /**
     * @return {String} Html для отображения внутри iframe.
     */
    this.getHtml = function () {
        if (!decodedHtml) {
            decodedHtml = base64.decode(data.rtb.html);
        }
        return decodedHtml;
    };

    /**
     * Отправка подтверждения видимости делается один раз, на блок. И один раз за время жизни порции данных.
     * Если данные были обновлены подтверждения видимости сбрасываются путем пересоздания dataSource.
     */
    var sentVisibility;

    /**
     * Оповещение о подтверждении видимости.
     */
    this.onConfirmVisibility = function () {
        if (!sentVisibility) {

            // В отличии от директа, у ртб в linkTail лежит весь URL целиком.
            if (settings.linkTail) {
                (new Image()).src = settings.linkTail;
            }

            if (settings.viewNotice) {
                // проверка видимости DSP
                // отсылаем через image потому что слать через script опасно, если DSP вернет
                // вредосносный скрипт браузер его исполнит
                (new Image()).src = settings.viewNotice;
            }

            sentVisibility = true;
        }
    };
}

})();
;
    /**
 * Менеджер директа. По одной инстанции на каждый блок rtb и одна инстанции на все блоки директа.
 * @class
 * @param {String} key Ключ инстанции.
 */
function DirectManager (key) {
    this._key = key;
    // Ответ БК.
    /// this._data = null;

    // Дата последнего обновления data.
    /// this._timestamp = null;

    /// this._visibilityManager = null;

    // Список инстанций блоков.
    this._blocks = {};

    /// this._marketDataSource = null;
}

DirectManager.prototype = {
    /**
     * Метод задания данных. Может вызываться много раз.
     * @param {Object} data Описание данных можно посмотреть в dataSource продуктов.
     */
    setData: function (newData) {
        this._data = newData;
        // Храним подтверждения видимости, только в рамках одной порции данных.
        // Используется только для продукта директ.
        this._visibilityManager = new DirectManager.VisibilityManager();
        this._marketDataSource = null;
        this._timestamp = new Date();
    },

    /**
     * Можно ли обновлять данные.
     * @return {Boolean} true - можно, false - нет.
     */
    dataCanReload: function () {
        return !this._timestamp || new Date() - this._timestamp > Ya.Const.Limits.reloadTimeOut;
    },

    /**
     * Метод отрисовки блока.
     * @param {Object} cfg
     * @param {String} [cfg.renderTo]
     * @param {Object} settings
     * @param {Function} [noDataCallback]
     */
    render: function (cfg, settings, noDataCallback) {
        // Для синхронных подключений renderTo всегда есть, потому что мы его генерируем. А вот для асинхронных
        // подключений renderTo в случае stripe и auto блоков не задан. Но так как stripe и auto могут быть
        // только по одному разу на страницу, уникальности renderId это не вредит. renderId не совпадает с blockId,
        // потому что мы хотим позволять менять тип блока.
        var renderId = cfg.renderTo || settings.format.name;

        if (this._blocks[renderId]) {
            this._blocks[renderId].destructor();
        }

        // blockId, состоит из id элемента и типа блока разделенными дефисом. Если renderTo нет, то остается
        // начинающийся с минуса тип плока.
        this._blocks[renderId] = this._createBlock(cfg, settings, (cfg.renderTo || '') + '-' + settings.format.name);

        if (this._blocks[renderId]) {
            this._blocks[renderId].render();
        } else {
            if (noDataCallback) {
                noDataCallback();
            }
        }
    },

    _createBlock: function (cfg, settings, blockId) {
        var dataSource = this._createDataSource(settings);
        // нет данных для отрисовки объявлений
        if (dataSource.isEmpty()) {
            return null;
        }

        var productType = Ya.Const.Products.DIRECT; // the default
        if (settings.product == Ya.Const.Products.MARKET) {
            productType = Ya.Const.Products.MARKET;
        }
        var blockConstructor = Ya.Context[util.capitalize(productType)][
            util.capitalize(settings.format.name)
        ];

        return new blockConstructor(dataSource, settings, cfg.renderTo, blockId);
    },

    _createDataSource: function (settings) {
        var DSConstructor;
        switch (settings.product) {
            case Ya.Const.Products.MARKET:
                return this._marketDataSource || (this._marketDataSource = new MarketDataSource(this._data));
            case Ya.Const.Products.DIRECT:
                DSConstructor = StandardDirectDataSource;
                break;
            case Ya.Const.Products.PREMIUM:
                DSConstructor = PremiumDirectDataSource;
                break;
        }

        if (DSConstructor) {
            return new DSConstructor(
                this._data,
                this._key,
                settings,
                DirectManager.capturingManager,
                this._visibilityManager
            );
        }
    },

    /**
     * Возвращает данные для параметра skipBanner - список идентификаторов объявлений используемых
     * в других менеджерах директа.
     * @return {Array} Список идентификаторов объявлений для параметра skipBanner.
     */
    getSkipBanners: function () {
        return DirectManager.capturingManager.getCapturedAdIds(this._key);
    }
};

/**
 * В объекте хранится список используемых в данный момент объявлений директа. Используется для борьбы с дублями:
 * 1. Отсутствие объявления в списке используемых проверяется при выдаче объявлений для блока.
 * 2. Список идентификаторов используемых объявлений отправляется в БК при запросе новых объявлений.
 */
DirectManager.capturingManager = (function () {
    var capturedAdIdsIndex = {};

    return {
        /**
         * Захватить объявление.
         * @param {String} key Ключ пользователя. Это blockId для rtb или 'direct' для остальных.
         * @param {String} adId Идентификатор объявления.
         */
        capture: function (key, adId) {
            if (!capturedAdIdsIndex[key]) {
                capturedAdIdsIndex[key] = [];
            }
            capturedAdIdsIndex[key].push(adId);
        },

        /**
         * Освободить объявление.
         * @param {String} key Ключ пользователя. Это blockId для rtb или 'direct' для остальных.
         * @param {String} adId Идентификатор объявления.
         */
        release: function (key, adId) {
            var capturedAdByKey = capturedAdIdsIndex[key];
            if (capturedAdByKey) {
                var index = util.inArray(capturedAdByKey, adId);
                if (index !== -1) {
                    capturedAdByKey.splice(index , 1);
                }
            }
        },

        /**
         * Возвращает список используемых объявлений. Можно получить список исключая определенного пользователя.
         * @param {String} [exceptKey] Исключая объявления используемые пользователем exceptKey.
         * @return {Array} Список идентификаторов используемых объявлений.
         * @example
         * directCapturedAdStore.getCapturedAdIds() // список всех используемых объявлений
         * @example
         * directCapturedAdStore.getCapturedAdIds('R-13121-1') // кроме блока R-13121-1
         */
        getCapturedAdIds: function (exceptKey) {
            var capturedAdIds = [];
            util.each(util.keys(capturedAdIdsIndex), function (key) {
                if (key !== exceptKey) {
                    capturedAdIds = capturedAdIds.concat(capturedAdIdsIndex[key]);
                }
            });
            return capturedAdIds;
        }
    }
})();

/**
 * Объект для хранения списка статуса об отправленности подтверждения видимости для объявлений.
 * @class
 */
DirectManager.VisibilityManager = function () {
    var index = {};

    return {
        /**
         * Нужно ли отправлять подтверждение видимости для данной сущности.
         * @param {String} Идентификатор.
         * @return {Boolean}
         */
        needConfirm: function (id) {
            return !index[id]
        },

        /**
         * Помечает что для данного id, подтверждение видимости отправлено.
         * @param {String} Идентификатор.
         */
        confirm: function (id) {
            index[id] = true;
        }
    }
};
;
    /**
 * Источник данных для продукта "Директ".
 * Источник данных для продуктов, похожих на "Директ".
 * По одной инстанции на каждый блок директа.
 * @class
 * @param {Object} data
 * @param {Object} data.common
 * @param {String} data.common.linkHead
 * @param {Array} data.common.domains
 * @param {String} data.common.deviceType
 * @param {Object} data[type]
 * @param {Array} data[type].ads
 * @param {Object} data[type].linkAll
 * @param {String} data[type].linkAll.title
 * @param {String} data[type].linkAll.url
 * @param {Object} data[type].#type#Title
 * @param {String} data[type].#type#Title.title
 * @param {String} data[type].#type#Title.url
 * @param {String} key Ключ родительского DirectManager. Нужен для работы с directCapturedAdStore.
 */
var CommonDirectDataSource = util.augment({}, {
    constructor: function(data, key, settings, capturingManager, visibilityManager) {
        this._data = data;
        this._key = key;
        this._settings = settings;
        this._capturingManager = capturingManager;
        this._visibilityManager = visibilityManager;

        // Список объявлений.
        this._ads = [];
        var ads = this._getFromData('ads');
        if (ads) {
            this._ads = util.map(ads, this._prepareAd, this);
        }
    },

    /**
     * @returns {String} Тип продукта и одноименная секция данных.
     */
    getType: function () {},

    _getFromData: function (prop) {
        var type = this.getType();
        return this._data[type] && this._data[type][prop];
    },

    _prepareAd: function (originalAd) {
        var ad = util.extend({}, originalAd);

        var linkTail = this._getLinkTailExt();
        ad.url += linkTail;
        if (ad.vcardUrl) {
            ad.vcardUrl += linkTail;
        }
        if (ad.callUrl) {
            ad.callUrl += linkTail;
        }

        if (ad.images) {
            ad.images = this._prepareImages(ad.images);
        }

        ad.site = ad.domain ? ad.domain.replace(/^www\./, '') : '';

        if (this._settings.favicon) {
            if (ad.domain) {
                ad.favicon = '//favicon.yandex.net/favicon/' + punycode.toASCII(ad.domain);
            }
        }

        // Сайтлинки
        if (this._settings.noSitelinks || !ad.sitelinks) {
            ad.sitelinks = null;
        } else {
            ad.sitelinks = this._prepareSitelinks(ad.sitelinks, linkTail);
        }

        // Типография для текста объявления.
        ad.body = util.prettify(ad.body, {gluePrepositions: !ad.images});
        ad.title = util.prettify(ad.title);

        return ad;
    },

    /**
     * Допольнительные параметры в ссылках объявлений (testTag и срез)
     * @return String
     */
    _getLinkTailExt: function() {
        return '?' + util.toQueryParams({
            'test-tag': this._getTestTag(),
            'stat-id': this._settings.statId
        });
    },

    /**
     * Собирает testTag параметр для заданных настроек и объявлений.
     * testTag – битовая маска (31 бит) с произовльным контентом. Контент определяется текущим экспериментом.
     * testTag - не отправляется для медийных объявлений в rtb.
     */
    _getTestTag: function() {

        var properties = [
            // Базовые поля
            [4, 1], // 4 бита привязка к типу кода, всегда 0001
            [3, Ya.codeVer % 8], // 3 бита под версию js-кода (остаток от деления версии на 8)
            [3, Ya.loaderVer % 8], // 3 бита под версию загрузчика js-кода (остаток от деления версии на 8)
            [5, this._settings.format.index], // 5 бит под тип блока
            // Дополнительные поля
            [1, window.top !== window.self], // 1 бит на подключен ли код внутри ифрейма
            [1, !!this._settings.c11n.arrowTextColor],
            [1, !!this._settings.c11n.minWidth],
            [1, !!this._settings.c11n.itemPadding],
            [1, !!this._settings.c11n.arrowTextUnderline],
            [1, !!this._settings.c11n.textClickable],
            [1, !!this._settings.bgStartColor],
            [1, !!this._settings.bgEndColor]
        ];

        var testTag = 0;

        for (var i = 0, shift = 0; i < properties.length; i++) {
            testTag |= properties[i][1] << shift;
            shift += properties[i][0];
        }

        return testTag;
    },

    /*
        Строит индекс по размерам. Подразумевается что по каждой оси могут быть
        разные изображения под каждый размер.
        Для ответа:
            "images": [
                ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/x90", 90, 90],
                ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/x90", 90, 90],
                ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/x80", 80, 80],
                ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/y80", 80, 80]
            ]
        Будет:
            images['M']: {
                X: ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/y80", 80, 80],
                Y: ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/y80", 80, 80]
            }
            images['L']: {
                X: ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/x90", 90, 90],
                Y: ["//avatars-fast.yandex.net/get-direct/-feoMWq9t0mqgOCI07Z6BA/x90", 90, 90]
            }
    */
    _prepareImages: function (originalImages) {
        var images = {};

        var dim = {M: 80, L: 90};
        util.each(originalImages, function (img) {
            for (var size in dim) {

                images[size] = images[size] || {};

                if (img[1] == dim[size]) {
                    images[size].X = img;
                }

                if (img[2] == dim[size]) {
                    images[size].Y = img;
                }
            }
        });

        return images;
    },

    /**
     * @param {Object[]} origSitelinks
     * @param {String} linkTail
     * @returns {?Object[]}
     */
    _prepareSitelinks: function (origSitelinks, linkTail) {
        var result = [];
        util.each(origSitelinks, function (link) {
            // БК всегда присылает 3 сайтлинка, но иногда пустые
            if (link.title && link.url) {
                result.push({
                    title: util.prettify(link.title),
                    url: link.url + linkTail
                });
            }
        });
        return result.length ? result : null;
    },

    /**
     * Есть ли данные.
     * @return {Boolean} true - есть, false - нет.
     */
    isEmpty: function () {
        return this._ads.length === 0;
    },

    /**
     * @return {String} Основа для формирования ссылок в объявлениях.
     */
    getLinkHead: function () {
        return this._data.common.linkHead;
    },

    /**
     * @return {Object} Заголовок продукта. {title: '', url: ''}.
     */
    getTitle: function () {
        return this._getFromData(this.getType() + 'Title');
    },

    /**
     * @return {Object} Ссылка "Все объявления". {title: '', url: ''}.
     */
    getFreeAds: function () {
        var capturedAdIds = this._capturingManager.getCapturedAdIds();
        var freeAds = util.filter(this._ads, function (ad) {
            return util.inArray(capturedAdIds, ad.adId) === -1;
        });
        return freeAds;
    },

    /**
     * Cписок захваченных объявлений ведется посредством объекта _capturingManager.
     */
    releaseAd: function (ad) {
        this._capturingManager.release(this._key, ad.adId);
    },

    /**
     * Cписок захваченных объявлений ведется посредством объекта _capturingManager.
     */
    captureAd: function (ad) {
        this._capturingManager.capture(this._key, ad.adId);
    },

    /**
     * Оповещение об отправке проверки видимости для объявления.
     * Для каждого объявления потверждение отправляется один раз за время жизни порции данных. Если данные были
     * обновлены подтверждения видимости сбрасываются путем пересоздания dataSource.
     * @param {Array} ads Список объявлений.
     */
    onConfirmVisibility: function (ads) {
        // Отбрасываем объявления для которых уже отправлено подтверждение видимости.
        var unconfirmedAds = util.filter(ads, function (ad) {
            return this._visibilityManager.needConfirm(ad.linkTail);
        }, this);

        if (!unconfirmedAds.length) {
            return;
        }

        var commonLinkTail = util.map(unconfirmedAds, function (ad) {
            return ad.linkTail;
        }).join('');

        (new Image()).src = this.getLinkHead() + commonLinkTail + this._getLinkTailExt() + '&wmode=0';

        util.each(unconfirmedAds, function (ad) {
            this._visibilityManager.confirm(ad.linkTail);
        }, this);
    }
});
;
    /**
 * Источник данных для обычного "Директa".
 * {@see CommonDirectDataSource}
 */
var StandardDirectDataSource = util.augment(CommonDirectDataSource, {
    getType: function () {
        return 'direct';
    },

    ///_rtbVisibilityConfirmed: false,

    onConfirmVisibility: function (ads) {
        // Это директ приехавший через РТБ, нужно отправить подтверждение
        // показа, для зачисления его в актив площадки.
        // Отправляем только один раз за сессию.
        if (this._settings.linkTail && !this._rtbVisibilityConfirmed) {
            (new Image()).src = this._settings.linkTail;
            this._rtbVisibilityConfirmed = true;
        }

        // call super method afterwards
        StandardDirectDataSource.superclass.onConfirmVisibility.call(this, ads);
    }
});
;
    /**
 * Источник данных для "Спецразмещения" на поисковых сайтах.
 * {@see CommonDirectDataSource}
 */
var PremiumDirectDataSource = util.augment(CommonDirectDataSource, {
    getType: function () {
        return 'premium';
    }
});
;
    /**
 * Источник данных для продукта "Маркет".
 * Одна инстация на все блоки маркета.
 * @class
 * @param {Object} data
 * @param {Object} data.common
 * @param {String} data.common.linkHead
 * @param {Array} data.common.domains
 * @param {String} data.common.deviceType
 * @param {Object} data.market
 * @param {Array} data.market.ads
 * @param {Array} data.market.linkConf - замена для data.common.linkHead
 * @param {Object} data.market.marketTitle
 * @param {String} data.market.marketTitle.title
 * @param {String} data.market.marketTitle.url
 */
function MarketDataSource (data) {
    this._data = data;

    // Список объявлений.
    this._ads = [];
    // Список захваченных объявлений.
    this._capturedAd = [];

    if (this._data.market) {

        if (this._data.market.ads) {
            this._ads = util.map(this._data.market.ads, this._prepareAd, this);
        }

        // Проверка видимости отсутствует, сразу подтверждаем.
        // Ссылка на проверку видимости одна на все объяления.
        (new Image()).src = this._data.market.linkConf;
    }
}

MarketDataSource.prototype = {
    _prepareAd: function (originalAd) {
        var ad = util.extend({}, originalAd);

        if (ad.body) {
            ad.body = util.prettify(ad.body);
        }

        if (ad.title) {
            ad.title = util.prettify(ad.title);
        }

        if (ad.domain) {
            ad.site = ad.domain.replace(/^www\./, '');
        }

        return ad;
    },

    /**
     * Есть ли данные.
     * @return {Boolean} true - есть, false - нет.
     */
    isEmpty: function () {
        return this._ads.length === 0;
    },

    /**
     * @return {Array} Cписок объявлений доступных к показу. Может быть пустым.
     */
    getFreeAds: function () {
        return util.filter(this._ads, function (ad) {
            return util.inArray(this._capturedAd, ad) === -1;
        }, this);
    },

    /**
     * Позволяет захватить объявление.
     * @param {String} Идентификатор объявления.
     */
    captureAd: function (ad) {
        this._capturedAd.push(ad);
    },

    /**
     * Позволяет освободить объявление.
     * @param {String} Идентификатор объявления.
     */
    releaseAd: function (ad) {
        var index = util.inArray(this._capturedAd, ad);
        if (index !== -1) {
            this._capturedAd.splice(index, 1);
        }
    },

    /**
     * @return {Object} Заголовок продукта. {title: '', url: ''}.
     */
    getTitle: function () {
        return this._data.market.marketTitle;
    },

    /**
     * Оповещение об отправке проверки видимости.
     */
    onConfirmVisibility: function () {}
};
;
    Ya.Context.AdvManager.settings = {
    validate: function (settings) {
        if (!settings.product) {
            // Продукта нет в ответе ртб. Но мы знаем, что там либо директ либо ртб.
            settings.product = Ya.Const.Products.DIRECT;
        } else if (
            settings.product !== Ya.Const.Products.DIRECT
            && settings.product !== Ya.Const.Products.MARKET
            && settings.product !== Ya.Const.Products.PREMIUM
        ) {
            // Если мы не знаем такого продукта, то выходим.
            return null;
        }

        settings.statId = parseInt(settings.statId, 10);
        if (isNaN(settings.statId)) {
            settings.statId = '';
        }
        
        settings.format = Ya.Context.Direct.FormatManager.getFormatByName(settings.name);
        // TODO: есть разумное предложение, что если формат задан и он не верен то не показывать ничего
        // к дефолту обращаться только если формат не указан вовсе
        if (!settings.format) {
            switch (settings.name) {
                case '600x60':
                case '468x60':
                case '234x60':
                case '180x150':
                case '125x125':
                case '120x240':
                case '120x600':
                    return null;

                default:
                    settings.format = Ya.Context.Direct.FormatManager.getDefaultFormat();
            }

        }

        settings.limit = util.checkValue(parseInt(settings.limit, 10), Ya.Const.Limits.minAdv, Ya.Const.Limits.maxAdv, Ya.Const.Limits.maxAdv);

        var format = settings.format,
            size = format.getSize();

        settings.width = size[0];
        settings.height = size[1];

        if (util.inArray(format.border, settings.borderType) == -1){
            settings.borderType = format.border[0];
        }

        settings.borderRadius = Boolean(settings.borderRadius);

        //settings.headerPosition = 'top';
        if (util.inArray(format.header, settings.headerPosition) == -1){
            settings.headerPosition = format.header[0];
        }

        // c11n == customization, this external hash should be used for all kinds of nasty, ugly, utterly inappropriate, last-minute hacks
        settings.c11n = settings.c11n || {};

        this._validateColors(settings);
        this._validateFonts(settings);

        this._validateFontSizes(settings);

        return settings;
    },

    _validateFonts: function (settings) {

        var fontConst = Ya.Const.Fonts,
            fontNames = fontConst.fontNames,
            fontFamilies = fontConst.fontFamilies,
            fontInd = util.inArray(fontNames, settings.fontFamily);

        if (fontInd == -1) {
            settings.fontFamily = 'inherit';
        } else if (fontInd == 1) {
            settings.fontFamily += ', ' + fontFamilies[2];
        } else if (fontInd == 3) {
            settings.fontFamily += ', ' + fontFamilies[1];
        } else {
            settings.fontFamily += ', ' + fontFamilies[0];
        }

        return settings;
    },

    _validateFontSizes: function (settings) {

        if (settings.format.fixed) {
            return settings;
        }

        var fontConst = Ya.Const.Fonts,
            fontSize = settings.fontSize = util.checkValue(parseFloat(settings.fontSize, 10), fontConst.fontSizeMin, fontConst.fontSizeMax, fontConst.fontSizeDef),
            titleSetting = util.checkValue(parseInt(settings.titleFontSize, 10), 1, 3, fontConst.titleFontSizeSettingsDef),
            ranges = fontConst.fontSizeRanges[titleSetting],
            sizes = fontConst.titleFontSizes[titleSetting],
            i;

        for (i = 0; i < ranges.length - 1; i++) {
            if (ranges[i] < fontSize && fontSize <= ranges[i+1]) {
                settings.titleFontSizePercent = sizes[i] + '%';
                return settings;
            }
        }
    },

    _validateColors: function (settings) {
        var colorSettings = 'siteBgColor bgColor borderColor headerBgColor titleColor urlColor allColor hoverColor bgStartColor bgEndColor textColor'.split(' '),
            val,
            ln = colorSettings.length,
            i,
            colorHash;

        for (i = 0; i < ln; i++) {
            val = settings[colorSettings[i]];
            colorHash = RGB.normalizeColorHash(val);
            if (colorHash) {
                settings[colorSettings[i]] = colorHash;
            } else {
                delete settings[colorSettings[i]];
            }
        }

        // special case: settings.c11n
        colorHash = RGB.normalizeColorHash(settings.c11n.arrowTextColor);
        if (colorHash) {
            settings.c11n.arrowTextColor = colorHash;
        } else {
            delete settings.c11n.arrowTextColor;
        }

        return settings;
    }
};;

    /*
Класс компонент, от него наследуются все компоненты, планировал использовать для конструктора кода
*/
Ya.Context.Component = util.augment(Observable, {
    // строка имен классов ЦСС через пробел, которые добавятся при шаблнизации к контейнеру одного из верхних уровней
    classes: '',
    // ЦСС компонента
    css: {},
    // ХТМЛ компнента
    html: '',
    // объект для шаблона с данными
    templData: null,

    constructor: function(renderTo, blockId) {
        Ya.Context.Component.superConstructor.call(this);
        // Идентификатор блока
        this.blockId = blockId;
        // ДОМ элемента для вставки компонента
        this.renderTo = renderTo;
        // ИД основного контейнера
        // Заменяем точки на минус, иначе при добавлении этого id в css селектор, получится не то что ожидается.
        this._mainContId = 'ya_partner_' + this.blockId.replace(/[^-\w]/g, '-');
        // Указатель на ноду со стилями для этого блока.
        /// this._privateStyle = null;
    },
    // деструктор
    destructor: function () {
        this.clearEvents();
        this.clearHTML();
        // Приватные стили нужно удалять, иначе можем получить конфликт при перерисовке блока.
        if (this._privateStyle) {
            dom.remove(this._privateStyle);
            this._privateStyle = null;
        }
    },

    clearHTML: function () {
        var mainContainer = this.getMainCont()
        if (mainContainer) {
            dom.remove(mainContainer);
        }
    },
    // интерфейс отчистки событий и как следствие памяти после уничтожения компонента, должен быть доопределен в каждом компоненте
    clearEvents: function () {
        
    },
    // получает основной ДОМ контейнер из кеша или принудильно снова его ищет. Бывало что пропадал
    getMainCont: function () {
        return dom('#' + this._mainContId);
    },
    // выбирает ЦСС по прототипной цепочке класса, возвращает объект ЦСС
    _grabCss: function (cssProp) {
        cssProp = cssProp || 'css';

        var cssDefenitions = this._grabPrototypeChain(cssProp, true).reverse(),
            ieCssDefinitions,
            publicCss = {},
            i;

        for (i = 0; i < cssDefenitions.length; i++) {
            util.deepCopy(publicCss, cssDefenitions[i]);
        }

        if (browser.isIE6 || browser.isIE7 || browser.isIE8 || browser.isIEQuirks) {
            ieCssDefinitions = this._grabPrototypeChain(cssProp + 'Ie').reverse();
            for (i = 0; i < ieCssDefinitions.length; i++) {
                util.deepCopy(publicCss, ieCssDefinitions[i]);
            }
        }

        return publicCss;
    },
    // метод добавляет ко всем правилам ЦСС больше веса, если второй параметр опущен, то добавляет ID контейнера
    _specifyCssStylesSheet: function (css, rulePref) {

        rulePref = rulePref || '#' + this._mainContId + ' ';

        var newCssRule,
            cssRule,
            rulesArr = [],
            i;

        for (cssRule in css) {
            if (css.hasOwnProperty(cssRule)) {
                rulesArr.push(cssRule);
            }
        }
        // for IE, in one loop may cause infinite loop
        for (i = 0; i < rulesArr.length; i++) {
            newCssRule = rulePref + rulesArr[i];
            css[newCssRule] = css[rulesArr[i]];
            delete css[rulesArr[i]];
        }
        return css;
    },
    // метод для работы с стилевыми правилами внутри компонент. Должен быть переопределен дочерними классами.
    // используется для добавления кастомных стилей например цвет заголовка
    decorateCss: function (css) {
        return css;
    },
    //
    decorateHtml: function (data) {
        this.templData = {};
        this.decorateHtml = function (data) {
            util.extend(this.templData, data);
        };
        this.decorateHtml(data);
    },
    // получение скомпилированных ЦСС правил в виде строк.
    _getCss: function () {
        var css = this._grabCss(),
            privateCss = {};

        this.decorateCss(privateCss);
        this._specifyCssStylesSheet(privateCss);

        return {
            publicCss: this._buildCss(css, true),
            privateCss: this._buildCss(privateCss, true)
        }
    },
    // собирает свойства classes по прототипной цепочке и объединяет в одну строку
    _grabClasses: function () {
        var classes = (this._grabPrototypeChain('classes').join(' ') + ' ' + (this.classes || '')).split(' ');

        var classIndex = {};
        util.each(classes, function(className) {
            classIndex[className] = 1;
        });

        return util.keys(classIndex).reverse().join(' ');
    },

    _getHtml: function () {
        this.templData = this.templData || {};

        this.decorateHtml({
            classes: this._grabClasses(),
            mainContId: this._mainContId
        });

        this.compiledHtml = this._xTempl(this.html, this.templData);

        if (YA_DEV) {
            // Логируем получившийся html для нужд тестирования: проверка автотестами на валидность html.
            window.__YaTemplate = window.__YaTemplate || [];
            window.__YaTemplate.push(this.compiledHtml);
        }

        return this.compiledHtml;
    },
    /**
     * micro templating kit.
     * Работает через new Functino, что значит что из текст шаблона выполняется в глобальном
     * конткексте и все внутренние объекты нужно передавать явно.
     */
    _xTempl: function(str, data) {
        // Figure out if we're getting a template, or if we need to
        // load the template - and be sure to cache the result.
        var fn = new Function("data, browser",
            "var platform=[];" +

            // Introduce the data as local variables using with(){}
            "platform.push('" +

            // Convert the template into pure JavaScript
            str
                .replace(/[\r\t\n]/g, " ")
                .split("<%").join("\t")
                .replace(/\t=(.*?)%>/g, "',typeof data.$1 === 'string' || typeof data.$1 === 'number' ? data.$1 : 'data.$1','")
                .split("\t").join("');")
                .split("%>").join("platform.push('") +
            "');return platform.join('');"
        );
        return fn(data, browser);
    },

    // вставка блока ХТМЛ и ЦСС
    appendBlock: function() {
        var css = this._getCss();
        var html = this._getHtml();

        this.insertCSS(css);
        return this.insertHtml(html);
    },
    // вставка ЦСС
    insertCSS: function (css) {
        // Общие стили для всех блоков. Собираются из прототипа при первой отрисовке любого блока директа.
        // При отрисовке следующих блоков и перерисовке существующих publicCss будет приходить пустым.
        if (css.publicCss) {
            dom.appendStyle(css.publicCss);
        }
        // Приватные стили этого блока. Сохраняем указатель, чтоб при удалении блока почистить за собой.
        this._privateStyle = dom.appendStyle(css.privateCss);
    },

    // вставка ХТМЛ
    insertHtml: function (html) {
        var container = dom('#' + this.renderTo);

        if (container) {
            container.innerHTML = html;
            return true;
        }

        return false;
    },
    /**
     * Collects properties from prototype chain
     *
     * @param {String} Property name
     * @param {Boolean} [removeProps] Delete or not property after collecting.
     *
     * @return {Array} Array of properties from chain.
     */
    _grabPrototypeChain: function(prop, removeProps) {
        var result = this.constructor.prototype.hasOwnProperty(prop) ? [this.constructor.prototype[prop]] : [],
            superclass = this.constructor.superclass;

        while (superclass) {
            if (superclass.hasOwnProperty(prop)) {
                result.push(superclass[prop]);
                if (removeProps) {
                    delete superclass[prop];
                }
            }
            superclass = superclass.constructor.superclass;
        }
        if (removeProps) {
            delete this.constructor.prototype[prop];
        }
        return result;
    },

    /**
     * Inserts compiled CSS string into document
     */
    _buildCss: function(css, addImportance) {
        var compiledCss = this._compileCSSRule('', css, addImportance);
        return util.trim(compiledCss.substring(2, compiledCss.length - 2));
    },

    /**
     * Compile CSS object reference into CSS string
     *
     * @param {String} rule
     * @param {Object} properties
     *
     * @return {String}
     */
    _compileCSSRule: function(rule, properties, addImportantce) {
        var cascades = [];
        return util.format('${0} {\n${1}}\n', rule, util.map(util.keys(properties), function(property) {

            var value = properties[property],
                propertySupported,
                isValidSelector,
                propname;

            if (typeof value == 'object') {
                if (/^[?^] /.test(property)) {
                    propertySupported = typeof document.documentElement.style[dom.normalizeCSSProperty(property.substr(2), '')[0]] == 'string';
                    isValidSelector = (property.charAt(0) == '?' && propertySupported) || (property.charAt(0) == '^' && !propertySupported);

                    if (isValidSelector) {
                        cascades.push(this._compileCSSRule(rule, value, addImportantce));
                    }
                } else {
                    cascades.push(this._compileCSSRule(rule + ' ' + property, value, addImportantce));
                }
                return '';
            } else {
                if (addImportantce && !/!important$/.test(value)) {
                    value += ' !important';
                }
                propname = dom.normalizeCSSProperty(property, util.format(value, this));
                return util.format('    ${0}: ${1};\n', util.uncamelize(propname[0]), propname[1]);
            }
        }, this).join('') + cascades.join(''));
    },
    // добавляет классы в свойство объекта, который потом добавятся в основной контейнер
    addModificatorClass: function (className, isAddBefore) {
        if (className || typeof className == 'string') {
            if (isAddBefore) {
                this.classes = util.trim(className) + ' ' + this.classes;
            } else {
                this.classes += ' ' + util.trim(className);
            }
        }
    },
    //добавляет стилевые правила для переданных имен классов
    addCssStyle: function (cssClasses, css, styles) {
        if (typeof cssClasses == 'string') {
            cssClasses = cssClasses.split(',');
        }
        var className,
            classDef,
            prop,
            i;

        for (i = 0; i < cssClasses.length; i++) {
            className = util.trim(cssClasses[i]);
            if (!className) {
                continue;
            }
            classDef = css[className] || (css[className] = {});
            for (prop in styles) {
                if (styles.hasOwnProperty(prop)) {
                    classDef[prop] = styles[prop];
                }
            }
        }

        return css;
    },
    // получает стилевые правила для имен класса и свойств правил
    getCssStyle: function (name, cssProp, css) {
        if (!name) {
            return;
        }
        var prop = css[name] || (css[name] = {});
        return prop[cssProp];
    }
});
;
    /**
 * Проверяет видимость блока при загрузке, скролле и ресайзе страницы.
 *
 * jshint undef: true, browser: true
 * global util, Observable, dom, domEvent, env, browser
 */

var VisibilityChecker = util.augment(Observable, {
    _defaultOptions: {
        /**
         * Delay before confirming visibility, in milliseconds.
         * @type Number
         */
        confirmDelay: 0,

        /**
         * @type Number
         * @see {@link util.isInViewport}
         */
        visiblePortion: Number.MIN_VALUE
    },

    /**
     * @param {Object} options See {@link VisibilityChecker#_defaultOptions}.
     */
    constructor: function (options) {
        // Init Observable
        VisibilityChecker.superConstructor.call(this);

        this._options = util.extend({}, this._defaultOptions, options);

        // List of flags (for posterity)
        this._isListening = false;
        this._isConfirmed = false;

        // Special `check' function for Opera Mini
        if (browser.isOperaMini) {
            this._check = this._checkOperaMini;
        }

    },
    /**
     * Навешивает проверку видимости на блок.
     * @param {HTMLElement} element Элемент, видимость которого проверять.
     */
    listen: function (element) {
        if (!element) {
            throw new Error('VisibilityChecker#init: No element');
        }

        this._element = element;
        this._isListening = true;

        // Block is already in viewport? immediately render ad and wait
        // to report ility.
        // IE FIX -- wait for ui thread to clean up, or ie 7/8 will report
        // _anything_ as le.
        env.setProtectedTimeout(this._check, 0, this);

        // Listen window events
        this._checkLaunchers = [
            domEvent.on(window, 'scroll', this._check, this),
            domEvent.on(window, 'resize', this._check, this),
            domEvent.on(window, 'load',   this._check, this)
        ];

        // Listen scroll on all parents for cases like full-height
        // scrollable sidebars
        var parent = this._element.parentNode;
        while (parent) {
            this._checkLaunchers.push(
                domEvent.on(parent, 'scroll', this._check, this)
            );
            parent = parent.parentNode;
        }
    },

    /**
     * Убирает проверку видимости
     */
    clear: function () {
        this._clearConfirmTimer();

        if (this._isListening) {
            this._isListening = false;

            util.each(this._checkLaunchers, function (descriptor) {
                domEvent.un(descriptor);
            });

            this._checkLaunchers = null;
        }
    },

    /**
     * Проверяет видимость блока на странице в Opera Mini.
     */
    _checkOperaMini: function () {
        if (this._element.offsetWidth > 0 && this._element.offsetHeight > 0) {
            this.confirm();
        }
    },

    /**
     * Проверяет видимость блока на странице.
     * Подтверждение показа приходит только после того как блок попал в видимую область.
     * Это помогает считать CTR более точно для блоков внизу страницы
     */
    _check: function () {
        if (this._isConfirmed) {
            return;
        }

        if (dom.isInViewport(this._element, this._options.visiblePortion)) {
            this.fireEvent('visible');

            this._setConfirmTimer();
        } else {
            this._clearConfirmTimer();
        }
    },

    _setConfirmTimer: function () {
        if (!this._confirmTimer) {
            this._confirmTimer = env.setProtectedTimeout(
                this.confirm, this._options.confirmDelay || 0, this
            );
        }
    },

    _clearConfirmTimer: function () {
        if (this._confirmTimer) {
            clearTimeout(this._confirmTimer);
            this._confirmTimer = null;
        }
    },

    confirm: function () {
        if (!this._isConfirmed) {
            this._isConfirmed = true;
            this.fireEvent('confirmed');
            this.clear();
        }
    }
});
;

    /**
 * Блок директа на странцие
 * Умеет себя загружать, рисовать, перерисовывать и проверять видимость
 * @param {Number} _uid Уникальный id блока
 * @param {Number} parnterId
 * @param {String} elementId Id элемента в который надо вставлять баннеры
 */

Ya.Context.Adv = util.augment(Ya.Context.Component, {
    // дефолтовый ЦСС для всех блоков
    css: {
        'body .ya-partner .ya-partner__hidden': {
            'display': 'none !important'
        }
    },

    constructor: function(dataSource, settings, renderTo, blockId) {
        Ya.Context.Adv.superConstructor.call(this, renderTo, blockId);
        this.dataSource = dataSource;
        this.settings = settings;
        // урл на который нужно отправлять подтверждение видимости
        this._visibilityChecker = null;
        // объявления показанные в этом блоке
        this.advs = [];
    },

    destructor: function () {
        Ya.Context.Adv.superclass.destructor.call(this);

        if (this.advs.length) {
            util.each(this.advs, function (ad) {
                this.dataSource.releaseAd(ad);
            }, this);
        }
    },

    /**
     * @param {Object} options Конфигурация {@see VisibilityChecker}
     * @param {Number} [options.confirmDelay] Сколько миллисекунд должен
     * быть виден блок перед подтверждением видимости.
     * @param {Number} [options.visiblePortion] Какая часть площади блока
     * должна попадать в экран. От 0 до 1. По умолчанию – минимальная часть
     * (т.е. хотя бы 1×1 px).
     */
    createVisibilityChecker: function () {
        this._visibilityChecker = new VisibilityChecker({
            confirmDelay: Ya.Const.Limits.visibCheckDelay
        });

        this._visibilityChecker.on('confirmed', this._onConfirmVisibility, this);

        // listen
        this._visibilityChecker.listen(this.getMainCont());
    },

    // переопределяем интерфейс отчистки событий
    clearEvents: function () {
        Ya.Context.Adv.superclass.clearEvents.call(this);
        if (this._visibilityChecker) {
            this._visibilityChecker.clear();
        }
    },

    /**
     * Основные параметры рекламы для шаблона
     *
     * @param resAds - массив объявлений
     * @param linksDef - объект описывающий "головные" ссылки
     * @returns {{ads: *, yaUrl: string, yaTitle: string, settings: *, format: *}}
     */
    createTemplObj: function (resAds, linksDef) {
        var prodTitle = this.dataSource.getTitle();
        var tempObj = {
            ads: resAds,

            yaUrl: prodTitle.url,
            yaTitle: prodTitle.title,

            settings: this.settings,
            format: this.settings.format
        };

        return tempObj;
    },

    // метод расчета кол-ва объявлений в зависимости от формата
    getAdvsCount: function () {
        var settings = this.settings,
            format = settings.format,
            adsCount = Math.min(format.limit, settings.limit || 9);

        if (format.fixed) {
            return format.limit;
        }

        return adsCount;
    },

    // основной метод показа объявлений, делает всю кухню
    render: function () {
        var settings = this.settings,
            product = settings.product,
            format = settings.format;

        var ads = this.dataSource.getFreeAds();
        if (this.settings.format.skipWarnings) {
            ads = util.filter(ads, function (ad) {
                return !ad.warning;
            });
        }

        // Если у нас не осталось свободных и годных объявлений, выходим.
        if (!ads.length) {
            return;
        }

        // получаем объявления
        var adsCount = Math.min(ads.length, this.getAdvsCount());

        this.advs = ads.slice(0, adsCount);

        // создаем объект с данными для шалона
        var templObj = this.createTemplObj(this.advs);
        // генерируем ХТМЛ
        this.decorateHtml(templObj);

        // Пытаемся вставить блок в страницу и если не получилось выходим.
        if (!this.appendBlock()) {
            return;
        }

        this.fireEvent('afterInsert');

        // Сообщаем dataSource, какие объявления мы в итоге используем.
        // Важно не помечать используемыми объявления, которые не удалось показать.
        util.each(this.advs, function (ad) {
            this.dataSource.captureAd(ad);
        }, this);

        // Актуально только для фиксированных блоков
        this.setupRemoveOverflow();

        this.createVisibilityChecker();

        // стреляем событие что мы успешно отрисовались
        this.fireEvent('afterRender');
    },

    /**
     * @see src/blocks/fixedblock.js
     */
    setupRemoveOverflow: function () {
    },

    // отправка проверки видимости
    _onConfirmVisibility: function () {
        this.dataSource.onConfirmVisibility(this.advs);
        env.log(
            'confirmVisibility:',
            this.settings.format.type, this.settings.product, this.blockId
        );
    }
});
;
    (function(){
/**
 * Блок директа на странцие
 * Умеет себя загружать, рисовать, перерисовывать и проверять видимость
 * @param {Number} _uid Уникальный id блока
 * @param {Number} parnterId
 * @param {String} elementId Id элемента в который надо вставлять баннеры
 */

Ya.Context.Direct.Direct = util.augment(Ya.Context.Adv, {

    html: (function () {


        var headerHtml = '' +
            '<% if (data.yaUrl && data.yaTitle && !isRow) { %>' +
                '<yatag class="ya-partner__ads">'+
                    '<% if (data.yaUrl && data.yaTitle) { %>' +
                        '<yatag class="ya-partner__ads-l">'+
                            '<a href="<%=yaUrl%>" class="ya-partner__ads-link ya-partner__ads-link-l" target="_blank"><%=yaTitle%></a>'+
                        '</yatag>'+
                    '<% } %>'+
                    '<% if (data.format.name == Ya.Const.BlockTypes.AUTO) { %>' +
                        '<yatag class="ya-partner__close">'+
                            '<yatag class="ya-partner__close-text">\u0417\u0430\u043A\u0440\u044B\u0442\u044C</yatag><yatag class="ya-partner__close-button"> [x]</yatag>'+
                        '</yatag>'+
                    '<% } %>'+
                '</yatag>'+
            '<% } %>',

            // "дисплейсер" (чтобы age-warning, зафлоаченный вправо, не перекрывал текст или ссылки)
            ageWarnDisplacer = '<% if (ads[i].age) { %><span class="ya-partner__agewarn-displacer"><%= ads[i].age %></span><% } %>',

            picHtml = '<yatag class="ya-partner__pic-container">' +
                          '<a href="<%=ads[i].url%>" class="ya-partner__pic" target="_blank" title="<%= ads[i].site %>" style="' +

                               'width:<%= ads[i].images[pic.size][pic.axis][1] %>px !important;' +
                               'height:<%= ads[i].images[pic.size][pic.axis][2] %>px !important;' +
                               'background-image:url(\\\'<%= ads[i].images[pic.size][pic.axis][0] %>\\\') !important;' +
                          '"></a>' +
                      '</yatag>',

            picTableBegin = '<table cellpadding="0" cellspacing="0" class="ya-partner__l-table"><tr class="ya-partner__l-tr">' +
                '<td class="ya-partner__l-td ya-partner__l-pic-td">' + picHtml + '</td>' +
                '<td class="ya-partner__l-td">',
            picTableEnd = '</td></tr></table>',

            warningBlock = '<% if (ads[i].warning) { %><yatag class="ya-partner__warn"><%= ads[i].warning %></yatag><% } %>',

            resetProps = util.extend({}, Ya.Const.cssReset, {display: 'block'}),
            resetStr = util.map(util.keys(resetProps), function(prop) {
                return prop + ':' + resetProps[prop] + ' !important;';
            }).join('');

        var sitelinksBlock = [
            '<% if (ads[i].sitelinks) { %>',
                '<yatag class="ya-partner__sitelinks">',
                    '<% for (var j = 0; j < ads[i].sitelinks.length; j++) { %>',
                        '<% data.sitelink_index = j + 1; %>',
                        '<yatag class="ya-partner__sitelink ya-partner__sitelink-<%=sitelink_index%>">',
                            '<a class="ya-partner__sitelinks-text"',
                            ' target="_blank"',
                            ' href="<%=ads[i].sitelinks[j].url%>">',
                                '<%=ads[i].sitelinks[j].title%>',
                            '</a>',

                            '<% if (j < ads[i].sitelinks.length - 1) { %>',
                            '<yatag class="ya-partner__sitelinks-inline-delim">&middot;</yatag>',
                            '<% } %>',
                        '</yatag>',
                        '<wbr />', // Firefox
                    '<% } %>',
                    ageWarnDisplacer,
                '</yatag>',
            '<% } %>'
        ].join('');

        return '' +
            '<%' +
                'var pic = data.pic,' +
                'ImageLayout = Ya.Const.ImageLayout,' +
                'textClickable = data.settings.c11n.textClickable,' +
                'isRow = data.format.name == Ya.Const.BlockTypes.ROW,' +
                'isVert = data.format.type == Ya.Const.BlockTypes.VERTICAL,' +
                'isHor = data.format.type == Ya.Const.BlockTypes.HORIZONTAL,' +
                'isFixed = data.format.fixed,' +
                'is728x90 = data.format.name == "728x90" || data.format.name == "100%x90",' +
                'is728x90xIMG = (is728x90 && data.isQuasiFlat),' +
                'is1000x120 = data.format.name == "1000x120" || data.format.name == "100%x120",' +
                'is1000x120xIMG = (is1000x120 && data.isQuasiFlat),' +
                'isFlat = (data.format.type == Ya.Const.BlockTypes.FLAT) && !data.isQuasiFlat,' +
                'isBottomHeader = data.settings.headerPosition.indexOf(Ya.Const.Header.BOTTOM) != -1,' +
                'isTopHeader = data.settings.headerPosition.indexOf(Ya.Const.Header.TOP) != -1;' +
            '%>' +

            // TODO: refactor reset styles. Made for fast release and <table> with <P> problem
            '<div id="<%=mainContId%>" style="' + resetStr + '">' +
                '<% if (data.isQuasiFlat) { data.classes = "ya-partner_is-quasi-flat_yes  " + data.classes.replace(/\\bya-partner_type_flat\\b/, "ya-partner_type_horiz")} %>' +
                '<yatag class="<%= classes %>' +

                    '<% if (isFlat && !is728x90 && !is1000x120) { %>' +
                        ' ya-partner_type_flat-simple' +
                    '<% } %>' +

                    '<% if (is728x90xIMG) { %>' +
                    ' ya-partner_type_728x90xIMG' +
                    '<% } %>' +

                    '<% if (is1000x120xIMG) { %>' +
                    ' ya-partner_type_1000x120xIMG' +
                    '<% } %>' +

                    '<% if (textClickable) { %>' +
                        ' ya-partner_text_clickable' +
                    '<% } %>' +

                    '">' +
                        '<% if (!isFixed && (isHor || isVert || isFlat) && (browser.isIE)) { %>' +
                            '<yatag class="ya-partner__wrap-fit">'+
                        '<% } %>'+
                        '<% if (isTopHeader) { %>' +
                            headerHtml +
                        '<% } %>'+
                            // Лишний отступ, потому что тут было условие про media блок. Не стал убирать, чтобы
                            // не вносить лишних изменений.
                            '<% if (isHor || data.isQuasiFlat) { %>' +
                                '<table cellpadding="0" cellspacing="0" class="ya-partner__list"><tr class="ya-partner__tr">'+
                            '<% } else { %>'+
                                '<yatag class="ya-partner__list">'+
                            '<% } %>'+
                            '<% for (var i = 0, ads = data.ads, ln = ads.length; i < data.ads.length; i++) { %>' +

                                '<% if (isHor || data.isQuasiFlat) { %>' +
                                   '<td'+
                                   '<% if (is728x90xIMG) { %>' +
                                       ' style="width: 50% !important"' +
                                   '<% } %>' +
                                   '<% if (is1000x120xIMG) { %>' +
                                       ' style="width: 33% !important"' +
                                   '<% } %>' +
                                '<% } else {%>'+
                                    '<yatag'+
                                '<% } %>'+
                                ' class="ya-partner__item' +
                                '<% if (ads[i].images && pic.layout) { %>' +
                                    ' ya-partner__item_pic_yes ya-partner__item_piclayout_<%= pic.layout %>' +
                                '<% } %>' +
                                '<% if (ads[i].sitelinks) { %>' +
                                    ' ya-partner__item_sitelinks_yes' +
                                '<% } %>' +
                                '<% if (i == 0) { %>' +
                                    ' ya-partner__item_pos_first'+
                                '<% } %>'+
                                '<%  if (i == ln-1) { %>'+
                                    ' ya-partner__item_pos_last'+
                                '<% } %>'+
                                '">'+

                                '<% if (isRow) { %>' +
                                    '<yatag class="ya-partner__ads">'+
                                        '<yatag class="ya-partner__ads-l">'+
                                            '<a class="ya-partner__ads-link ya-partner__ads-link-l" href="<%=yaUrl%>" target="_blank"><%=yaTitle%></a>'+
                                        '</yatag>'+
                                    '</yatag>'+
                                '<% } %>'+

                                    '<% if ( ads[i].images ) { %>' +
                                        '<% if ( pic.layout === ImageLayout.FLOAT || pic.layout === ImageLayout.FULL ) { %>' +
                                            picHtml +
                                        '<% } %>' +

                                        '<% if ( pic.layout === ImageLayout.LEFT ) { %>' +
                                            picTableBegin +
                                        '<% } %>' +
                                    '<% } %>' +

                                        '<a href="<%=ads[i].url%>" class="ya-partner__title-link" title="<%= ads[i].site %>" target="_blank">'+
                                            '<% if (ads[i].favicon && (pic.layout === ImageLayout.NONE || !ads[i].images)) { %>' +
                                                '<img class="ya-partner__icon" src="<%=ads[i].favicon%>" alt=""/>'+
                                            '<% } %>'+
                                            '<yatag class="ya-partner__title-link-text"><%=ads[i].title%></yatag>'+
                                        '</a> '+

                                        '<yatag class="ya-partner__text">' +
                                            '<% if (textClickable) { %>' +
                                                '<a href="<%= ads[i].url %>" class="ya-partner__text-link" target="_blank">' +
                                                    '<%= ads[i].body %>' +
                                                '</a>' +
                                            '<% } else { %>' +
                                                '<%= ads[i].body %>' +
                                            '<% } %>' +

                                            // ' ' space is necessary
                                            '<% if (ads[i].age) { %>' +
                                            ' ' +
                                            '<% } %>' +

                                            ageWarnDisplacer +

                                            '<% if (ads[i].debug) { %>' +
                                                '<span><%=ads[i].debug%></span>'+
                                            '<% } %>'+
                                        '</yatag>' +

                                        sitelinksBlock +

                                        '<yatag class="ya-partner__url">'+
                                            '<% if (ads[i].vcardUrl) { %>' +
                                                '<a class="ya-partner__address" href="<%=ads[i].vcardUrl%>" target="_blank">'+
                                                    'Адрес&nbsp;и&nbsp;телефон'+
                                                '</a>'+
                                                '<% if (isFlat) { %>' +
                                                    '&nbsp;' +
                                                '<% } else {%>'+
                                                    ' ' +
                                                '<% } %>' +
                                            '<% } %>' +
                                            '<yatag class="ya-partner__domain">' +
                                                '<a class="ya-partner__domain-link" href="<%= ads[i].url %>" target="_blank">' +
                                                    '<%=ads[i].site%>' +
                                                '</a>' +
                                            '</yatag>' +
                                            '<% if (isFlat) { %>' +
                                                '&nbsp;' +
                                            '<% } else {%>'+
                                                ' ' +
                                            '<% } %>'+
                                            '<yatag class="ya-partner__region"><%=ads[i].region%></yatag>' +

                                            ageWarnDisplacer +

                                        '</yatag>' +

                                        // предупреждение о возрасте (опционально)
                                        // см. также дисплейсеры, выше
                                        '<% if (ads[i].age) { %>' +
                                            '<yatag class="ya-partner__agewarn-wrapper">' +
                                                '<yatag class="ya-partner__agewarn-cont">' +
                                                    '<yatag class="ya-partner__agewarn">' +
                                                        '<%= ads[i].age %>' +
                                                    '</yatag>' +
                                                '</yatag>' +
                                            '</yatag>' +
                                        '<% } %>' +

                                        '<% if (ads[i].images && pic.layout === ImageLayout.FLOAT) { %>' +
                                            '<yatag class="ya-partner__clearfix"></yatag>' +
                                        '<% } %>' +

                                        warningBlock +

                                    '<% if (ads[i].images && pic.layout === ImageLayout.LEFT) { %>' +
                                        picTableEnd +
                                    '<% } %>' +

                                '<% if (isHor || data.isQuasiFlat) { %>' +
                                    '</td>' +
                                    '<%  if (i != ln-1) { %>'+
                                        '<td class="ya-partner__gap">&nbsp;</td>'+
                                    '<% } %>'+
                                '<% } else {%>'+
                                    '</yatag>' +
                                '<% } %>'+
                            '<% } %>'+
                            '<% if (isHor || data.isQuasiFlat) { %>' +
                                '</tr></table>' +
                            '<% } else {%>'+
                                '</yatag>'+
                            '<% } %>'+
                        '<% if (isBottomHeader) { %>' +
                            headerHtml +
                        '<% } %>'+
                    '<% if (!isFixed && (isHor || isVert || isFlat) && (browser.isIE)) { %>' +
                        '</yatag>'+
                    '<% } %>'+
                '</yatag>'+
            '</div>';
        }()),

    classes: 'ya-partner',

    css: {
        '.ya-partner': {
            'font-size': '100%',
            position: 'relative',
            display: 'block',
            overflow: 'hidden',
            'text-align': 'left',
            'line-height': 'normal',
            'border-radius': '4px 4px 4px 4px',
            '-webkit-box-sizing': 'border-box',
            '-moz-box-sizing': 'border-box',
            'box-sizing': 'border-box',
            'white-space': 'normal'
        },
        '.ya-partner__l-table, .ya-partner__l-tr, .ya-partner__l-td': util.extend({}, Ya.Const.cssReset, {
            'vertical-align': 'middle'
        }),
        '.ya-partner__domain-link':{
            'text-decoration': 'none'
        },
        '.ya-partner__domain-link:hover':{
            'text-decoration': 'underline'
        },
        '.ya-partner, .ya-partner__ads-l, .ya-partner__ads-l em, .ya-partner__item, .ya-partner__title-link-text, .ya-partner__text, .ya-partner__domain-link, .ya-partner__region, ya-partner__pic-container, ya-partner__pic, .ya-partner__list tbody, .ya-partner__list tr, .ya-partner__list td': {
            'font-size': 'inherit',
            'font-style': 'normal',
            'text-indent': 0
        },
        '.ya-partner_text_clickable a.ya-partner__text-link': {
            'text-decoration': 'none',
            cursor: 'pointer'
        },
        '.ya-partner_text_clickable a.ya-partner__text-link:hover': {
            'text-decoration': 'underline'
        },
        '.ya-partner__pic-container': {
            display: 'block',
            margin: '3px 0'
        },

        '.ya-partner__item_piclayout_left .ya-partner__pic-container': {
            margin: '0 0.4em 0 0'
        },

        '.ya-partner__item_piclayout_float .ya-partner__pic-container' : {
            margin: '0.4em 0.4em 0 0',
            'float': 'left'
        },

        '.ya-partner__item_piclayout_float .ya-partner__address, .ya-partner__item_piclayout_float .ya-partner__domain-link, .ya-partner__item_piclayout_float .ya-partner__region' : {
            'white-space': 'nowrap'
        },

        '.ya-partner__clearfix': util.extend({}, Ya.Const.cssReset, {
            'font-size': 0,
            display: 'block',
            width: 'auto',
            height: 0,
            clear: 'both',
            'line-height': 0
        }),

        // в шаблонах для Рамблера -- может не быть ссылкой!
        '.ya-partner__pic, .ya-partner__pic:link, .ya-partner__pic:hover, .ya-partner__pic:visited': util.extend({}, Ya.Const.cssReset, {
            display: 'block',
            background: 'transparent 0 0 no-repeat scroll',
            cursor: 'pointer'
        }),

        '.ya-partner yatag': {
            'text-align': 'left',
            'font-family': 'inherit'
        },
        '.ya-partner__list': {
            display: 'block',
            'line-height': 'normal',
            'font-size': 'inherit',
            'text-indent': 0
        }, // большой ресет для ссылок, поому, что на них моно заматчиться через 'a', https://jira.yandex-team.ru/browse/YACONTEXT-9283
        '.ya-partner__title-link, .ya-partner__address, .ya-partner__ads-link': util.extend({}, Ya.Const.cssReset, {
            'font-size': 'inherit',
            'font-style': 'normal',
            display: 'inline',
            cursor: 'pointer'
        }),
        'a.ya-partner__address:hover': {
            'text-decoration': 'underline'
        },
        '.ya-partner__address': {
            'margin-right': '0.3em'
        },
        'a.ya-partner__ads-link:link, a.ya-partner__ads-link:hover, a.ya-partner__ads-link:visited': {
            'text-decoration': 'none',
            'font-weight': 'normal'
        },
        '.ya-partner__ads-link em': {
            'font-style': 'normal',
            'font-weight': 'normal',
             background: 'none repeat scroll 0 0 transparent'
        },
        '.ya-partner__item': {
            'border-radius': '4px 4px 4px 4px',
            border: 'none',
            padding: '0.2em 0.3em',
            'line-height': 'normal'
        },
        '.ya-partner_ads_inner-up .ya-partner__item_pos_first, .ya-partner_ads_inner-up-down .ya-partner__item_pos_first, .ya-partner_ads_inner-down .ya-partner__item_pos_last': {
            'border-radius': '0 4px 4px 4px'
        },
        '.ya-partner_ads_inner-down .ya-partner__item_pos_last, .ya-partner_ads_inner-up-down .ya-partner__item_pos_last': {
            'border-radius': '4px 4px 4px 0'
        },
        '.ya-partner_ads_inner-down .ya-partner__item_pos_first.ya-partner__item_pos_last': {
            'border-radius': '4px 4px 4px 0'
        },

        // sitelinks
        '.ya-partner__sitelinks': {
            display: 'block',
            padding: '0 0 0.3em',
            'margin-top': '-0.1em'
        },
        '.ya-partner_type_flat .ya-partner__sitelinks': {
            'margin-top': '0.49em'
        },
        '.ya-partner__sitelink': {
            'padding': '0.08em 0 0.08em 0',
            'vertical-align': 'middle',
            display: 'inline-block',
            'white-space': 'nowrap'
        },
        '.ya-partner__sitelinks wbr': {
            display: 'none'
        },
        '.ya-partner__sitelinks-text': {
            'white-space': 'normal',
            'text-decoration': 'underline'
        },
        '.ya-partner_text_clickable a.ya-partner__sitelinks-text': {
            'text-decoration': 'none'
        },
        '.ya-partner_text_clickable a.ya-partner__sitelinks-text:hover': {
            'text-decoration': 'underline'
        },
        '.ya-partner__sitelinks-inline-delim': {
            display: 'inline',
            padding: '0 0.8em'
        },
        // end of sitelinks

        '.ya-partner__url': {
            'font-size': '87%',
            display: 'block'
        },
        'body .ya-partner__hide-urls .ya-partner__url': {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-urls .ya-partner__url': {
            display: 'none'
        },
        '.ya-partner__warn': {
            'font-size': '70%',
            'border-radius': '2px',
            '-moz-border-radius': '2px',
            '-webkit-border-radius': '2px',
            padding: '0.25em 0.3em 0.25em',
            'line-height': '1.1em'
        },

        '.ya-partner__agewarn-displacer': {
            display : 'inline-block',
            color: 'transparent',
            font: 'normal normal 11px Tahoma, Arial, sans-serif',
            padding: '0 2px',
            visibility: 'hidden'
        },

        '.ya-partner__agewarn-wrapper' : {
            display : 'block'
        },

        '.ya-partner__agewarn-cont': {
            'float': 'right',
            'margin-top' : '-1.2em'
        },

        'yatag.ya-partner__agewarn': {
            font: 'normal normal 11px Tahoma, Arial, sans-serif',
            'border-radius': '4px',
            padding: '0 1px'
        },
        '.ya-partner__ads': {
            'white-space': 'nowrap',
            'font-size': '87%'
        },
        '.ya-partner__icon': {
            font: '0/0 a',
            'margin': '0 4px -2px 0',
            'vertical-align': 'baseline',
            'border': 0,
            'display': 'inline',
            'width': '16px',
            'height': '16px',
            'float': 'none'
        },
        '.ya-partner__ads-link': {
            'position': 'relative',
            'z-index': '10',
            'margin-left': '5px',
            'line-height': 'normal',
            'white-space': 'nowrap'
        },
        '.ya-partner__ads-l': {
            'display': 'inline-block',
            'position': 'relative',
            'background': 'none repeat scroll 0 0 transparent',
            'padding-right': '.75em'
        },
        '* html .ya-partner__ads-l': {
            display: 'inline',
            zoom: '1'
        },
        'a.ya-partner__ads-link-l,a.ya-partner__ads-link-l:link,a.ya-partner__ads-link-l:hover,a.ya-partner__ads-link-l:visited,a.ya-partner__ads-link-l:active,a.ya-partner__ads-link-l:focus': {
            'font-weight': 'normal'
        },
        'a.ya-partner__title-link,a.ya-partner__title-link:link,a.ya-partner__title-link:hover,a.ya-partner__title-link:visited,a.ya-partner__title-link:active,a.ya-partner__title-link:focus': {
            'font-weight': 'normal',
            'line-height': 'normal',
            'text-decoration': 'none'
        },
        'a.ya-partner__title-link .ya-partner__title-link-text,a.ya-partner__title-link .ya-partner__title-link-text:link,a.ya-partner__title-link .ya-partner__title-link-text:hover,a.ya-partner__title-link .ya-partner__title-link-text:visited,a.ya-partner__title-link .ya-partner__title-link-text:active,a.ya-partner__title-link .ya-partner__title-link-text:focus': {
            display: 'inline',
            'text-decoration': 'underline'
        },
        '.ya-partner_text_clickable a.ya-partner__title-link .ya-partner__title-link-text': {
            'text-decoration': 'none'
        },
        '.ya-partner_text_clickable a.ya-partner__title-link:hover .ya-partner__title-link-text': {
            'text-decoration': 'underline'
        },
        '.ya-partner_ads-up .ya-partner__ads': {
            // por необходим, когда плашка содержит крестик
            position: 'relative',
            display: 'block'
        },
        '.ya-partner_ads-up .ya-partner__ads-l': {
            'padding-bottom': '1px',
            'vertical-align': 'top',
            'border-radius': '4px 0 0 0',
            '-moz-border-radius': '4px 0 0 0',
            '-webkit-border-radius': '4px 0 0 0'
        },
        // Пока так, для всех блоков с плашкой внизу, плашка poa
        '.ya-partner_ads-down .ya-partner__ads': {
            position: 'absolute',
            bottom: 0
        },
        '.ya-partner_ads-down .ya-partner__list': {
            /*'margin-bottom': '1em'*/
            'padding-bottom': '1em'
        },
        '.ya-partner_ads-down .ya-partner__ads-l': {
            'border-radius': '0 0 0 3px',
            '-moz-border-radius': '0 0 0 3px',
            '-webkit-border-radius': '0 0 0 3px'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__list': {
            //margin: '1em 0'
            margin: '0 0 1em'
        },
        '.ya-partner_ads-up-down .ya-partner__list': {
            margin: '1em 0'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__ads-l, .ya-partner_ads-up-down .ya-partner__ads-l': {
            //position: 'absolute',
            //top: 0,
            'border-radius': '3px 0 0 0',
            '-moz-border-radius': '3px 0 0 0',
            '-webkit-border-radius': '3px 0 0 0'
        },
        '.ya-partner_ads-up-down .ya-partner__ads-l': {
            position: 'absolute',
            top: 0
        },
        '.ya-partner_ads-up-down .ya-partner__ads-link': {
            display: 'inline-block',
            'padding-bottom': '2px'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__ads-link, .ya-partner_ads-up-down .ya-partner__ads-link': {
            'margin-left': '5px'
        },
        '.ya-partner_ads_inner-up .ya-partner__ads': {
            display: 'block'
        },
        '.ya-partner_ads_inner-up .ya-partner__ads-l': {
            'vertical-align': 'top',
            'border-radius': '4px 0 0 0',
            '-moz-border-radius': '4px 0 0 0',
            '-webkit-border-radius': '4px 0 0 0'
        },
        '.ya-partner_ads_inner-down .ya-partner__ads': {
            display: 'block'
        },
        '.ya-partner_ads_inner-down .ya-partner__ads-l': {
            'border-radius': '0 0 0 4px',
            '-moz-border-radius': '0 0 0 4px',
            '-webkit-border-radius': '0 0 0 4px'
        },
        '.ya-partner_ads_inner-down .ya-partner__ads-link, .ya-partner_ads-down .ya-partner__ads-link': {
            display: 'inline-block',
            'padding-bottom': '1px'
        },
        '.ya-partner_ads_only-arrow .ya-partner__ads': {
            'margin-right': '0.5em'
        },
        '.ya-partner_margin_yes .ya-partner__icon': {
            'margin-left': '-20px'
        },
        '.ya-partner_margin_yes .ya-partner__item': {
            'padding-left': '20px'
        },

        '.ya-partner__wrap-fit': {
            display: 'block',
            zoom: '1',
            position: 'relative',
            'padding-bottom': '1px',
            'font-size': 'inherit',
            'border-radius': '4px 4px 4px 4px'
        }
    },

    // *porperty - IE7  и ниже, не понимает ie7 в режиме совместимости
    // _porperty - IE6  и ниже
    cssIe: {
        '.ya-partner': {
            'font-size': '100%',
            zoom: '1'
            //,width: '100%'
        },
        '.ya-partner_type_horiz, .ya-partner_type_vert, .ya-partner_type_flat': {
            display: 'table',
            width: '100%',
            'border-spacing': 0
        },
        '.ya-partner__ads': {
            left: 0,
            'white-space': 'nowrap'
        },
        '.ya-partner_ads-up .ya-partner__ads,.ya-partner_ads-down .ya-partner__ads': {
            overflow: 'hidden'
        },
        '.ya-partner__item': {
            'padding-bottom' : '0.3em'
        },
        '.ya-partner__agewarn': {
            position: 'relative'
        },
        '* html .ya-partner__ads-l, * html .ya-partner__ads-r': {
            display: 'inline',
            zoom: '1'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__list, .ya-partner_ads-up-down .ya-partner__list': {
            margin: '1em 0'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__ads-l, .ya-partner_ads-up-down .ya-partner__ads-l': {
            position: 'absolute',
            top: 0
        },
        '.ya-partner_ads-up-down .ya-partner__ads-link': {
            'padding-bottom': '1px',
            '*padding-bottom': '2px',
            '_padding-bottom': '2px'
        },
        '.ya-partner_ads-up-down .ya-partner__ads-l': {
            'line-height': '130%'
        },
        '.ya-partner__ads-link': {
            position: 'static',
            'line-height': 'normal'
        },
        '.ya-partner_ads_only-arrow .ya-partner__list':{
            /*только для IE6 */
            '-zoom': '1'
        },
        '.ya-partner_ads_inner-down .ya-partner__ads': {
            overflow: 'hidden'
        },
        '.ya-partner_ads_only-arrow .ya-partner__icon': {
            'margin-top': '2px'
        },

        '.ya-partner_ads_inner-up .ya-partner__item_pos_first': {
            position: 'relative',
            'z-index': '10',
            zoom: '1'
        },

        '.ya-partner_ads_inner-up .ya-partner__ads-link': {
            'line-height': 'normal'
        },
        '* html .ya-partner_ads_inner-down .ya-partner__list': {
            zoom: '1'
        },
        '.ya-partner_border.ya-partner_ads-down .ya-partner__wrap-fit .ya-partner__ads': {
            margin: 0
        },
        '.ya-partner_ads_inner-up-down, .ya-partner_ads-up-down': {
            'padding-top': 0
        },
        '* html .ya-partner__item, * html .ya-partner__text': {
            '_zoom' : '1',
            '*zoom' : 'auto'
        },
        '* html .ya-partner__text': {
            'margin-top' : '-0.1em'
        },
        '* html .ya-partner_ads_inner-up-down .ya-partner__ads-link-l': {
            zoom: '1'
        },
        '.ya-partner_ads_inner-up-down .ya-partner__ads': {
            'font-size': '82%'
        }
    },

    constructor: function () {
        Ya.Context.Direct.Direct.superConstructor.apply(this, arguments);
        this.on('afterInsert', this._removeBrokenFavicons, this);
    },

    _removeBrokenFavicons: function () {
        util.each(
            dom('.ya-partner__icon', this.getMainCont()),
            this._removeBrokenFavicon
        );
    },

    _removeBrokenFavicon: function (origFav) {
        var img = new Image;
        domEvent.on(img, 'error', function () {
            dom.remove(origFav);
        });
        domEvent.on(img, 'load', function(){
            if(img.width != 16) {
                dom.remove(origFav);
            }
        });
        img.src = origFav.src;
    },
    /**
     * Добавляет к основным параметрам параметры картинок, типографию, фавиконки
     *
     * @extends Ya.Context.Adv.createTemplObj
     */
    createTemplObj: function (ads) {
        var res = Ya.Context.Direct.Direct.superclass.createTemplObj.call(this, ads);
        res.pic = this.getPicParams(ads);

        switch (this.settings.format.name.toLowerCase()) {
            case "728x90":
            case "100%x90":
                this.prepareFor728x90(res);
                break;
            case "1000x120":
            case "100%x120":
                this.prepareFor1000x120(res);
                break;
        }

        return res;
    },

    prepareFor728x90: function (res) {
        res.pic.layout = Ya.Const.ImageLayout.LEFT;
        res.pic.axis = Ya.Const.ImageAxis.Y;
        var imgCount = res.pic.imgCount;

        // если в первых двух объявлениях нет картинок, выводим обычный блок
        if (imgCount.rollingTo[1] == 0) {
            return res;
        }

        var ads = res.ads;
        if (ads[0].images && ads[0].warning || ads[1] && ads[1].images && ads[1].warning) {
            // одно из первых двух объявлений в выдаче "высокое" т.е. с картинкой и ворнингом
            // -- делаем квазиплоский блок 728*90 и выводим только _первое_ объявление
            // вне зависимости от того, есть ли в нем картинка
            ads.length = 1;
            res.isQuasiFlat = true;
        } else if (ads[0].images || ads[1] && ads[1].images) {
            // оба первых с картинкой, но без ворнинга (средняя высота),
            // либо "безопасная" по высоте пара -- можно рисовать две плашки рядом
            ads.length = 2;
            res.isQuasiFlat = true;
        }
    },

    prepareFor1000x120: function (res) {
        res.pic.axis = Ya.Const.ImageAxis.Y;
        var imgCount = res.pic.imgCount;

        var ads = res.ads;
        if (ads[3] && ads[3].images && imgCount.rollingTo[3] == 1) {
        // Если 3 первых - текстовые, а 4-е - с картинкой, отбрасываем 4-е
            ads.length = 3;
        } else if (imgCount.rollingTo[2] > 0) {
        // если в первых трех объявлениях есть картинка, рисуем блок в несколько колонок
            ads.length = 3;
            res.isQuasiFlat = true;
        }
    },

    /**
     * Возвращает параметры размещения картинок в блоке
     *
     * @see https://jira.yandex-team.ru/browse/YACONTEXT-10829
     * @param resAds
     * @returns {imgCount: object, layout: string, size: string, axis: string}
     */
    getPicParams: function (resAds) {
        var format = this.settings.format,
            formatName = format.name,
            formatType = format.type,
            imgCount = getImgCount(resAds);

        var layout = Ya.Const.ImageLayout.NONE;
        // Большинство фиксированных блоков -- вертикально ориентированы и есть место
        // для текста правее картинки, по-этому для них лейаут float
        var isFloatLayout = formatName == Ya.Const.BlockTypes.AUTO
            || formatType == Ya.Const.BlockTypes.VERTICAL
            || formatType == Ya.Const.BlockTypes.HORIZONTAL
            || formatName == '240x400'
            || formatName == '200x300'
            || formatName == '300x300'
            || formatName == '300x250'
            || formatName == '250x250'
            ;
        if (isFloatLayout) {
            layout = Ya.Const.ImageLayout.FLOAT;
        }
        // В этих форматах высоты подразумевается немного,
        // если 1-2 строки влезут под картинку -- некрасиво
        if (formatType == Ya.Const.BlockTypes.FLAT) {
            layout = Ya.Const.ImageLayout.LEFT;
        }

        // PCODE-205 -- В этом блоке текст должен быть строго под картинкой
        if (formatName == '160x600') {
            layout = Ya.Const.ImageLayout.FULL;
        }

        // /!\ 1000x120 не трогаем, там предупреждения и домены должны заезжать под картинку
        if (formatName == '1000x120') {
            layout = Ya.Const.ImageLayout.FLOAT;
        }

        var size = Ya.Const.ImageSize.M;
        // Некоторые блоки позволяют вместить в себя большую картинку, она кликабельнее
        var isLargePic = (formatName == '240x400' && imgCount.total == 1)
            || formatName == '160x600'
            || formatName == '300x300'
            || formatName == '300x250'
            || formatName == Ya.Const.BlockTypes.VERTICAL
            || formatName == Ya.Const.BlockTypes.HORIZONTAL
            || formatName == Ya.Const.BlockTypes.AUTO
            ;
        if ( isLargePic ) {
            size = Ya.Const.ImageSize.L;
        }

        var sizeAxis = Ya.Const.ImageAxis.X;
        // у горизонтально ориентированныых блоков меряем высоту, а не ширину картинки
        // чтобы текст выравнивался по вертикали у разных объявлений
        var isYAxis = formatType == Ya.Const.BlockTypes.HORIZONTAL
            || formatName == Ya.Const.BlockTypes.AUTO
            ;
        if (isYAxis) {
            sizeAxis = Ya.Const.ImageAxis.Y;
        }

        return {
            imgCount: imgCount,
            layout: layout,
            size: size,
            axis: sizeAxis
        };

        function getImgCount(resAds) {

            var total = 0,
                rolling = [];

            for (var i = 0, l = resAds.length; i < l; i++) {
                if (resAds[i].images) {
                    total++;
                }
                rolling[i] = total;
            }

            return {
                total: total,
                rollingTo: rolling
            }
        }
    },

    // добавление стилей для предупреждений. Вычисляется контрастный фон и рамка для предупреждения
    addWarningCss: function (css) {

        var settings = this.settings,
            bgColor = settings.bgColor || settings.bgStartColor || settings.siteBgColor || '#FFFFFF';

        this.addCssStyle('.ya-partner__warn, .ya-partner__agewarn', css, {
            border: '1px solid ' + Ya.Context.Warning.getBorderColor(bgColor, settings.textColor),
            'background-color': Ya.Context.Warning.getBgColor(bgColor)
        });
    },

    // берутся стили из настроек пользователя для рамки и положения плашки
    addHeaderBorderCss: function (css) {
        var settings = this.settings,
            className = 'ya-partner_ads',
            borderTypeModificator = 'ya-partner_theme_' + settings.format.type,
            bgBorderRule = '';

        if (settings.borderType == Ya.Const.BorderTypes.AD) {
            className += '_inner';
            borderTypeModificator += '_inner';
            bgBorderRule = '.ya-partner__item';
        } else if (settings.borderType == Ya.Const.BorderTypes.BLOCK) {
            this.addModificatorClass('ya-partner_border');
            bgBorderRule = '.ya-partner_border';
        }

        if (settings.headerPosition.indexOf(Ya.Const.Header.TOP) != -1) {
            className += '-up';
        }

        if (settings.headerPosition.indexOf(Ya.Const.Header.BOTTOM) != -1) {
            className += '-down';
        }

        this.addModificatorClass(borderTypeModificator);
        this.addModificatorClass(className);

        // Border and inner background for adv
        this.addCssStyle(bgBorderRule || '.ya-partner', css, {background: settings.bgColor});

        if (!settings.format.fixed
                && (settings.format.type == Ya.Const.BlockTypes.HORIZONTAL
                        || settings.format.type == Ya.Const.BlockTypes.FLAT
                        || settings.format.type == Ya.Const.BlockTypes.VERTICAL)
                && settings.borderType == Ya.Const.BorderTypes.BLOCK && (browser.isIE)) {
            bgBorderRule = '.ya-partner__wrap-fit';
        }

        this.addCssStyle(bgBorderRule, css, {border: '1px solid ' + settings.borderColor || 'transparent'});

        if (!settings.borderRadius) {
            if (settings.borderType == Ya.Const.BorderTypes.BLOCK
                    || settings.borderType == Ya.Const.BorderTypes.NONE) {
                this.addCssStyle(['.ya-partner_ads-down .ya-partner__ads-l', '.ya-partner_ads-up .ya-partner__ads-l'], css, {
                    'border-radius': 0,
                    '-moz-border-radius': 0,
                    '-webkit-border-radius': 0
                });
            }
            this.addCssStyle('.ya-partner, .ya-partner__wrap-fit, .ya-partner__item', css, {'border-radius': 0});
        }
    },

    // если задан ставится градиентный фон, почти не используется, в открытом доступе нет такой настройки
    addGradientBg: function (css) {
        var settings = this.settings,
            styles = {},
            gradient,
            pref = '';

        if ((settings.format.name == Ya.Const.BlockTypes.AUTO
            || settings.format.fixed) && (settings.bgStartColor && settings.bgEndColor)) {

            gradient = 'linear-gradient(bottom, ' + settings.bgStartColor + ' 49%, ' + settings.bgEndColor + ' 100%)';

            if (browser.isOpera) {
                pref = '-o-';
            } else if (browser.isGecko) {
                pref = '-moz-';
            } else if (browser.isIE) {
                pref = '-ms-';
                styles.zoom = 1;
                styles.filter = 'progid:DXImageTransform.Microsoft.Gradient(Enabled=true, GradientType=0, StartColorStr=' + settings.bgStartColor + ', EndColorStr=' + settings.bgEndColor + ')';
            } else if (browser.isSafari || browser.isChrome) {
                pref = '-webkit-';
            }

            styles['background-image'] = pref + gradient;
            this.addCssStyle('.ya-partner', css, styles);
        }
    },

    // ставятся размеры шрифтов
    setFontSize: function (css) {
        var settings = this.settings;

        if (settings.format.fixed) {
            return false;
        }

        if (settings.format.name == Ya.Const.BlockTypes.ROW) {
            if (settings.titleFontSize == 3) {
                this.addCssStyle('.ya-partner__title-link-text', css, {'font-weight': 'bold'});
            }
        } else {
            this.addCssStyle('.ya-partner__title-link-text', css, {'font-size': settings.titleFontSizePercent});
            if (!settings.format.fixed && settings.titleFontSizePercent == '107%') {
                this.addCssStyle('.ya-partner__title-link-text', css, {'font-weight': 'bold'});
            }
        }

        this.addCssStyle('.ya-partner', css, {'font-size': settings.fontSize + 'em'});
    },

    // цвета ссылок, заголовков и т.д.
    setFontColors: function (css) {

        var settings = this.settings,
            styleClasses = [
                '.ya-partner__title-link-text:visited',
                '.ya-partner__title-link-text:link',
                '.ya-partner__title-link-text:hover',
                '.ya-partner__sitelinks-text:visited',
                '.ya-partner__sitelinks-text:link',
                '.ya-partner__sitelinks-text:hover',
                '.ya-partner__title-link-text'
            ],
            hoverClasses = [
                '.ya-partner__title-link-text:hover',
                '.ya-partner__sitelinks-text:hover'
            ];

        if (browser.isIE) {
            styleClasses = [
                '.ya-partner__title-link:visited',
                '.ya-partner__title-link:link',
                '.ya-partner__title-link:hover',
                '.ya-partner__sitelinks-text:visited',
                '.ya-partner__sitelinks-text:link',
                '.ya-partner__sitelinks-text:hover',
                '.ya-partner__title-link'
            ];
            hoverClasses = [
                '.ya-partner__title-link:hover',
                '.ya-partner__sitelinks-text:hover'
            ];
        }

        this.addCssStyle(styleClasses, css, {
            color: settings.titleColor
        });

        this.addCssStyle(hoverClasses, css, {
            color: settings.hoverColor
        });

        var urlsSelector = [
            '.ya-partner__region',
            '.ya-partner__domain-link',
            '.ya-partner__address'
        ];
        this.addCssStyle(urlsSelector, css, {
            color: settings.urlColor
        });

        this.addCssStyle('.ya-partner, .ya-partner__text, .ya-partner__text-link', css, {
            'font-family': settings.fontFamily,
            color: settings.textColor
        });

        // disc color
        this.addCssStyle('.ya-partner__sitelinks', css, {
            color: settings.textColor
        });
    },

    /**
     * Возвращает цвет фона блока
     * для определения контрастного цвета шрифта
     * для текстов без подложки вне объявлений
     *
     * @returns {RGB}
     */
    getBlockBgColor: function () {
        var bgColor = this.settings.siteBgColor || '#ffffff';
        if (this.settings.bgColor && this.settings.borderType == Ya.Const.BorderTypes.AD) {
            bgColor = this.settings.bgColor;
        }
        return new RGB(bgColor);
    },


    // разукрашивается стрелочка и если не задан, то ставится автоматический цвет
    setArrowColors: function (css) {
        var settings = this.settings,
            headerBgColor = settings.headerBgColor,
            arrowColor = headerBgColor || 'transparent',
            siteBgColor = settings.siteBgColor || '#FFFFFF',
            bgColor = settings.bgColor,
            fontColor = settings.c11n.arrowTextColor,
            yaLinkDecor = '',
            isWhite,
            arrowGIF1 = "url(\"data:image/gif,GIF89a%C8%00)%00%80%01%00%",
            arrowGIF2 = "%FF%FF%FF!%F9%04%01%00%00%01%00%2C%00%00%00%00%C8%00)%00%00%02%AB%84%8F%A9%CB%ED%0F%A3%9C%B4%DA%1B%B2%DE%B7%FB%0F%86%E2%E8lf%40%A6%EA%CA%B6%D2%A9%B9%F2L%D7%14%9C%D9%FA%CE%CBx%0F%0C%0A-%BF%A1%F1%884%C0%92%CC%E6n%E9%8CJY%A7%A9%F5%0A%AAb%B7%DC%17%A7%0B%0E'L%E2%B2%F8kNc%D1%EA%B64%E6%8E%3B%E1%F2%3A2g%CF%0F%F1%FA~%0F%E5%17%A8%03(XhxhF%88%B8(%A2%C8%F8%88%E1%089%E9Ei%E9%25y%A9%89%40%B7%E9%A9%D4%F9%B9%C9%26zIV%3AJ%8A%0A%A9%B5J%D9%EA%FA%08%15%2B%0BK%7BXt%8B%98%AB%5B%88%93%D9%AB%F7%1B%EC%3BL%1C%F8%1BP%00%00%3B\")";

        if (browser.isIE6 || browser.isIE7 || browser.isIEQuirks) {
            this.addCssStyle('.ya-partner__ads-l,.ya-partner__ads-link-l em', css, {'background': 'none repeat scroll 0 0 ' + arrowColor});
            this.addCssStyle('.ya-partner__ads-l', css, {'padding-right': '5px'});
        } else {
            if (/^#?([A-F\d]{2})([A-F\d]{2})([A-F\d]{2})$/i.test(headerBgColor)) {
                this.addCssStyle('.ya-partner__ads-l', css, {
                    background: arrowGIF1 +
                        [RegExp.$1, RegExp.$2, RegExp.$3].join('%') +
                        arrowGIF2 + ' 100% 50% no-repeat scroll transparent'
                });
            }
        }

        if (browser.isIE6 && arrowColor === 'transparent') {
            this.addCssStyle('.ya-partner__ads-arrow-i', css, {border: 'none'});
        }

        if ( !headerBgColor ||
            (headerBgColor == bgColor && settings.borderType !== Ya.Const.BorderTypes.AD) ||
            ((!bgColor || settings.borderType == Ya.Const.BorderTypes.AD) && headerBgColor == siteBgColor)) {
            yaLinkDecor = 'underline';
        }

        if (settings.borderType == Ya.Const.BorderTypes.AD && settings.headerPosition.indexOf(Ya.Const.Header.TOP) != -1 || settings.borderType == Ya.Const.BorderTypes.BLOCK && settings.headerPosition == Ya.Const.Header.BOTTOM) {
            yaLinkDecor = '';
        }

        // direct link bgColor
        isWhite = (new RGB(
            headerBgColor ||
            (settings.borderType == Ya.Const.BorderTypes.AD ? siteBgColor : (bgColor || siteBgColor))
        )).isLight();
        
        if (fontColor === undefined) {
            fontColor = isWhite? '#000' : '#fff';
        }
        this.addCssStyle('a.ya-partner__ads-link-l:link,a.ya-partner__ads-link-l:hover,a.ya-partner__ads-link-l:visited', css, {
            'text-decoration': yaLinkDecor,
            color: fontColor
        });
    },

    // основной метод добавления кастомного ЦСС. В него передается объект собранных дефолтных стилей для блока и
    // вызываемые методы добавляют необходимые правила
    decorateCss: function (css) {
        this.setFontColors(css);
        this.setFontSize(css);
        this.addHeaderBorderCss(css);

        this.addWarningCss(css);

        this.setArrowColors(css);
        this.addGradientBg(css);
        return css;
    }
});
})();
;
    // абстрактный класс мобильных блоков
Ya.Context.Direct.Mobile = util.augment(Ya.Context.Direct.Direct, {
    html: ''+
        '<div id="<%=mainContId%>">'+
        '<div class="ya-partner-mob">'+
            '<% for (var i=0, ads = data.ads, ln = ads.length; i < data.ads.length; i++) { %>' +
                '<div class="ya-partner-mob__title"><a href="<%=ads[i].url%>" class="ya-partner-mob__title-link" target="_blank"><%=ads[i].title%></a></div>'+
                '<div class="ya-partner-mob__txt"><%=ads[i].body%>' + 
                    '<% if (ads[i].age) { %> <yatag class="ya-partner-mob__agewarn"><%= ads[i].age %></yatag><% } %>' +
                '</div>'+
                '<% if (ads[i].debug) { %>' +
                    '<div class="ya-partner-mob__txt"><%=ads[i].debug%></div>'+
                '<% } %>'+
                '<% if (ads[i].warning) { %>' +
                  '<div class="ya-partner-mob__alert"><%=ads[i].warning%></div>'+
                '<% } %>'+
                '<div class="ya-partner-mob__info">'+
                    '<% if (ads[i].callUrl && ads[i].telNum && browser.isOperaMini) { %>' +
                        '<a class="ya-partner-mob__info-link" href="<%=ads[i].callUrl%>" target="_blank">\u041F\u043E\u0437\u0432\u043E\u043D\u0438\u0442\u044C</a>'+
                    '<% } else if (ads[i].callUrl && ads[i].telNum) {%>'+
                        '<a class="ya-partner-mob__phone ya-partner-mob__phone__unpressed" href="<%=ads[i].callUrl%>" target="_blank"><span class="ya-partner-mob__phone-inner"><%=ads[i].telNum%></span></a>'+
                    '<% } %>'+
                    '<% if (ads[i].vcardUrl) { %>' +
                       '<a class="ya-partner-mob__info-link" href="<%=ads[i].vcardUrl%>" target="_blank">\u041F\u043E\u043A\u0430\u0437\u0430\u0442\u044C \u043D\u0430 \u043A\u0430\u0440\u0442\u0435</a>'+
                    '<% } %>'+
                    '<div class="ya-partner-mob__info-link"><%=ads[i].domain%></div>'+
                '</div>'+
                '<% if (data.yaTitle) { %>' +
                    '<div class="ya-partner-mob__ya"><span class="ya-partner-mob__ya-link"><%=yaTitle%></span></div>'+
                '<% } %>'+
            '<% } %>'+
        '</div>'+
        '</div>',

    css: {
        '.ya-partner-mob': {
            'font-family': 'Arial, sans-serif',
            'padding': '3px 0 0',
            '-webkit-text-size-adjust': 'none'
        },
        '.ya-partner-mob__title': {
            'font-size': '120%'
        },
        '.ya-partner-mob__title-link': {
            'text-decoration': 'none'
        },
        '.ya-partner-mob__txt': {

        },
        '.ya-partner-mob__agewarn': {
            display: 'inline-block',
            font: 'normal normal 85% Tahoma, Arial, sans-serif',
            'border-radius': '5px',
            padding: '0 1px',
            'vertical-align': 'baseline'
        },
        '.ya-partner-mob__ya-link': {
            'font-size': '70%',
            'color': '#FFFFFF',
            'float': 'left',
            'position': 'relative',
            'padding-right': '5px',
            'text-decoration': 'none',
            'background': 'none repeat scroll 0 0 #EEEEEE'
        },
        '.ya-partner-mob__ya': {
            'clear': 'both',
            'overflow': 'hidden'
        },
        '.ya-partner-mob__alert': {
            'font-size': '70%',
            'padding': '0 2px'
        },
        '.ya-partner-mob__info-link': {
            'display': 'inline-block',
            'padding-right': '8px',
            'white-space': 'nowrap'
        },
        '.ya-partner-mob__ya-link em': {
            'font-style': 'normal',
            'line-height': '100%'
        },
        '.ya-partner-mob__phone,.ya-partner-mob__phone-inner, .ya-partner-mob__title-link,.ya-partner-mob__txt,.ya-partner-mob,.ya-partner-mob__title,.ya-partner-mob__ya-link,.ya-partner-mob__alert,.ya-partner-mob__info-link,.ya-partner-mob__ya, .ya-partner-mob__info': {
            'line-height': '100%'
        },
        '.ya-partner-mob__phone': {
            'padding-right': '8px'
        }

    },

    // все методы ниже дополняются стилями для мобильного блока, потому что у него своя верстка и свои имена классов
    // ===================================================
    setFontSize: function (css) {
        var settings = this.settings;

        this.addCssStyle('.ya-partner-mob', css, {
            'font-size': (settings.fontSize*100) + '%',
            'font-family': settings.fontFamily
        });
    },

    setFontColors: function (css) {

        var settings = this.settings;

        this.addCssStyle('.ya-partner-mob__title-link', css, {color: settings.titleColor});
        this.addCssStyle('.ya-partner-mob__info-link', css, {color: settings.urlColor});
        this.addCssStyle('.ya-partner-mob__txt', css , {color: settings.textColor});
    },

    setArrowColors: function (css) {

        var settings = this.settings,
            headerBgColor = settings.headerBgColor,
            siteBgColor = settings.siteBgColor || '#FFFFFF',
            borderColor = settings.borderColor,
            isWhite,
            fontColor;

        // direct link bgColor
        isWhite = (new RGB(headerBgColor || borderColor || siteBgColor)).isLight();
        if (isWhite) {
            fontColor = '#000';
        }

        this.addCssStyle('.ya-partner-mob__ya-link', css, {background: headerBgColor || borderColor || 'transparent', color: fontColor});
    },

    addWarningCss: function (css) {

        var settings = this.settings,
            bgColor = settings.bgColor || settings.bgStartColor || settings.siteBgColor || '#FFFFFF';

        this.addCssStyle('.ya-partner-mob__alert,.ya-partner-mob__agewarn', css, {border: '1px solid ' + Ya.Context.Warning.getBorderColor(bgColor, settings.textColor)});
        this.addCssStyle('.ya-partner-mob__alert,.ya-partner-mob__agewarn', css, {'background-color': Ya.Context.Warning.getBgColor(bgColor)});
    },

    addHeaderBorderCss: function (css) {
        var settings = this.settings;

        // Border and inner background for adv
        this.addCssStyle('.ya-partner-mob', css, {background: settings.bgColor});
        this.addCssStyle('.ya-partner-mob', css, {border: '1px solid ' + settings.borderColor || 'transparent'});
    }
});
;
    // вертикальный блок, тут только CSS
Ya.Context.Direct.Vertical = util.augment(Ya.Context.Direct.Direct, {
    classes: 'ya-partner_type_vert',

    css: {
        '.ya-partner_type_vert ': {
            'min-width': '50px',
            'clear': 'both'
        },
        ':root .ya-partner_type_vert': { // IE9=10 fix
            'display': 'table\\0/IE9',
            'width': '100%\\0/IE9'
        },
        ':root .ya-partner_type_vert.ya-partner_border.ya-partner_ads-down .ya-partner__ads': { // IE9=10 fix  из-за таблицы
            'bottom': '1px\\0/IE9'
        },
        '.ya-partner_type_vert .ya-partner__item,.ya-partner_type_vert .ya-partner__warn,.ya-partner_type_vert .ya-partner__text,.ya-partner_type_vert .ya-partner__url': {
            'display': 'block'
        },
        '.ya-partner_type_vert .ya-partner__item': {
            'margin': '0 0 0.5em 0',
            'padding': '0.5em'
        },

        '.ya-partner_theme_vertical_inner .ya-partner__url': {
            'padding-bottom': '1px'
        },

        '.ya-partner_theme_vertical_inner .ya-partner__item_piclayout_float .ya-partner__pic-container': {
            'margin-bottom': '1px'
        },

        '.ya-partner_type_vert .ya-partner__text,.ya-partner_type_vert .ya-partner__warn': {
            'margin': '0.4em 0'
        },
        '.ya-partner_type_vert .ya-partner__item_pic_yes': {
            'padding': '3px .5em'
        },
        '.ya-partner_type_vert .ya-partner__item_pos_last': {
            'margin': 0
        }
    },
    cssIe: {
        '.ya-partner_type_vert .ya-partner__list': {
            'zoom': '1'
        },
        'html* .ya-partner_ads-down .ya-partner__ads': {
         //   '_bottom': '-1px'
        },
        '.ya-partner_type_vert.ya-partner_ads_inner-up-down .ya-partner__wrap-fit': {
            'padding-top': '1px'
        }
    }
});;
    // класс резинового горизонтального блока, от него наследуются все фиксированные
Ya.Context.Direct.Horizontal = util.augment(Ya.Context.Direct.Direct, {

    classes: 'ya-partner_type_horiz',



    css: {
        '.ya-partner_type_horiz': {
            'display': 'inline-block',
            'width': '100%',
            '-moz-box-sizing': 'border-box',
            '-webkit-box-sizing': 'border-box',
            'box-sizing': 'border-box'
        },
        ':root .ya-partner_type_horiz': { // IE9=10 fix
            'display': 'table\\0/IE9',
            'width': '100%\\0/IE9'
        },
        ':root .ya-partner_type_horiz.ya-partner_border.ya-partner_ads-down .ya-partner__ads': { // IE9=10 fix  из-за таблицы
            'bottom': '1px\\0/IE9'
        },
        '.ya-partner_type_horiz:before,.ya-partner_type_horiz:after': { // clearfix вокруг блока, чтобы не проваливался под другие
            'content': '""',
            'display': 'table',
            'border-spacing': '0',
            'border': '0'
        },
        '.ya-partner_type_horiz .ya-partner__list': {
            'display': 'table',
            'width': '100%',
            'margin': '0',
            'padding': '0',
            'border': 'none',
            'border-spacing': '0',
            'font-size': 'inherit'
        },
        '.ya-partner_ads-down table.ya-partner__list': {
            'margin-bottom': '1em' // перетерлось ресетом таблицы
        },
        'body .ya-partner_type_horiz .ya-partner__item': {
            'position': 'static'
        },
        '.ya-partner_type_horiz .ya-partner__tr': {
            'font-size': 'inherit'
        },
        '.ya-partner_type_horiz .ya-partner__item': {
            'padding': '0.5em',
            'vertical-align': 'top',
            'border-spacing': '0',
            'font-size': 'inherit',
            'border-collapse': 'separate'
        },
        '.ya-partner_type_horiz .ya-partner__gap': {
            'font-size': '10px', // меняя размер шрифта меняем ширину отступа
            'width' : '0.5em',
            'margin' : '0',
            'border' : 'none',
            'background' : 'none'
        },
        '.ya-partner_type_horiz table.ya-partner__list, .ya-partner_type_horiz td.ya-partner__item,.ya-partner_type_horiz td.ya-partner__gap': {
            'border-collapse': 'separate'
        },
        '.ya-partner_type_horiz .ya-partner__warn,.ya-partner_type_horiz .ya-partner__inner,.ya-partner_type_horiz .ya-partner__text,.ya-partner_type_horiz .ya-partner__url': {
            'display': 'block'
        },
        '.ya-partner_type_horiz.ya-partner_ads_inner-down .ya-partner__item_pos_first':{
            'border-radius': '4px 4px 4px 0',
            '-moz-border-radius': '4px 4px 4px 0',
            '-webkit-border-radius': '4px 4px 4px 0'
        },
        '.ya-partner_ads_inner-down .ya-partner__item_pos_last, .ya-partner_ads_inner-up-down .ya-partner__item_pos_last': {
            'border-radius': '4px'
        },
        '.ya-partner_type_horiz .ya-partner__item_pos_last': {
            'margin-right': '0'
        },
        '.ya-partner_type_horiz .ya-partner__text, .ya-partner_type_horiz .ya-partner__warn': {
            'margin': '0.4em 0'
        }
    },

    // *porperty - IE7  и ниже, не понимает ie7 в режиме совместимости
    // _porperty - IE6  и ниже

    cssIe: {
        //'html* .ya-partner_type_horiz': {
        //    '_width': '99.9%' // эмуляция  'box-sizing': 'border-box' для IE6
        //},
        //'*>body .ya-partner_type_horiz': {
        //    'width': '99.9%' // эмуляция  'box-sizing': 'border-box' для IE7
        //},
        //'html>/**/body .ya-partner_type_horiz': {
        //    'width': '100%' // номализация для IE8
        //},
        '.ya-partner_ads-down .ya-partner__list': {
            'zoom': '1'
        },
        'html* .ya-partner_ads-down .ya-partner__ads': {
            '_bottom': '-1px'
        },
        '.ya-partner_type_horiz .ya-partner__item, .ya-partner_type_horiz .ya-partner__tr, .ya-partner_type_horiz .ya-partner__list': {
            'font-size': '100%'
        },
        '.ya-partner_type_horiz:before,.ya-partner_type_horiz:after': { // clearfix вокруг блока, чтобы не проваливался под другие
            'font': '0/0 a',
            'content': '.'
        }


    },
    // после вставки блока идет работа с картинками этот обработчик делал ingdir@
    constructor: function (cfg) {
        Ya.Context.Direct.Horizontal.superConstructor.apply(this, arguments);
        // Этот фикс не работает для IE6 и для Quirks Mode, т.к. бедняга не понимает скленных классов
        var coeff = 1.2,
            items,
            pics;

        this.css = this.css || {};
        for (items = 2; items <= 4; items++) {
            for (pics = items; pics >= 0; pics--) {
                var whole = coeff * pics + (items - pics),
                    picWidth = Math.ceil(100 * coeff / whole) + '%',
                    textWidth = Math.ceil(100 / whole) + '%',
                    ie6Width = Math.ceil(100 / items) + '%',
                    cssProp = '.ya-partner_type_horiz .ya-context__list_item_' +
                        items + '.ya-context__list_picnum_' +
                        pics + ' ' + '.ya-partner__item';

                if (browser.isIE6 || browser.isIEQuirks || (this.async && browser.isIE7)) {
                    this.css['.ya-partner_type_horiz .ya-context__list_item_' + items + ' ' + '.ya-partner__item'] = {width: ie6Width};
                } else {
                    this.css[cssProp] = {width: textWidth};
                    // склеиваем без пробела, это правило для совмещённых классов!
                    this.css[cssProp + '.ya-partner__item_pic_yes'] = {width: picWidth};
                    this.css[cssProp + '.ya-partner__item_sitelinks_yes'] = {width: picWidth};
                }
            }
        }



        var hn = function () {

            var mainCont = this.getMainCont(),
                tableContainer = dom('.ya-partner__list', this.getMainCont())[0],
                items = dom('.ya-partner__item', mainCont);

            if (!items || !items.length || !tableContainer) {
                return false;
            }

            var wideAdsLen = util.filter(items, function (item) {
                return dom.hasClass(item, 'ya-partner__item_pic_yes') ||
                    dom.hasClass(item, 'ya-partner__item_sitelinks_yes');
            }).length;

            // ie6 или ie quirks не понимают склеенных классов, для них более простая схема
            if (browser.isIE6 || browser.isIEQuirks) {
                dom.addClass(tableContainer, 'ya-context__list_item_' + items.length);
            } else {
                dom.addClass(tableContainer, 'ya-context__list_item_' + items.length + ' ya-context__list_picnum_' + wideAdsLen);
            }
        };

        this.on('afterRender', hn, this);
    }

});

;
    // Плоский блок, тот у которого в последнем варианте объявления в строку. Это класс резинового блока
Ya.Context.Direct.Flat = util.augment(Ya.Context.Direct.Direct, {

    classes: 'ya-partner_type_flat',

    css: {
        '.ya-partner_type_flat .ya-partner__title-link, .ya-partner_type_flat .ya-partner__text, .ya-partner_type_flat .ya-partner__url': {
            'display': 'inline',
            'vertical-align': 'baseline'
        },
        ':root .ya-partner_type_flat': { // IE9=10 fix
            'display': 'table\\0/IE9',
            'width': '100%\\0/IE9'
        },
        ':root .ya-partner_type_flat.ya-partner_border.ya-partner_ads-down .ya-partner__ads': { // IE9=10 fix  из-за таблицы
            'bottom': '1px\\0/IE9'
        },
        '.ya-partner_type_flat .ya-partner__item': {
            'display': 'block',
            'line-height': 'normal'
        },
        '.ya-partner_type_flat .ya-partner__text': {
            'padding-left': '0.5em'
        },
        '.ya-partner_type_flat .ya-partner__warn': {
            'display': 'block',
            'margin-top': '0.3em'
        },
        '.ya-partner_type_flat .ya-partner__text .ya-partner__agewarn-cont': {
            'float': 'none'
        },
        // fixes bug in Chrome YACONTEXT-10654
        '.ya-partner_type_flat .ya-partner__text .ya-partner__clearfix': {
            display: 'none'
        },
        '.ya-partner_type_flat .ya-partner__l-td': {
             'vertical-align': 'middle'
        },
        '.ya-partner_type_flat .ya-partner__l-table': {
            'width': '100%'
        },
        '.ya-partner_type_flat .ya-partner__l-pic-td': {
            // will fit to pic width
            'width': '1px'
        },
        '.ya-partner_type_flat .ya-partner__item_pic_yes .ya-partner__text': {
            'display': 'block'
        },
        /*'.ya-partner_theme_flat .ya-partner__list': {
            'padding-bottom': '0.3em'
        },*/
        '.ya-partner_theme_flat_inner .ya-partner__item' :{
            'margin-bottom': '0.5em'
        },
        '.ya-partner_theme_flat_inner .ya-partner__item_pos_last' :{
            'margin-bottom': '0'
        },
        '.ya-partner_type_flat-simple .ya-partner__list': {
//            'margin': '.5em 0'
        },
        '.ya-partner_type_flat-simple .ya-partner__url': {
            'display': 'block',
            'margin-top': '0.3em'
        },
        '.ya-partner_type_flat-simple .ya-partner__item': {
            'padding-top': '0.5em',
            'padding-bottom': '0.5em'
        },
        '.ya-partner_type_flat-simple .ya-partner__item_pic_yes': {
            'padding-top': '.2em',
            'padding-bottom': '.2em'
        },
        '.ya-partner_type_flat-simple .ya-partner__text': {
            'padding-left': '0'
        }
    },

    cssIe: {
        '.ya-partner_type_flat': {
            'zoom': '1'
        },
        '.ya-partner_theme_flat .ya-partner__icon': {
            'margin-bottom': '-2px'
        },
        'html* .ya-partner_ads-down .ya-partner__list': {
            'padding-bottom': 0,
            '_margin-bottom': '0.9em'
        }
    }
});


;
    // авто блок, это горизонтальный с 3-мя объявлениями, который автоматически рисуется вверху странице, выше всего контента
Ya.Context.Direct.Auto = util.augment(Ya.Context.Direct.Horizontal, {

    classes: 'ya-partner_type_auto',

    css: {
        '.ya-partner_type_auto': {
            'display': 'block'
        },
        '.ya-partner__close-text': {
            'display': 'inline'
        },
        '.ya-partner__close-button': {
            'display': 'inline'
        },
        '.ya-partner__close': {
            'bottom': '-0.2em',
            'right': '1em',
//            'height': '12px',
            /*'width': '12px',*/
            'cursor': 'pointer',
            'margin': '0',
            'position': 'absolute'
        },

        '.ya-partner_type_auto .ya-partner__ads': {
            'width': '100%'
        }
    },
    cssIe: {
            '.ya-partner__close': {
                'bottom': '0'
            }
        },
    // после отрисовки оживляем кнопку закрыть
    constructor: function () {
        Ya.Context.Direct.Auto.superConstructor.apply(this, arguments);
        this.on('afterRender', this.initCloseLink, this);
    },

    /**
     * Ссылка Закрыть для Авто блока
     * @return String
     */
    initCloseLink: function() {
        var domEl = dom('.ya-partner__close', this.getMainCont())[0];
        domEvent.on(domEl, 'click', this.destructor, this);
    },

    // вставляем ХТМЛ так чтобы блок был выше всего контента на странице и не было проблем с исключениями при работе с ДОМ
    insertHtml: function (html) {
        var body = document.body,
            block = document.createElement('div');

        // magic for IE
        body.insertBefore(block, body.firstChild);
        block.innerHTML = html;

        body.insertBefore(block.firstChild, block);

        dom.remove(block);

        return true;
    },

    // дополнительные стили для этого блока,
    decorateCss:function (css) {
        Ya.Context.Direct.Auto.superclass.decorateCss.call(this, css);

        this.addCssStyle(
            '.ya-partner__close',
            css,
            {color: this.getBlockBgColor().isLight() ? '#000' : '#fff'}
        );
    },

    // всегда фиксированное число объявлений
    getAdvsCount: function () {
        return this.settings.format.limit;
    }
});
;
    // Рекламная полоска
// @example
// Ya.HeadStripe.build(prefs);
// примеры с настройками см. в папке ./test/prefs/

(function (window, document) {

    var ANIMATION_TIME = 500;
    var STRIPE_TYPE = {
        float: '1',
        shift: '2'
    };

    window.Ya = window.Ya || {};

    function isMiddleButton(e) {
        if (e.which !== undefined && e.which == 2) {
            return true;
        } else if (e.button !== undefined && (e.button == 1 || e.button == 4)) {
            return true;
        } else {
            return false;
        }
    }

    function bindToMiddleClick( element, handler, context ) {

        var timerUp,
            context = context || null,
            maxMsDifference = 500;

        domEvent.on( element, "mousedown", function (e) {
            if ( isMiddleButton(e) ) {
                timerUp = +new Date;
            }
        });

        domEvent.on( element, "mouseup", function (e) {
            if ( isMiddleButton(e) ) {
                var timerDown = +new Date;
                if ( timerDown - timerUp <= maxMsDifference ) {
                    handler.call(context);
                }
            }
        });
    }

    // простая шаблонизация
    // @param {string} text - шаблон
    // @param {object} data - хеш с данными
    // @example
    //      supplant('<div>{a}</div>', {a: 1});
    function supplant(text, data) {
        return text.replace(/\[([^\[\]]*)\]/g, function (a, b) {
            return '' + data[b];
        });
    }
    
    function getBody() {
        return document.body;
    }

    Ya.HeadStripe = {

        // постфикс для создания уникальных CSS-классов
        _postfix: util.genRnd(),

        hasBeenDisplayed : false,

        // таймер анимации
        _animationTimer: null,

        // тип полоски, по муолчанию выбрана наплывающая, как некалечащая верстку сайта
        _type: STRIPE_TYPE.float,

        // включена ли анимация
        _animated: false,

        // CSS-шаблон
        css: "body .ya-head-stripe[ns] {\
            position: absolute !important;\
            left: 0 !important;\
            top: 0 !important;\
            width: 100% !important;\
            min-width: 660px !important;\
            height: [height] !important;\
            font-size: [fontSize] !important;\
            background-color: [backgroundColor] !important;\
            z-index: [zIndex]1 !important;\
            overflow: hidden !important;\
            box-shadow: 1px 1px 1px #999 !important;\
        }\
        .ya-head-stripe[ns],\
        .ya-head-stripe[ns] div,\
        .ya-head-stripe[ns] i,\
        .ya-head-stripe[ns] a {\
            float: none !important;\
            clear: none !important;\
            cursor: default !important;\
            border: 0 !important;\
            outline: 0 !important;\
            padding: 0 !important;\
            margin: 0 !important;\
            background: none;\
            letter-spacing: normal !important;\
            text-indent: 0 !important;\
            text-transform: none !important;\
            text-align: left !important;\
            vertical-align: middle !important;\
            font-family: Arial, Verdana, Tahoma, sans-serif !important;\
            font-style: normal !important;\
            font-weight: normal !important;\
            font-variant: normal !important;\
            visibility: visible !important;\
            white-space: normal !important;\
            word-spacing: normal !important;\
            min-width: 0 !important;\
            min-height: 0 !important;\
            line-height: normal !important;\
        }\
        body .ya-head-stripe_animation-position_0[ns] {\
            top: -[height] !important;\
        }\
        body .ya-head-stripe_animation-position_1[ns] {\
            top: 0 !important;\
        }\
        body .ya-head-stripe_animation-position_2[ns] {\
            top: -[height] !important;\
        }\
        body .ya-head-stripe__background-gradient[ns] {\
            position: absolute !important;\
            left: 0 !important;\
            top: 0 !important;\
            width: 100% !important;\
            height: 100% !important;\
            background-color: transparent !important;\
            background-position: 0 0 !important;\
            background-repeat: repeat-x !important;\
            background-image: [backgroundGradient] !important;\
            z-index: [zIndex]2 !important;\
        }\
        body .ya-head-stripe__background-image[ns] {\
            position: absolute !important;\
            left: 0 !important;\
            top: 0 !important;\
            width: 100% !important;\
            height: 100% !important;\
            background-color: transparent !important;\
            background-position: [backgroundImageLeft] 0 !important;\
            background-repeat: no-repeat !important;\
            background-image: [backgroundImage] !important;\
            z-index: [zIndex]3 !important;\
        }\
        \
        body .ya-head-stripe__void[ns] {\
            position: absolute !important;\
            left: 0 !important;\
            top: 0 !important;\
            width: 100% !important;\
            height: 100% !important;\
            z-index: [zIndex]4 !important;\
            font-size: 0 !important;\
            line-height: 0 !important;\
        }\
        \
        body .ya-head-stripe__text1[ns] {\
            position: absolute !important;\
            top: 0 !important;\
            left: [text1Left] !important;\
            width: auto !important;\
            height: 100% !important;\
            line-height: [height] !important;\
            font-size: [fontSize] !important;\
            text-decoration: [text1Decoration];\
            vertical-align: middle !important;\
            z-index: [zIndex]5 !important;\
        }\
        \
        body a.ya-head-stripe__text1[ns]:link,\
        body a.ya-head-stripe__text1[ns]:visited {\
            color: [text1Color] !important;\
            text-decoration: [text1Decoration];\
        }\
        \
        body a.ya-head-stripe__text1[ns]:hover {\
            color: [text1HoverColor] !important;\
            text-decoration: [text1Decoration];\
        }\
        \
        body a.ya-head-stripe__text1[ns]:active {\
            color: [text1Color] !important;\
            text-decoration: [text1Decoration];\
        }\
        \
        body a.ya-head-stripe__text1[ns]:focus {\
            color: [text1Color] !important;\
            text-decoration: [text1Decoration];\
        }\
        \
        body .ya-head-stripe__text2[ns] {\
            position: absolute !important;\
            left: [text2Left] !important;\
            top: 0 !important;\
            width: auto !important;\
            height: 100% !important;\
            color: [text2Color] !important;\
            line-height: [height] !important;\
            font-size: [fontSize] !important;\
            vertical-align: middle !important;\
            z-index: [zIndex]5 !important;\
        }\
        \
        body a.ya-head-stripe__text1[ns],\
        body a.ya-head-stripe__text2[ns],\
        body div.ya-head-stripe__close[ns],\
        body span.ya-head-stripe__close-text[ns],\
        body span.ya-head-stripe__close-times[ns] {\
            cursor: pointer !important;\
            white-space: nowrap !important;\
        }\
        \
        body a.ya-head-stripe__text2[ns]:link,\
        body a.ya-head-stripe__text2[ns]:visited {\
            color: [text2Color] !important;\
            text-decoration: [text2Decoration];\
        }\
        \
        body a.ya-head-stripe__text2[ns]:hover {\
            color: [text2HoverColor] !important;\
            text-decoration: [text2Decoration];\
        }\
        \
        body a.ya-head-stripe__text2[ns]:active {\
            color: [text2Color] !important;\
            text-decoration: [text2Decoration];\
        }\
        \
        body a.ya-head-stripe__text2[ns]:focus {\
            color: [text2Color] !important;\
            text-decoration: [text2Decoration];\
        }\
        \
        body .ya-head-stripe__close[ns] {\
            position: absolute !important;\
            display: inline-block !important;\
            top: 0 !important;\
            right: [closeLeft] !important;\
            width: auto !important;\
            height: [height] !important;\
            color: [closeColor] !important;\
            line-height: [height] !important;\
            vertical-align: middle !important;\
            text-align: right !important;\
            z-index: [zIndex]5 !important;\
            white-space: nowrap !important;\
        }\
        \
        body .ya-head-stripe__close-text[ns] {\
            display: inline !important;\
            position: static !important;\
            border-bottom: [closeDecoration] dotted [closeColor] !important;\
            text-decoration: none !important;\
            line-height: [height] !important;\
            font-size: [fontSize] !important;\
        }\
        \
        body .ya-head-stripe__close[ns]:hover {\
            color: [closeHoverColor] !important;\
        }\
        \
        body .ya-head-stripe__close-text[ns]:hover {\
            border-bottom: [closeDecoration] dotted [closeHoverColor] !important;\
        }\
        \
        body .ya-head-stripe__close-times[ns] {\
            display: inline !important;\
            position: static !important;\
            font-size: [fontSize] !important;\
            line-height: [height] !important;\
            margin-bottom: 0 !important;\
            margin-right: 5px !important;\
        }\
        \
        body .ya-head-stripe__cap[ns] {\
            display: block !important;\
            position: static !important;\
            width: 100%;\
            height: [height];\
            line-height: 0 !important;\
            font-size: 0 !important;\
            background: none !important;\
        }\
        \
        body .ya-head-stripe__cap-animation_yes[ns] {\
            -moz-transition: height [animationTime] !important;\
            -webkit-transition: height [animationTime] !important;\
            -o-transition: height [animationTime] !important;\
            -ms-transition: height [animationTime] !important;\
        }\
        \
        body .ya-head-stripe__cap-animation-position_0[ns] {\
            height: 0 !important;\
        }\
        \
        body .ya-head-stripe__cap-animation-position_1[ns] {\
            height: [height]  !important;\
        }\
        \
        body .ya-head-stripe__cap-animation-position_2[ns] {\
            height: 0 !important;\
        }\
        \
        body .ya-head-stripe__age-warning[ns] {\
            position: absolute !important;\
            display: inline-block !important;\
            color: [text1Color] !important;\
            width: auto !important;\
            height: [height] !important;\
            font-size: [fontSize] !important;\
            line-height: [height] !important;\
            position: absolute !important;\
            vertical-align: middle !important;\
            z-index: [zIndex]6 !important;\
            top: 0 !important;\
            right: 2px !important;\
        }",

        // 14-колонник
        _columns: [0, 2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98, 100],

        // подсчет позиции X по номеру колонки
        // @param {number} col - колонка
        // @return {string} позиция X
        _calcLeft: function (col) {
            if (col < 0) {
                col = 0;
            }

            if (col > 14) {
                col = 14;
            }

            return this._columns[col] + '%';
        },

        _maxZIndex: 200000,

        //!\ Свойство, позволяющее яваскрипу яндекс-почты откладывать вывод полоски. (тикет DARIA-22955)
        // true - (По умолчанию) полоска выводится сразу же после того, как в loadStripeData
        //         передается объект, описывающий полоску.
        // false - Ya.loadStripeData просто обрабатывает поступивший объект. После этого надо
        //         явно разблокировать вывод полоски и вызвать Ya.HeadStripe.showStripe(), передав туда некий колбэк.
        //         в колбэк будет передано булево значение ( true, если нам было чего выводить и полоска была выведена,
        //         false если наоборот.)
        // TODO enable for mail integration
        autoRender : true,

        /// _loadedOnce: false,

        /**
         * This should work only once, because `HeadStripe' is a singleton.
         * Otherwise, it will merge stripe settings from subsequent calls.
         */
        loadStripeData: function (parsedData) {
            if (!this._loadedOnce && parsedData.stripe && parsedData.stripe.data) {
                this._loadedOnce = true;

                this._prefs = parsedData.stripe.data;

                // ujin@ -- Yes, I know, it belongs to `this.validatePrefs`. 
                // I don't care anymore.
                this.validatePrefs();

                // Определяем тип. '1' - float, '2' - shift. По умолчанию float.
                if (parsedData.common.stripeType && parsedData.common.stripeType === STRIPE_TYPE.shift) {
                    this._type = STRIPE_TYPE.shift;
                }

                // Включена ли анимация. '0' - выключена, '1' - включена. По умолчанию выключена.
                // В stripe.data может быть свойство animation, это старая настройка анимации, сейчас мы ее игнорируем.
                if (parsedData.common.stripeAnimation && parsedData.common.stripeAnimation === '1') {
                    // Для IE версии меньше 9 все равно выключена.
                    this._animated = !(browser.isIE6 || browser.isIE7 || browser.isIE8);
                }
                
                if (this._prefs.linkNext) {
                    this._prefs.linkNext = parsedData.common.linkHead + this._prefs.linkNext;
                }
                
                if (this.autoRender) {
                    this.renderBlock();
                }
            }
        },

        renderBlock : function ( callback ) {

            callback = callback || function() {};

            // render stripe if we have data, we're not in some frame and we haven't rendered stripe yet
            if ( this._prefs 
                    && window.top == window 
                    && !this.hasBeenDisplayed ) {
                this.init();
                this.injectStripeStyles();
                this.injectStripeNode();

                // Check visibility
                this.launchVisibilityChecker();

                this.hasBeenDisplayed = true;
                callback(true);
            } else {
                callback(false);
            }
        },

        validatePrefs: function () {
            var prefs = this._prefs;
            prefs.autoClose = parseInt(prefs.autoClose, 10) || 0;
            prefs.fontSize = parseInt(prefs.fontSize, 10) || 0;
            prefs.height = parseInt(prefs.height, 10) || 0;
            prefs.text1Left = parseInt(prefs.text1Left, 10) || 0;
            prefs.text2Left = parseInt(prefs.text2Left, 10) || 0;
            prefs.closeLeft = parseInt(prefs.closeLeft, 10) || 0;
            prefs.backgroundImageLeft = parseInt(prefs.backgroundImageLeft, 10) || 0;
        },

        // инициализация полоски
        init: function () {

            var that = this;

            // Показывается всегда только одна полоска
            if (this._isInited) {
                this.destroyStripeNode();
            }

            this._isInited = true;
            this._postfix++;

            if (this._prefs.autoClose) {
                this._autoCloseTimer = env.setProtectedTimeout(function () {
                    that.close();
                }, this._prefs.autoClose * 1000);
            }
        },

        // вставка и шаблонизация CSS полоски
        injectStripeStyles: function () {
            var cssNode = document.createElement('style'),
                css = this.css,
                prefs = this._prefs,
                backgroundGradient = prefs.backgroundGradient ? 'url(' + prefs.backgroundGradient + ')' : 'none',
                backgroundImage = prefs.backgroundImage ? 'url(' + prefs.backgroundImage + ')' : 'none',
                height = prefs.height + (('' + prefs.height).search(/[w]/) == -1 ?  'px' : ''),
                fontSize = prefs.fontSize + (('' + prefs.fontSize).search(/[w]/) == -1 ?  'pt' : ''),
                closeLeft = this._calcLeft((this._columns.length - prefs.closeLeft - 1) || 0),
                that = this;

            css = supplant(css, {
                height: height,
                fontSize: fontSize,
                // Время анимации хоть и передается, но классы для анимации через css все равно не выставляются.
                // Видимо довести до рабочего состояния не смогли.
                animationTime: (this._animated ? ANIMATION_TIME : 0) + 'ms',
                text1Color: prefs.text1Color || '#fff',
                text1HoverColor: prefs.text1HoverColor || '#fff',
                text1Decoration: this._textDecoration(prefs.text1Decoration),
                text1Left: this._calcLeft(prefs.text1Left || 0),
                text2Color: prefs.text2Color || '#fff',
                text2HoverColor: prefs.text2HoverColor || '#fff',
                text2Decoration: this._textDecoration(prefs.text2Decoration),
                text2Left: this._calcLeft(prefs.text2Left || 0),
                closeColor: prefs.closeColor || '#fff',
                closeHoverColor: prefs.closeHoverColor || '#fff',
                closeDecoration: prefs.closeDecoration ? '1px' : 'none',
                closeLeft: closeLeft,
                backgroundGradient: backgroundGradient,
                backgroundColor: prefs.backgroundColor || 'none',
                backgroundImage: backgroundImage,
                backgroundImageLeft: this._calcLeft(prefs.backgroundImageLeft || 0),
                zIndex: this._maxZIndex,
                ns: this._postfix
            });

            cssNode.type = 'text/css';

            domEvent.ready(function () {
                var b = getBody();
                
                if (b.firstChild && browser.isIE) {
                    b.insertBefore(cssNode, b.firstChild);
                } else {
                    b.appendChild(cssNode);
                }
                
                // в IE сначала надо присоединить ноду, потом писать туда
                // http://msdn2.microsoft.com/en-us/library/ms533698(VS.85).aspx
                if (cssNode.styleSheet) { // IE
                    cssNode.styleSheet.cssText = css;
                } else if (that.isWebkit()) {
                    cssNode.innerText = css;
                } else {
                    cssNode.innerHTML = css;
                }
            }, this );

            this._cssNode = cssNode;
        },

        // просчёт свойства шрифта text-decoration
        // @param {strin|boolean} col - колонка
        // @return {string} значение CSS-свойства text-decoration
        _textDecoration: function (prop) {
            if (prop === true) {
                return 'underline';
            }

            if (prop) {
                return prop;
            }

            return 'none';
         },

        isWebkit: function () {
            return (window.navigator.userAgent || '').search('webkit') != -1;
        },

        // вставка HTML для полоски
        injectStripeNode: function () {
            var root = document.createElement('div'),
                prefs = this._prefs,
                that = this,
                text1, text2, textClose, el, _void, cap, ageWarning;

            this._root = root;

            // Основной блок полоски
            root.className = 'ya-head-stripe' + this._postfix;
            dom.setImportantCssProperty(root, "top", -1 * prefs.height + "px");

            // displacing div for "shift" stripe mode
            if (this._type === STRIPE_TYPE.shift) {
                this._cap = (cap = document.createElement('div'));
                cap.className = 'ya-head-stripe__cap' + this._postfix;
                getBody().insertBefore(cap, getBody().firstChild);
                dom.setImportantCssProperty(cap, "height", "0px");
            }       

            // Первая ссылка-текст
            if (prefs.text1) {
                text1 = document.createElement(prefs.text1Url ? 'a' : 'div');
                text1.className = 'ya-head-stripe__text1' + this._postfix;
                text1.innerHTML = prefs.text1;
                if (prefs.text1Url) {
                    text1.href = prefs.text1Url;
                    if (prefs.text1Target) {
                        text1.target = prefs.text1Target;
                    }
                }

                bindToMiddleClick(text1, this.close, this);
                domEvent.on(text1, "click", this.close, this);

                root.appendChild(text1);
            }

            // Вторая ссылка-текст
            if (prefs.text2) {
                text2 = document.createElement(prefs.text2Url ? 'a' : 'div');
                text2.className = 'ya-head-stripe__text2' + this._postfix;
                text2.innerHTML = prefs.text2;
                if (prefs.text2Url) {
                    text2.href = prefs.text2Url;
                    if (prefs.text2Target) {
                        text2.target = prefs.text2Target;
                    }
                }

                bindToMiddleClick( text2, this.close, this );
                domEvent.on( text2, "click", this.close, this);

                root.appendChild(text2);
            }

            // Ссылка закрытия
            if (prefs.close) {
                textClose = document.createElement('div');
                textClose.className = 'ya-head-stripe__close' + this._postfix;
                textClose.innerHTML = '<span class="ya-head-stripe__close-times' + this._postfix + '">&#215;</span>'
                    + '<span class="ya-head-stripe__close-text' + this._postfix + '">' + prefs.close + '</span>';


                bindToMiddleClick( textClose, function () {
                    this.setStripeClosedCookie();
                    this.close();                    
                }, this );

                domEvent.on( textClose, "click", function () {
                    this.setStripeClosedCookie();
                    this.close();                    
                }, this );                 

                root.appendChild(textClose);
            }

            // Блок с повторяющимся градиентом
            if (prefs.backgroundGradient) {
                el = document.createElement('div');
                el.className = 'ya-head-stripe__background-gradient' + this._postfix;
                root.appendChild(el);
            }

            // Блок с фоновой картинкой
            if (prefs.backgroundImage) {
                el = document.createElement('div');
                el.className = 'ya-head-stripe__background-image' + this._postfix;
                root.appendChild(el);
            }

            // Текст про возраст (например: 0+)
            if (prefs.ageRestriction) {
                // Age warning
                ageWarning = document.createElement('div');
                ageWarning.className = "ya-head-stripe__age-warning" + this._postfix;
                ageWarning.innerHTML = prefs.ageRestriction;
                dom.setImportantCssProperty(ageWarning, "height", "20px");
                root.appendChild(ageWarning);
            }

            // Пустой блок для скрытия полоски после клика на неё
            _void = document.createElement(prefs.voidUrl ? 'a' : 'div');
            _void.className = 'ya-head-stripe__void' + this._postfix;
            if (prefs.voidUrl) {
                _void.href = prefs.voidUrl;
                if (prefs.voidTarget) {
                    _void.target = prefs.voidTarget;
                }
            }
            domEvent.on( _void, 'click', this.close, this);
            root.appendChild(_void);

            domEvent.ready( function () {
                var b = getBody();
                
                if (b.firstChild && browser.isIE) {
                    b.insertBefore(root, b.firstChild);
                } else {
                    b.appendChild(root);
                }

                if (this._animated) {
                    var animations = [{
                        element: root,
                        property: 'top',
                        from: -1  * this._prefs.height,
                        to: 0
                    }];

                    if (this._cap) {
                        animations.push({
                            element: this._cap,
                            property: 'height',
                            from: 0,
                            to: prefs.height
                        });
                    }

                    this._animate(animations);
                } else {
                    dom.setImportantCssProperty(root, "top", "0px");
                    that._cap && dom.setImportantCssProperty(cap, "height", prefs.height + "px");
                }
            }, this );
        },

        // закрыть полоску
        close: function () {
            var that = this;

            // If animation is going
            if (this._animationTimer) {
                return;
            }

            var onAnimationEnd = function () {
                that.destroyStripeNode();
            };

            if (this._animated) {
                var animations = [{
                    element: this._root,
                    property: 'top',
                    from: 0,
                    to: -1  * this._prefs.height
                }];

                if (this._cap) {
                    animations.push({
                        element: this._cap,
                        property: 'height',
                        from: this._prefs.height,
                        to: 0
                    });
                }

                this._animate(animations, onAnimationEnd);
            } else {
                // без этого таймаута ссылку выкинет из дома до того, как мы по ней сходим.
                env.setProtectedTimeout(onAnimationEnd, 200);
            }
        },

        // счётчик БК для отслеживание кликов на элементы
        setStripeClosedCookie: function () {
            (new Image).src = this._prefs.closeUrl;
        },

        // удаление полоски и её ресурсов
        destroyStripeNode: function () {
            if (this._isInited) {
                this._cancelAnimation();

                if (this._root) {
                    this.visibilityChecker.clear();

                    getBody().removeChild(this._root);
                    delete this._root;
                }

                if (this._cssNode) {
                    getBody().removeChild(this._cssNode);
                    delete this._cssNode;
                }

                if (this._cap) {
                    getBody().removeChild(this._cap);
                    delete this._cap;
                }

                if (this._autoCloseTimer) {
                    clearTimeout(this._autoCloseTimer);
                    delete this._autoCloseTimer;
                }

                this._isInited = false;
            }
        },

        launchVisibilityChecker: function () {
            var confirmDelay = Ya.Const.Limits.stripeVisibCheckDelay;
            if (this._animated) {
                confirmDelay -= ANIMATION_TIME;
            }

            this.visibilityChecker = new VisibilityChecker({
                confirmDelay: confirmDelay
            });

            if (this._prefs.linkNext) {
                this.visibilityChecker.on('confirmed', function () {
                    this.onConfirmVisibility();

                    env.log('sendVisibility: stripe', this._prefs.type);
                }, this);

                // Start listening after transition
                env.setProtectedTimeout(function () {
                    this.visibilityChecker.listen(this._root);
                }, this._animated ? ANIMATION_TIME : 0, this);
            }
        },

        onConfirmVisibility : function () {
            (new Image).src = this._prefs.linkNext;
        },

        /**
         * Applies CSS styles for multiple elements gradually over time.
         *
         * @param {Array} animations
         * @param {Function} callback
         *
         * @param animations[].element HTML element
         * @param animations[].property CSS property
         * @param animations[].from Initial style value
         * @param animations[].to Final style value
         */
        _animate: function (animations, callback) {
            var stepCount = 15;
            var stepDuration = Math.floor(ANIMATION_TIME / stepCount);
            var _this = this;

            var doStep = function (n) {
                _this._animationTimer = env.setProtectedTimeout(function () {
                    util.each(animations, function (cfg) {
                        var val = (cfg.from + (n * (cfg.to - cfg.from) / stepCount));
                        dom.setImportantCssProperty(cfg.element, cfg.property, val.toFixed(3) + 'px');
                    });

                    if (n < stepCount) {
                        doStep(n + 1);
                    } else {
                        _this._animationTimer = null;

                        if (callback) {
                            callback();
                        }
                    }
                }, stepDuration);
            };

            doStep(1);
        },

        /**
         * Cancels the currently running animation.
         */
        _cancelAnimation: function () {
            if (this._animationTimer) {
                clearTimeout(this._animationTimer);
                this._animationTimer = null;
            }
        }
    };
})(window, document);

// Заглушка для диспетчера блоков
Ya.Context.Direct.Stripe = function () {
    this.render = this.destructor = function () {};
};

;
    // суперстрочный блок
Ya.Context.Direct.Row = util.augment(Ya.Context.Direct.Direct, {
    classes: 'ya-partner_type_row ya-partner_ads_only-arrow ya-partner__hide-urls',
    css: {
        '.ya-partner_type_row': {
            'height': '2.2em',
            'overflow': 'hidden'
        },
        '.ya-partner_type_row .ya-partner__item': {
            'padding': '0.4em 0.5em',
            'display': 'block',
            'border-radius': '',
            'white-space': 'nowrap',
            overflow: 'hidden',
            '-webkit-text-overflow': 'ellipsis',
            '-moz-text-overflow': 'ellipsis',
            '-ms-text-overflow': 'ellipsis',
            'text-overflow': 'ellipsis'
        },
        '.ya-partner_type_row .ya-partner': {
            'border-radius': ''
        },
        '.ya-partner_type_row .ya-partner__text .ya-partner__agewarn-cont': {
            'float': 'none'
        },
        '.ya-partner_type_row .ya-partner__address': {
            'margin-right': '0.5em'
        },
        '.ya-partner_type_row .ya-partner__title-link, .ya-partner_type_row .ya-partner__title-link-text': {
            'white-space': 'nowrap'
        },
        '.ya-partner_type_row .ya-partner__text': {
            'margin': '0 0.4em',
            'white-space': 'nowrap'
        },
        '.ya-partner_type_row .ya-partner__ads-l': {
            'line-height': '1.8em'
        },
        '.ya-partner_type_row .ya-partner__url': {
            'display': 'inline'
        },
        '.ya-partner_type_row .ya-partner__sitelinks': {
            'display': 'none'
        }
    },

    // у этого блока цвета фона навешиваем всегда на класс .ya-partner
    addHeaderBorderCss: function (css) {
        Ya.Context.Direct.Row.superclass.addHeaderBorderCss.call(this, css);

        var settings = this.settings;
        //settings.bgColor = '#DAE4EF';
        this.addCssStyle('.ya-partner', css, {background: settings.bgColor});

        //dom('#yandex_direct_sideadv').style.width = '1111px';

    },

    decorateCss: function(css) {
        css = Ya.Context.Direct.Row.superclass.decorateCss.call(this, css);

        var c11n = this.settings.c11n;
        if ('minWidth' in c11n) {
            this.addCssStyle('.ya-partner_type_row', css, {'min-width': c11n.minWidth + 'px'});
        }
        if ('itemPadding' in c11n) {
            this.addCssStyle('.ya-partner_type_row .ya-partner__item', css, {padding: c11n.itemPadding});
        }
        if ('arrowTextUnderline' in c11n && util.isArray(c11n.arrowTextUnderline)) {
            this.addCssStyle('a.ya-partner__ads-link-l:link,a.ya-partner__ads-link-l:visited',
                             css,
                             {'text-decoration': !!c11n.arrowTextUnderline[0]? 'underline' : 'none'});

            this.addCssStyle('a.ya-partner__ads-link-l:hover',
                             css,
                             {'text-decoration': !!c11n.arrowTextUnderline[1]? 'underline' : 'none'});
        }

        return css;

    }
});
;
    /**
 * Фиксированные блоки.
 *
 * 160x600, 240x400, 200x300, 300x300, 300x250, 250x250 наследуются от Vertical.
 * 728x90, 1000x120 наследуются от Flat.
 */

util.ns('Ya.Context.Direct');

var NORMAL = 'normal';
var BLOCK = 'block';

/**
 * Методы и свойства, общие для всех фиксированных блоков.
 */
var FixedBlock = {
    /**
     * Запускает `_removeOverflow' и `_adjustItemIndents'.
     */
    setupRemoveOverflow: function () {
        // удаляем лишние объявления или их части
        this._removeOverflow();
        // центрируем объявления в блоке по вертикали
        this._adjustItemIndents();
    },

    /**
     * Убирает объявления, не влезающие в фиксированный блок. Затем
     * пытается добавить дополнительные элементы, скрытые через классы.
     * Возвращает не влезшие объявления обратно в data-source.
     */
    _removeOverflow: function () {
        var cont = this.getMainCont().getElementsByTagName('yatag')[0];
        var items = dom('.ya-partner__item', cont);

        var hasScroll = function () {
            // allow small overflow (bottom padding, margin & possible quirks)
            return dom.getScroll(cont) > 4;
        };

        // rm ads that flow over
        while (items.length > 1 && hasScroll()) {
            var item = items.pop();
            var newLength = items.length;

            // mind the gap
            var prev = item.previousSibling;
            if (prev && dom.hasClass(prev, 'ya-partner__gap')) {
                dom.remove(prev);
            }

            // set last item class
            dom.addClass(items[newLength - 1], 'ya-partner__pos_last');

            // this is for 728x90 and 1000x120 with images
            // reset widths of TDs in row
            if (item.tagName.toLowerCase() == 'td') {
                var newWidth = Math.floor(100 / newLength) + '%';
                util.each(items, function (item) {
                    dom.setImportantCssProperty(item, 'width', newWidth);
                });
            }

            // remove the ad element
            dom.remove(item);

            // finally, release ad to data source
            this.dataSource.releaseAd(this.advs.pop());
        }

        // try showing sitelinks
        if (!this.settings.noSitelinks) {
            var hideAllSitelinksCl = 'ya-partner__overflow-hide-all-sitelinks';
            var hideSitelinkPrefix = 'ya-partner__overflow-hide-sitelink-';

            var sitelinksVisible = false;
            for (var i = 1; !hasScroll() && i <= 3; i++) {
                var cl = hideSitelinkPrefix + i;
                dom.removeClass(cont, cl);
                if (!sitelinksVisible) {
                    dom.removeClass(cont, hideAllSitelinksCl);
                }
                if (hasScroll()) {
                    dom.addClass(cont, cl);
                    if (!sitelinksVisible) {
                        dom.addClass(cont, hideAllSitelinksCl);
                    }
                } else {
                    sitelinksVisible = true;
                }
            }
        }

        // try showing domain & region
        if (!hasScroll()) {
            var hideURLsCl = 'ya-partner__overflow-hide-urls';
            dom.removeClass(cont, hideURLsCl);
            if (hasScroll()) {
                dom.addClass(cont, hideURLsCl);
            }
        }
    },

    // создаёт отступы между объявлениями в фиксированном блоке
    _adjustItemIndents: function () {
        var prop = 'padding';
        var cont = this.getMainCont().getElementsByTagName('yatag')[0];
        var items = dom('.ya-partner__item', cont);

        // exit, if no space OR is a horizontal table layout (like 728x90xIMG)
        if (dom.getScroll(cont) || items[0].tagName.toLowerCase() == 'td') {
            return;
        }

        var indent = parseFloat(dom.getStyle(items[0], prop + '-top')) || 0;

        var setIndent = function () {
            var padPx = indent + 'px';
            util.each(items, function (item) {
                dom.setImportantCssProperty(item, prop + '-top', padPx);
                dom.setImportantCssProperty(item, prop + '-bottom', padPx);
            });
        };

        do {
            indent += 1;
            setIndent();
        } while (indent < 50 && !dom.getScroll(cont));

        // step back if block content flows over
        if (dom.getScroll(cont)) {
            indent -= 1;
            setIndent();
        }
    },

    classes: [
        'ya-partner_fixed_yes',
        'ya-partner__overflow-hide-urls',
        'ya-partner__overflow-hide-all-sitelinks',
        'ya-partner__overflow-hide-sitelink-1',
        'ya-partner__overflow-hide-sitelink-2',
        'ya-partner__overflow-hide-sitelink-3'
    ].join(' '),

    css: {
        '.ya-partner_fixed_yes': {
            'font-size': '12px'
        },

        '.ya-partner_fixed_yes *, .ya-partner_fixed_yes yatag': {
            'font-family': 'Arial, sans-serif',
            'word-spacing': NORMAL,
            'letter-spacing': NORMAL
        },

        '.ya-partner_fixed_yes .ya-partner__ads': {
            'line-height': '13px',
            'font-size': '11px'
        },

        '.ya-partner_fixed_yes .ya-partner__item': {
            'line-height': '14px',
            margin: 0,
            padding: '3px 6px'
        },

        '.ya-partner_fixed_yes.ya-partner_ads-down .ya-partner__list': {
            'padding-bottom': '14px'
        },

        '.ya-partner_fixed_yes.ya-partner_ads_inner-up-down .ya-partner__list, .ya-partner_fixed_yes.ya-partner_ads-up-down .ya-partner__list':
        {
            margin: '12px 0',
            padding: '3px 0'
        },

        '.ya-partner__overflow-hide-urls .ya-partner__list .ya-partner__url': {
            display: 'none'
        },

        '.ya-partner__overflow-hide-urls .ya-partner__text .ya-partner__agewarn-cont': {
            display: 'inline-block',
            'padding-left': 0
        },

        '.ya-partner_fixed-yes .ya-partner__text .ya-partner__agewarn-displacer, .ya-partner_fixed-yes .ya-partner__sitelinks .ya-partner__agewarn-displacer': {
            'display': 'none'
        },

        '.ya-partner_fixed-yes.ya-partner__overflow-hide-all-sitelknks.ya-partner__overflow-hide-urls .ya-partner__text .ya-partner__agewarn-displacer, .ya-partner_fixed-yes.ya-partner__overflow-hide-urls .ya-partner__sitelinks .ya-partner__agewarn-displacer':
        {
            'display': 'inline-block'
        },

        // sitelinks paddings in px
        '.ya-partner_fixed_yes .ya-partner__sitelinks': {
            padding: '0 0 1px',
            'margin-top': '-1px'
        },
        '.ya-partner_fixed_yes .ya-partner__sitelink': {
            padding: '1px 0',
            'font-size': '12px'
        },
        '.ya-partner_fixed_yes .ya-partner__sitelinks-inline-delim': {
            padding: '0 9px'
        },
        'body .ya-partner__overflow-hide-sitelink-1 yatag.ya-partner__sitelink-1': {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-sitelink-2 yatag.ya-partner__sitelink-2': {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-sitelink-3 yatag.ya-partner__sitelink-3': {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-all-sitelinks yatag.ya-partner__sitelinks':
        {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-sitelink-2.ya-partner__overflow-hide-sitelink-3 yatag.ya-partner__sitelink-1 .ya-partner__sitelinks-inline-delim': {
            display: 'none'
        },
        'body .ya-partner__overflow-hide-sitelink-3 yatag.ya-partner__sitelink-2 .ya-partner__sitelinks-inline-delim': {
            display: 'none'
        },

        // like 728x90 & 1000x120
        '.ya-partner_fixed_yes.ya-partner_type_flat .ya-partner__text': {
            'padding-right': '10px'
        },
        '.ya-partner_fixed_yes.ya-partner_type_flat .ya-partner__sitelinks': {
            padding: '2px 0 0'
        },
        '.ya-partner_fixed_yes.ya-partner_type_horiz .ya-partner__sitelinks': {
            'padding-top': '3px'
        },
        'body .ya-partner_fixed_yes.ya-partner_type_flat .ya-partner__sitelink':
        {
            'padding-left': '0'
        }
    }
};

Ya.Context.Direct.VertFixed = util.augment(Ya.Context.Direct.Vertical, FixedBlock);

Ya.Context.Direct.FlatFixed = util.augment(Ya.Context.Direct.Flat, FixedBlock);
Ya.Context.Direct.FlatFixed.prototype.setupRemoveOverflow = function () {
    this._removeOverflow();
    // _adjustItemIndents не нужен, иначе объявление залезает на лого
};

Ya.Context.Direct['160x600'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_160x600',

    css: {
        '.ya-partner_type_160x600': {
            width: '160px',
            height: '600px'
        },

        ':root body .ya-partner_type_160x600': {  // IE9 reset
            width: '160px',
            display: BLOCK
        },
        ':root body .ya-partner_type_160x600.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_160x600 a.ya-partner__title-link:link,.ya-partner_type_160x600 a.ya-partner__title-link:visited,.ya-partner_type_160x600 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_160x600 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_160x600 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_160x600 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        }
    },

    cssIe: {
        'body .ya-partner_type_160x600': {
            width: '160px',
            display: BLOCK
        }
    }

});

Ya.Context.Direct['240x400'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_240x400',

    css: {
        '.ya-partner_type_240x400': {
            width: '240px',
            height: '400px'
        },

        ':root body .ya-partner_type_240x400': {  // IE9 reset
            width: '240px',
            display: BLOCK
        },
        ':root body .ya-partner_type_240x400.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_240x400 a.ya-partner__title-link:link,.ya-partner_type_240x400 a.ya-partner__title-link:visited,.ya-partner_type_240x400 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_240x400 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_240x400 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_240x400 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_240x400 .ya-partner__item': {
            padding: '5px 7px'
        }
    },

    cssIe: {
        'body .ya-partner_type_240x400': {
            width: '240px',
            display: BLOCK
        }
    }
});

Ya.Context.Direct['200x300'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_200x300',
    css: {
        '.ya-partner_type_200x300': {
            width: '200px',
            height: '300px'
        },

        ':root body .ya-partner_type_200x300': {  // IE9 reset
            width: '200px',
            display: BLOCK
        },
        ':root body .ya-partner_type_200x300.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_200x300 a.ya-partner__title-link:link,.ya-partner_type_200x300 a.ya-partner__title-link:visited,.ya-partner_type_200x300 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_200x300 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_200x300 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_200x300 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        }
    },

    cssIe: {
        'body .ya-partner_type_200x300': {
            width: '200px',
            display: BLOCK
        }
    }
});


Ya.Context.Direct['300x300'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_300x300',
    css: {
        '.ya-partner_type_300x300': {
            width: '300px',
            height: '300px'
        },

        ':root body .ya-partner_type_300x300': {  // IE9 reset
            width: '300px',
            display: BLOCK
        },
        ':root body .ya-partner_type_300x300.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_300x300 a.ya-partner__title-link:link,.ya-partner_type_300x300 a.ya-partner__title-link:visited,.ya-partner_type_300x300 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_300x300 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_300x300 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_300x300 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        }
    },

    cssIe: {
        'body .ya-partner_type_300x300': {
            width: '300px',
            display: BLOCK
        }
    }
});
Ya.Context.Direct['300x250'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_300x250',
    css: {
        '.ya-partner_type_300x250': {
            width: '300px',
            height: '250px'
        },

        ':root body .ya-partner_type_300x250': {  // IE9 reset
            width: '300px',
            display: BLOCK
        },
        ':root body .ya-partner_type_300x250.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_300x250 a.ya-partner__title-link:link,.ya-partner_type_300x250 a.ya-partner__title-link:visited,.ya-partner_type_300x250 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_300x250 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0 0'
        },

        '.ya-partner_type_300x250 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_300x250 .ya-partner__list .ya-partner__item': {
            padding: '7px 7px 3px 7px'
        },

        '.ya-partner_type_300x250 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        }
    },

    cssIe: {
        'body .ya-partner_type_300x250': {
            width: '300px',
            display: BLOCK
        }
    }
});
Ya.Context.Direct['250x250'] = util.augment(Ya.Context.Direct.VertFixed, {
    classes: 'ya-partner_type_250x250',
    css: {
        '.ya-partner_type_250x250': {
            width: '250px',
            height: '250px'
        },

        ':root body .ya-partner_type_250x250': {  // IE9 reset
            width: '250px',
            display: BLOCK
        },
        ':root body .ya-partner_type_250x250.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_250x250 a.ya-partner__title-link:link,.ya-partner_type_250x250 a.ya-partner__title-link:visited,.ya-partner_type_250x250 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_250x250 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '5px 0px 3px'
        },

        '.ya-partner_type_250x250 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_250x250 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        }
    },

    cssIe: {
        'body .ya-partner_type_250x250': {
            width: '250px',
            display: BLOCK
        }
    }
});
Ya.Context.Direct['728x90'] = util.augment(Ya.Context.Direct.FlatFixed, {
    classes: 'ya-partner_type_728x90',
    css: {
        '.ya-partner_type_728x90': {
            width: '728px',
            height: '90px'
        },

        ':root body .ya-partner_type_728x90': {  // IE9 reset
            width: '728px',
            display: BLOCK
        },
        ':root body .ya-partner_type_728x90.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_728x90 yatag.ya-partner__item': {
            padding: '0 3px',
            'margin-top': '4px',
            'margin-bottom': '4px'
        },

        '.ya-partner_type_728x90 td.ya-partner__item': {
            padding: '0 3px'
        },

        '.ya-partner_type_728x90 .ya-partner__item_pic_yes': {
            margin: 0
        },

        '.ya-partner_type_728x90 .ya-partner__item_pic_yes .ya-partner__pic-container': {
            margin: '4px 4px 0 0'
        },

        '.ya-partner_type_728x90 a.ya-partner__title-link:link,.ya-partner_type_728x90 a.ya-partner__title-link:visited,.ya-partner_type_728x90 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_728x90 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '0 0 3px'
        },

        '.ya-partner_type_728x90 .ya-partner__warn': {
            'font-size': '8.4px'
        },

        '.ya-partner_type_728x90xIMG .ya-partner__warn': {
            display: BLOCK
        },

        '.ya-partner_type_728x90 .ya-partner__url': {
            'font-size': '11px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_728x90xIMG td.ya-partner__item': {
            'vertical-align': 'middle'
        },

        '.ya-partner_type_728x90 .ya-partner__ads': {
            left: 'auto',
            right: 0
        },
        'yatag.ya-partner_type_728x90xIMG table.ya-partner__list': {
            'padding-bottom': 0,
            'margin-bottom': 0
        },
        'yatag.ya-partner_type_728x90xIMG.ya-partner_fixed_yes.ya-partner_ads-down .ya-partner__list':
        {
            'padding-bottom': '4px'
        },
        '.ya-partner_type_728x90 .ya-partner__ads .ya-partner__ads-l': {
            'border-radius': 0,
            '-moz-border-radius': 0,
            '-webkit-border-radius': 0
        }
    },
    cssIe: {
        'body .ya-partner_type_728x90': {
            width: '728px' ,
            display: BLOCK
        },
        '* html .ya-partner_type_728x90 .ya-partner__text' :{
            'margin-top': '2.4px'
        },
        '.ya-partner_type_728x90 .ya-partner__text' :{
            'margin-top': '3px'
        }
    }
});
Ya.Context.Direct['1000x120'] = util.augment(Ya.Context.Direct.FlatFixed, {
    classes: 'ya-partner_type_1000x120',
    css: {
        '.ya-partner_type_1000x120': {
            width: '1000px',
            height: '120px'
        },

        ':root body .ya-partner_type_1000x120': {  // IE9 reset
            width: '1000px',
            display: BLOCK
        },
        ':root body .ya-partner_type_1000x120.ya-partner_border.ya-partner_ads-down .ya-partner__ads': {  // IE9 reset
            bottom: 0
        },

        '.ya-partner_type_1000x120 yatag.ya-partner__item,.ya-partner_type_1000x120 td.ya-partner__item': {
            padding: '0 3px',
            'margin-top': '4px',
            'margin-bottom': '4px'
        },

        '.ya-partner_type_1000x120 .ya-partner__item_pic_yes': {
            margin: 0
        },

        '.ya-partner_type_1000x120 .ya-partner__item_pic_yes .ya-partner__pic-container': {
            margin: '4px 4px 0 0'
        },

        '.ya-partner_type_1000x120 a.ya-partner__title-link:link,.ya-partner_type_1000x120 a.ya-partner__title-link:visited,.ya-partner_type_1000x120 a.ya-partner__title-link:hover': {
            'font-size': '15px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_1000x120 .ya-partner__text': {
            'font-size': '12px',
            'font-weight': NORMAL,
            margin: '0 0 3px'
        },

        '.ya-partner_type_1000x120 .ya-partner__warn': {
            'font-size': '8.4px',
            'margin-top': '0.3em'
        },

        '.ya-partner_type_1000x120xIMG .ya-partner__warn': {
            display: BLOCK
        },

        '.ya-partner_type_1000x120 .ya-partner__url': {
            'font-size': '13px',
            'font-weight': NORMAL
        },

        '.ya-partner_type_1000x120xIMG td.ya-partner__item': {
            'vertical-align': 'top',
            'padding': '3px'
        },

        '.ya-partner_type_1000x120 .ya-partner__ads': {
            left: 'auto',
            right: 0
        },
        'yatag.ya-partner_type_1000x120xIMG table.ya-partner__list': {
            'padding-bottom': 0,
            'margin-bottom': 0
        },
        'yatag.ya-partner_type_1000x120xIMG.ya-partner_fixed_yes.ya-partner_ads-down .ya-partner__list':
        {
            'padding-bottom': '10px'
        },
        '.ya-partner_type_1000x120 .ya-partner__ads .ya-partner__ads-l': {
            'border-radius': 0,
            '-moz-border-radius': 0,
            '-webkit-border-radius': 0
        }
    },
    cssIe: {
        'body .ya-partner_type_1000x120': {
            width: '1000px' ,
            display: BLOCK
        },
        '* html .ya-partner_type_1000x120 .ya-partner__text' :{
            'margin-top': '2.4px'
        },
        '.ya-partner_type_1000x120 .ya-partner__text' :{
            'margin-top': '3px'
        }
    }
});
;
    (function () {
    var CENTERING_HTML_TMPL = '<yatag style="display:block;text-align:center;">' +
            '<yatag style="display:block;text-align:left;width:${width}px;margin:0 auto;">${html}</yatag>' +
        '</yatag>';

    Ya.Context.Direct['100%x90'] = createElasticBlockClass(Ya.Context.Direct['728x90'], 728);
    Ya.Context.Direct['100%x120'] = createElasticBlockClass(Ya.Context.Direct['1000x120'], 1000);

    function createElasticBlockClass (superClass, width) {
        return util.augment(superClass, {
            insertHtml: function (html) {
                html = util.format(CENTERING_HTML_TMPL, {
                    width: width,
                    html: html
                });
                return superClass.prototype.insertHtml.call(this, html);
            }
        });
    }
})();
;
    util.ns('Ya.Context.Market');

// блоки маркета, наследуются от вертикального
Ya.Context.Market.Vertical = util.augment(
    Ya.Context.Direct.Vertical, {}
);

// блоки маркета, наследуются от горизонтального
Ya.Context.Market.Horizontal = util.augment(
    Ya.Context.Direct.Horizontal, {}
);;
    var RtbBlock;
(function () {
    var IFRAME_TMPL = '<!DOCTYPE html>' +
        '<html><head><meta charset="utf-8"></head><body style="text-align:center;">' +
        '<script type="text/javascript">' +
        'window.Ya = {externalParams: parent.${jsDataPath} };' +
        '<\u002fscript>' +
        '${html}' +
        // For Opera
        '<script type="text/javascript">' +
        'document.close();' +
        '<\u002fscript>' +
        '</body></html>';

    var IFRAME_TAG_TMPL = '<iframe id="${id}" width="${width}" height="${height}"' +
        ' scrolling="no" marginwidth="0" marginheight="0" frameborder="0" vspace="0" hspace="0"></iframe>';

    // Хранилище для прокидывания данных внутрь iframe.
    Ya.Context._rtb_storage = {};

    /**
     * Класс для отрисовки rtb блока.
     * @class
     * @param {RtbDataSource} dataSource
     * @param {String} renderTo
     * @param {String} blockId
     * @param {Object} [externalParams]
     */
    RtbBlock = function (dataSource, renderTo, blockId, externalParams) {
        this.dataSource = dataSource;
        this.renderTo = renderTo;
        this.blockId = blockId;

        if (externalParams) {
            // PCODE-393. Временно логируем, чтоб понять гед и как ими пользуются.
            env.remoteLog('INFO: externalParams used');
        }
        this.externalParams = externalParams;

        var settings = this.dataSource.getSettings();

        // Имя/тип блока.
        this._name = settings.name;

        // Ширина блока.
        this._width = settings.width;

        // Высота блока.
        this._height = settings.height;

        // Показывать, только после подтверждения видимости.
        this._displayDelayed = settings.displayDelayed;

        /// this._containerChecker;
        /// this._visibilityChecker;
        /// this._container;
    };

    RtbBlock.prototype = {
        /**
         * Отрисовать rtb блок. Вызывается из RtbManager.
         */
        render: function () {
            // do we have target to render into?
            var container = dom('#' + this.renderTo);
            if (!container) {
                return;
            }

            // id нужен для инструментов автоматизации по поиску объявлений на странице, нам в коде не нужен.
            var iframeHTML = util.format(
                IFRAME_TAG_TMPL,
                {
                    id: 'ya_partner_' + this.blockId,
                    width: this._width,
                    height: this._height
                }
            );
            // <iframe> задаёт размеры контейнеру, поэтому вставляем его до проверки блока на видимость
            container.innerHTML = iframeHTML;
            this._container = container;

            // shall we wait until block is in viewport or render immediately
            if (this._displayDelayed) {
                this._createContainerChecker(container, this._render, this);
            } else {
                this._render(container);
            }
        },

        /**
         * Рисуем баннер в ифрейме.
         * @param {HTMLElement} container Элемент, в котором рендерится iframe.
         */
        _render: function (container) {
            var extStorageName = util.genRnd();
            Ya.Context._rtb_storage[extStorageName] = this.externalParams;
            var src = util.format(
                IFRAME_TMPL,
                {
                    jsDataPath: 'Ya.Context._rtb_storage[' + extStorageName + ']',
                    html: this.dataSource.getHtml()
                }
            );

            // If you'll use document.write
            // IE will evaluate inline scripts earlier than will load <script src="...">,
            // so logic will be broken
            var iframe = container.getElementsByTagName('iframe')[0];
            iframe.contentWindow.name = src;
            iframe.contentWindow.location.replace('javascript:this.name');

            this._createVisibilityChecker(iframe);
        },

        /**
         * Выполняет коллбэк при первом попадании любой части контейнера
         * в видимую область экрана.
         * @param {HTMLElement} container
         * @param {Function} callback
         */
        _createContainerChecker: function (container, callback, scope) {
            this._containerChecker = new VisibilityChecker();

            this._containerChecker.on('visible', function () {
                env.log('RTB container visible', this._name, this.blockId);
                callback.call(scope, container);
            }, this, {once:true});

            // listen
            this._containerChecker.listen(container);
        },

        _createVisibilityChecker: function (iframeNode) {
            this._visibilityChecker = new VisibilityChecker({
                confirmDelay: Ya.Const.Limits.visibCheckDelay,
                visiblePortion: 0.5
            });

            this._visibilityChecker.on('confirmed', function () {
                this.dataSource.onConfirmVisibility();

                env.log(
                    'confirmVisibility: rtb',
                    this._name, this.blockId
                );
            }, this);

            // listen
            this._visibilityChecker.listen(iframeNode);
        },

        /**
         * Уничтожить rtb блок. Вызывается из RtbManager.
         */
        destructor: function () {
            clearTimeout(this._renderIframeTimeoutRef);

            if (this._containerChecker) {
                this._containerChecker.clear();
            }

            if (this._visibilityChecker) {
                this._visibilityChecker.clear();
            }

            if (this._container) {
                this._container.innerHTML = '';
            }
        }
    };
})();
;

    // ujin@
// http://wiki.yandex-team.ru/jandekskontekst/partnercode/dela/YaConfigureProposal
// Интерфейс для проброса параметров, управляющих поведением КК, _до_ отработки основной показывательной логики.
// customConfig -- одноуровневый хэш с кастомными параметрами поведения
Ya.Context.configure = function (customConfig) {

    // мержим кастомные опции и включаем дополнительные фичи
    var cc = util.extend(Ya.Const.config, customConfig);

    // 'autoRenderStripeBlock' -- false выключает автоматический вывод полоски 
    // и включает ручку для принудительной попытки вывода полоски
    Ya.HeadStripe.autoRender = !!cc.autoRenderStripeBlock;
    if (!cc.autoRenderStripeBlock) {
        Ya.Context.renderStripeBlock = function (onRenderAttempt) {
            Ya.HeadStripe.renderBlock(onRenderAttempt);
        }
    } else {
        delete Ya.Context.renderStripeBlock;
    }

};
;
    
})(this, this.document);
// инициализируем pcode
Ya.Context._init();