package restapi;

use strict;
use nginx;
use JSON::PP;

my %JAVA_SUPPORTED_FIELDS = map {$_ => 1} qw(
  name
  midname
  lastname
  email
  phone
  newsletter
  no_stat_monitoring_emails
  has_mobile_mediation
  has_rsya
  next_currency
  currency_rate
  );

sub handler {
    my $r   = shift;
    my $uri = $r->uri;
    unless ($r->has_request_body(\&patch)) {
        $uri =~ s/^\/jsonapi/\/perl\/jsonapi/;
        $r->internal_redirect($uri);
    }
}

sub patch {
    my $r = shift;

    # может же быть невалидный json
    my $java_redirect = eval {
        # есть ситуации, когда body в файле
        # зависит от параметра client_body_buffer_size по умолчанию 16К или 8К в зависимости от разрядности ОС
        # в текущей ситуации такого размера не достгнем
        # Документация: https://nginx.org/ru/docs/http/ngx_http_perl_module.html
        my $request_body = $r->request_body;

        my $body_object = decode_json($request_body);

        foreach (keys(%{$body_object->{data}->{attributes}})) {
            unless ($JAVA_SUPPORTED_FIELDS{$_}) {
                return 0;
            }
        }

        return 1;
    };

    my $uri = $r->uri;
    if ($java_redirect) {
        $uri =~ s/^\/jsonapi/\/java\/jsonapi/;
    } else {
        $uri =~ s/^\/jsonapi/\/perl\/jsonapi/;
    }

    $r->internal_redirect($uri);
}

1;
