#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use IO::Socket::INET;

# global vars

# subs

# main
sub main {

    my $check = $ARGV[0];

    my $checks = {
        balance => {host => 'balance-xmlrpc.yandex.net', port => 8002},
        bk      => {host => 'bssoap.yandex.ru',          port => 80},
    };

    if ($checks->{$check}) {
        my $socket = IO::Socket::INET->new(
            PeerAddr => $checks->{$check}->{'host'},
            PeerPort => $checks->{$check}->{'port'},
            Proto    => 'tcp',
            Timeout  => 2,
        );

        if ($socket) {
            print "0;OK\n";
        } else {
            print "2;Can't connect to Host: $checks->{$check}->{'host'} Port: $checks->{$check}->{'port'}\n";
        }

    } else {
        $check //= '';
        print "2;Incorrect argument '$check'\n";
    }

}
main();
__END__
