#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Getopt::Long;
use Carp;

use Protocol::Rosetta::Client;
use Protocol::Rosetta::Request;

# global vars

# subs

# main
sub main {

    my %opts = ();
    GetOptions(\%opts, 'ip=s', 'port=i', 'help',) or croak "Error in command line arguments\n";

    if ($opts{help} or !$opts{ip} or !$opts{port}) {
        print "$0 --ip=141.8.173.106 --port=18066\n";
        exit 1;
    }

    my $answer;

    eval {

        my $client = Protocol::Rosetta::Client->new(
            ip   => $opts{ip},
            port => $opts{port},
        );

        my $request = Protocol::Rosetta::Request->new(
            type => 'ping',
            args => ['ping'],
        );

        $answer = $client->send($request);

    };

    if ((ref($answer) eq 'HASH') and ($answer->{'result'} eq 'ok')) {
        print "0;OK\n";
    } else {
        print "2;Rosetta server is broken at $opts{ip}:$opts{port} : $answer->{'message'}\n";
    }

}
main();
__END__
