/**
 * lmd
 * =====
 *
 * Оборачивает модули
 *
 * **Опции**
 * * *String* **config** - Исходный конфиг. По умолчанию - `?.lmd.json`.
 * * *String* **modules** - Список модулей. По умолчанию - `['?.js']`.
 * * *String* **target** - Результирующий js. По умолчанию - `?.lmd.js`.
 *
 * **Пример**
 *
 * ```javascript
 * nodeConfig.addTech('./techs/lmd')
 * ```
 */
/* global process */
'use strict';

var stream = require('stream');
var lmd = require('lmd');
var vow = require('vow');

module.exports = require('enb/lib/build-flow').create()
    .name('lmd')
    .target('target', '?.lmd.js')
    .useSourceFilename('config', '?.lmd.json')
    .useSourceListFilenames('modules', ['?.js'])
    .builder(function (config) {
        var promise = vow.promise();

        var myStream = new stream.Writable();
        var output = '';

        myStream._write = function (chunk, encoding, done) {
            output += chunk;
            done();
        };

        var lmdModule = new lmd(config);

        lmdModule.pipe(myStream);

        lmdModule.on('end', function () {
            promise.fulfill(output);
        });

        lmdModule.log.pipe(process.stdout);

        return promise;
    })
    .createTech();
