describe('dropdown', function () {
    'use strict';

    before(function () {
        var json = {
            block: 'dropdown',
            content: [
                {
                    block: 'link',
                    mix: [{block: 'dropdown', elem: 'switcher'}],
                    mods: {pseudo: 'yes'},
                    url: 'http://www.yandex.ru/all',
                    content: 'ещё'
                },
                {
                    elem: 'popup',
                    js: {directions: 'bottom-left-center'},
                    mods: {'has-close': 'yes'},
                    content: 'I am a dropdown here!'
                }
            ]
        };

        $(BEMHTML.apply(json)).appendTo('body');
    });

    after(function () {
        BEM.DOM.destruct($('.dropdown'));
    });

    it('getPopup()', function () {
        var popup = $('.dropdown').bem('dropdown').getPopup();
        popup.domElem.hasClass('popup').must.be(true);
    });
});
