(function (BEM) {
    'use strict';
    /**
     * Элемент `action` — кнопка-переключатель с иконкой.
     * Переключается установкой/снятием модификатора _checked_yes.
     *
     * @param {Object}  [elemParams.action]         Параметры элемента action.
     * @param {String}  [elemParams.action.panel]   Имя панели с которой будет синхронизироваться состояние кнопки.
     * @param {Boolean} [elemParams.action.notice]  Нужно ли генерировать событие action-change при переключении кнопки.
     */
    BEM.DOM.decl('header2', {

        /**
         * Генерируется при переключении кнопки.
         *
         * @event header2#action-change
         * @param {Object}  data          Данные события.
         * @param {String}  data.type     Значение модификатора _type переключаемой кнопки.
         * @param {Boolean} data.checked  Выставлен ли модификатор _checked_yes.
         */

        /**
         * @private
         */
        onSetMod: {
            js: {
                inited: function() {
                    this.__base.apply(this, arguments);

                    this._panelActions = {};
                    var block = this;
                    this.elem('action').each(function() {
                        var elem = $(this),
                            panel = (block.elemParams(elem) || {}).panel;
                        if(panel) {
                            block._panelActions[panel] = elem;
                        }
                    });

                    if(!$.isEmptyObject(this._panelActions)) {
                        this.on('panel-switch', this._toggleActionOnPanelSwitch);
                    }
                }
            }
        },

        /**
         * @private
         */
        onElemSetMod: {
            action: {
                checked: function(elem, modName, modVal) {
                    var checked = modVal === 'yes';

                    elem.attr('aria-pressed', checked);

                    var params = this.elemParams(elem) || {};
                    if(params.panel) {
                        this.togglePanel(params.panel, checked);
                        elem.attr('aria-expanded', checked);
                    }
                    if(params.notice) {
                        this.trigger('action-change', {
                            type: this.getMod(elem, 'type'),
                            checked: checked
                        });
                    }
                }
            }
        },

        /**
         * @private
         */
        _toggleActionOnPanelSwitch: function(e, data) {
            var closing = this._panelActions[data.closing];
            if(closing) {
                this.delMod(closing, 'checked');
            }
            var opening = this._panelActions[data.opening];
            if(opening) {
                this.setMod(opening, 'checked', 'yes');
            }
        },

        /**
         * @private
         */
        _onActionMouseDown: function(e) {
            var elem = e.data.domElem;
            this.setMod(elem, 'pressed', 'yes');

            function onRelease() {
                this.afterCurrentEvent(function() {
                    this.delMod(elem, 'pressed');
                });

                this.unbindFrom(elem, 'mouseleave');
                this.unbindFromDoc('mouseup touchend');
            }

            this.bindTo(elem, 'mouseleave', onRelease);
            this.bindToDoc('mouseup touchend', onRelease);
        },

        /**
         * @private
         */
        _onActionClick: function(e) {
            this.toggleMod(e.data.domElem, 'checked', 'yes', '');
        },

        /**
         * @private
         */
        _onMouseOverMouseOut: function(e) {
            this.toggleMod(e.data.domElem, 'hovered', 'yes', '', e.type === 'mouseover');
        },

        /**
         * @private
         */
        _onFocusInFocusOut: function(e) {
            this.toggleMod(e.data.domElem, 'focused', 'yes', '', e.type === 'focusin');
        }

    }, {

        live: function() {
            this.__base.apply(this, arguments);

            this.liveBindTo('action', 'leftclick tap', function(e) {
                    this._onActionClick(e);
                })
                .liveBindTo('action', 'mousedown', function(e) {
                    this._onActionMouseDown(e);
                })
                .liveBindTo('action', 'mouseover mouseout', function(e) {
                    this._onMouseOverMouseOut(e);
                })
                .liveBindTo('action', 'focusin focusout', function(e) {
                    this._onFocusInFocusOut(e);
                });
        }

    });
})(BEM);
