describe('header2__action', function() {
    'use strict';
    var header2, panelAction, panelNoticeAction, noticeAction,
        bemjson = {
            block: 'header2',
            nav: [
                {
                    elem: 'action',
                    elemMods: {type: 'panel'},
                    js: {panel: 'first-panel'}
                },
                {
                    elem: 'action',
                    elemMods: {type: 'panelNotice'},
                    js: {panel: 'second-panel', notice: true}
                },
                {
                    elem: 'action',
                    elemMods: {type: 'notice'},
                    js: {notice: true}
                }
            ]
        };

    beforeEach(function() {
        header2 = buildHeader2(bemjson);
        panelAction = header2.elem('action', 'type', 'panel');
        panelNoticeAction = header2.elem('action', 'type', 'panelNotice');
        noticeAction = header2.elem('action', 'type', 'notice');
    });

    describe('#_checked', function() {
        it('должен устанавливать атрибут aria-pressed', function() {
            expect(panelAction.attr('aria-pressed')).toBe('false', 'не установлен');
            header2.setMod(panelAction, 'checked', 'yes');
            expect(panelAction.attr('aria-pressed')).toBe('true', 'установлен');
        });

        it('должен устанавливать атрибуты aria-haspopup и aria-expanded, если есть параметр panel', function() {
            expect(panelAction.attr('aria-haspopup')).toBe('true', 'установлен');
            expect(noticeAction.attr('aria-haspopup')).toBeUndefined('отсутствует');
            expect(panelAction.attr('aria-expanded')).toBe('false', 'не установлен');
            expect(noticeAction.attr('aria-expanded')).toBeUndefined('отсутствует');
            header2
                .setMod(panelAction, 'checked', 'yes')
                .setMod(noticeAction, 'checked', 'yes');
            expect(panelAction.attr('aria-expanded')).toBe('true', 'установлен');
            expect(noticeAction.attr('aria-expanded')).toBeUndefined('отсутствует');
        });

        it('должен генерировать событие action-change, если есть параметр notice', function() {
            var events = [];
            header2.on('action-change', function(e, data) {
                events.push(data);
            });
            header2
                .setMod(panelAction, 'checked', 'yes')
                .setMod(noticeAction, 'checked', 'yes')
                .delMod(panelAction, 'checked')
                .delMod(noticeAction, 'checked');
            expect(events).toEqual([
                {type: 'notice', checked: true},
                {type: 'notice', checked: false}
            ]);
        });

        it('должен управлять панелями, если есть параметр panel', function() {
            expect(header2.getOpenedPanel()).toBeNull('изначально панели закрыты');
            header2.setMod(panelAction, 'checked', 'yes');
            expect(header2.getOpenedPanel()).toBe('first-panel', 'открывает панель');
            header2.setMod(panelNoticeAction, 'checked', 'yes');
            expect(header2.getOpenedPanel()).toBe('second-panel', 'открывает другую панель');
            header2.delMod(panelNoticeAction, 'checked');
            expect(header2.getOpenedPanel()).toBeNull('закрывает панель');
            header2.setMod(noticeAction, 'checked', 'yes');
            expect(header2.getOpenedPanel()).toBeNull('не реагирует, если нет параметра panel');
        });

        it('должен реагировать на открытие панелей, если есть параметр panel', function() {
            expect(header2.getMod(panelAction, 'checked')).toBe('', 'изначально panelAction выкл.');
            header2.openPanel('first-panel');
            expect(header2.getMod(panelAction, 'checked')).toBe('yes', 'panelAction вкл.');
            header2.openPanel('second-panel');
            expect(header2.getMod(panelAction, 'checked')).toBe('', 'panelAction выкл.');
            expect(header2.getMod(panelNoticeAction, 'checked')).toBe('yes', 'panelNoticeAction вкл.');
            header2.closePanel();
            expect(header2.getMod(panelNoticeAction, 'checked')).toBe('', 'panelNoticeAction выкл.');
        });

        it('должен генерировать событие action-change если кнопка была переключена панелью', function() {
            header2.setMod(panelNoticeAction, 'checked', 'yes');
            var events = [];
            header2.on('action-change', function(e, data) {
                events.push(data);
            });
            header2.setMod(panelAction, 'checked', 'yes');
            expect(header2.getMod(panelNoticeAction, 'checked')).toBe('', 'panelNoticeAction выкл.');
            expect(events).toEqual([{type: 'panelNotice', checked: false}], 'событие сгенерировано');
        });
    });

    afterEach(function() {
        BEM.DOM.destruct(header2.domElem);
    });

    function buildHeader2(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem('header2');
    }
});
