(function (BEM) {
    'use strict';
    /**
     * Элемент `paranja` — темный фон появляющийся при открытии панелей.
     * Чтобы паранджа появлялась, панель должна зарегистрировать себя методом #bindParanjaToPanel(name).
     * Паранджа скрывается и закрывает панель при клике по ней и при скролле документа.
     */
    BEM.DOM.decl('header2', {
        /**
         * @private
         */
        onSetMod: {
            js: {
                inited: function() {
                    this.__base.apply(this, arguments);

                    this._paranjaPanels = {};
                    this.on('panel-switch', this._onParanjaPanelSwitch);
                }
            }
        },

        onElemSetMod: {
            paranja: {
                active: {
                    'yes': function() {
                        this.bindToWin('scroll', function() {
                            this.closePanel();
                        });
                    },
                    '': function() {
                        this.unbindFromWin('scroll');
                    }
                }
            }
        },

        /**
         * Показывать паранджу для указанной панели.
         *
         * @public
         * @param {String} name Имя панели по раскрытию которой будет показываться паранджа.
         * @returns {BEM.DOM} this
         */
        bindParanjaToPanel: function(name) {
            this._paranjaPanels[name] = true;
            return this;
        },

        /**
         * @private
         */
        _onParanjaClick: function() {
            this.closePanel();
        },

        /**
         * @private
         */
        _onParanjaPanelSwitch: function(e, data) {
            var showParanja = !this._paranjaPanels[data.closing],
                hideParanja = !this._paranjaPanels[data.opening];
            if(showParanja !== hideParanja) {
                this._toggleParanja(showParanja);
            }
        },

        /**
         * Как показывать паранджу.
         * Можно переопределить на уровне сервиса чтобы показывать собственную паранджу.
         *
         * @param {Boolean} isActive Новое состояние паранджи
         * @protected
         */
        _toggleParanja: function(isActive) {
            this.toggleMod(this.elem('paranja'), 'active', 'yes', '', isActive);
        }

    }, {

        live: function() {
            this.__base.apply(this, arguments);

            this.liveBindTo('paranja', 'leftclick tap', function() {
                this._onParanjaClick();
            });
        }

    });
})(BEM);
