describe('header2__paranja', function() {
    'use strict';
    var header2,
        paranja,
        bemjson = {
            block: 'header2',
            under: [{
                elem: 'paranja'
            }]
        };

    beforeEach(function() {
        header2 = buildHeader2(bemjson);
        paranja = header2.elem('paranja');
    });

    describe('#_active', function() {
        beforeEach(function() {
            spyOn(header2, 'closePanel');
        });

        it('активная паранджа при скролле должна вызывать закрытие  панели', function() {
            header2.setMod(paranja, 'active', 'yes');
            $(window).scroll();
            expect(header2.closePanel.calls.count()).toEqual(1, 'активная');

            header2.delMod(paranja, 'active');
            $(window).scroll();
            expect(header2.closePanel.calls.count()).toEqual(1, 'не активная');
        });
    });

    describe('#static', function() {
        beforeEach(function() {
            spyOn(header2, 'closePanel');
        });

        it('по клику паранджа должна вызывать закрытие панели', function() {
            paranja.click();
            expect(header2.closePanel.calls.count()).toEqual(1);
        });
    });

    afterEach(function() {
        BEM.DOM.destruct(header2.domElem);
    });

    function buildHeader2(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem('header2');
    }
});
