(function (BEM) {
    'use strict';
    /**
     * Элемент `tableau` — табло сервисов.
     * Слушает события переключения панели с именем 'tableau'.
     */
    BEM.DOM.decl('header2', {

        /**
         * @private
         */
        onSetMod: {
            js: {
                inited: function() {
                    this.__base.apply(this, arguments);

                    this.bindParanjaToPanel('tableau');
                    this.on('panel-switch', this._onTableauPanelSwitch);
                }
            }
        },

        /**
         * @private
         */
        _onTableauPanelSwitch: function(e, data) {
            if(data.closing === 'tableau') {
                this.delMod(this.elem('tableau'), 'opened');
            } else if(data.opening === 'tableau') {
                this.setMod(this.elem('tableau'), 'opened', 'yes');
            }
        }

    });
})(BEM);
