describe('header2__tableau', function() {
    'use strict';
    var header2,
        tableau,
        bemjson = {
            block: 'header2',
            under: [
                {
                    elem: 'progress'
                },
                {
                    elem: 'tableau',
                    content: {
                        block: 'services-table',
                        mods: {type: 'ru'}
                    }
                },
                {
                    elem: 'paranja'
                }
            ]
        };

    beforeEach(function() {
        header2 = buildHeader2(bemjson);
        tableau = header2.elem('tableau');
    });

    describe('#API', function() {
        describe('openPanel()', function() {
            it('должен открывать табло', function() {
                header2.openPanel('tableau');
                expect(header2.hasMod(tableau, 'opened', 'yes')).toBe(true, 'табло открыто');
            });

            it('должен закрывать табло', function() {
                header2.closePanel('tableau');
                expect(header2.hasMod(tableau, 'opened')).toBe(false, 'табло закрыто');
            });
        });
    });

    afterEach(function() {
        BEM.DOM.destruct(header2.domElem);
    });

    function buildHeader2(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem('header2');
    }
});
