BEM.DOM.decl('example', {

    onSetMod: {
        js: {
            inited: function() {
                var header = this._header = this.findBlockInside('header2');
                this._progress = header.findBlockInside('progress');

                header.bindParanjaToPanel('panel-filter');

                header.on('panel-switch', this._onPanelSwitch('panel-filter'));
                header.on('panel-switch', this._onPanelSwitch('panel-settings'));

                this._content = this.findBlockInside('content');
            }
        }
    },

    _onPanelSwitch: function(name) {
        var header = this._header;
        return function(e, data) {
            var opening = data.opening === name,
                closing = data.closing === name;
            if(opening || closing) {
                header.toggleMod(header.elem(name), 'opened', 'yes', '', opening);
            }
        };
    },

    _animateProgress: function() {
        /*
         * Пример анимации:
         * __progress асимптотически приближается к 80% в теч. 1 секунды,
         * затем линейно растет до 100% в теч. 2с,
         * затем сбрасывается в 0
         */
        this._startProgress();
        setTimeout(function() {
            this._finishProgress();
        }.bind(this), 2000);

        return false;
    },

    _startProgress: function() {
        if(this._content) {
            this._content.setMod('loading', 'yes');
        }
        this._progress.update(0).update(0.8, 'asymptotic');
    },

    _finishProgress: function() {
        var progress = this._progress.update(1, 'linear'),
            content = this._content;

        setTimeout(function() {
            progress.update(0);
            if(content) {
                content.delMod('loading');
            }
        }, 210);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('init', 'header2');

        this.liveBindTo('submit', function() {
            this._animateProgress();
            return false;
        });
    }

});
