## Описание

Блок **header2** — шапка страницы, в «белом» дизайне (вторая версия). Предоставляет:
 
* [раскладку для группировки элементов управления](#structelems); 
* [ряд прикладных элементов](#addelems) (например, паранджу, индикатор загрузки, выдвигающуюся панель с «табло сервисов» и т. п.);
* [механизм для управления всплывающими панелями](#jsheader). 

Также содержит [инструкцию по миграции](#migration) с [header](../header/header.ru.md) – первая версия шапки.

Блок адаптирован для программ экранного доступа.


## Элементы блока

Делятся на две категории: [структурные](#structelems) и [прикладные](#addelems).

<a name="structelems"></a>
### Структурные элементы блока

Задают структуру шапки и являются контейнерами для блоков и 
других элементов.
К ним относятся: `main`, `logo`, `middle`, `websearch`, `left`, `right`, `nuv`, `under`.

Вложенность данных элементов наглядно показана на схеме:

```
header2
├── __main *
│     ├── __logo *
│     ├── __middle *
│     │     ├── __websearch
│     │     ├── __left
│     │     └── __right
│     └── __nav
└── __under
```

Звездочками отмечены обязательные элементы. 

* `main` – видимая часть шапки, которая служит контейнером для основного содержимого шапки.
 В элементе заданы размеры, оформление и расположение шапки. 

* `middle` – центральная область шапки, расположенная между элементами `logo` и `nav`. 

---
**NB** `main` и `middle` – по умолчанию добавляются в шаблоне блока (не требуют явного указания в BEMJSON). 

---

Остальные элементы появятся в результирующем HTML, только если указать во входном BEMJSON специализированные поля с такими же именами и добавить их в зависимости.

Подробное назначение этих элементов описано в [разделе про BEMJSON](#tbemjson).

<a name="addelems"></a>
### Прикладные элементы блока

Прикладные элементы выполняют определенные функции в шапке (данные элементы – необязательные): 

#### `action` кнопка-переключатель с иконкой  

Кнопку-переключатель можно связать с одной из панелей шапки. Также кнопка может
генерировать событие `action-change` на шапке при переключении. Переключается автоматической установкой/снятием модификатора `checked` в значение `yes`.  
  
JS-параметры элемента `action`, которые используются для идентификации панели, ассоциации с кнопкой и управлении панелями :

  - `{String} panel` – имя панели, с которой связано состояние кнопки.  
  Если этот параметр указан, кнопка подписывается на события `panel-switch` и вызывает метод `togglePanel()` при нажатии.
  
  - `{Boolean} notice` – признак, который определяет необходимость генерации события `action-change` при переключении кнопки.   
Если параметр задан и выставлен в значение `true`, то на шапке генерируется событие `action-change` со следующими параметрами:
    * `{Boolean} data.checked` — определяет включена или выключена кнопка; 
    * `{String} data.type` — значение модификатора `type` у кнопки (по нему можно установить какая именно кнопка была нажата).
  
JS-параметры кнопки могут использоваться как по отдельности, так и в связке. Подробнее можно почитать в JSDoc элемента.  

Для элемента реализован модификатор `type` – тип кнопки, который устанавливает иконку и всплывающую подсказку для кнопки. Он также идентифицирует кнопку с `js: {notice: true}`. Допустимые значения:  
  
  - `settings` – кнопка настроек;
  - `tableau` – кнопка, раскрывающая «табло сервисов»;
  - `filter` – кнопка расширенного поиска.

API кнопки может использоваться внешним, по отношению к шапке, блоком ([пример c выпадающей подсказкой](https://lego.yandex-team.ru/__example/islands-page/v3.1.2/desktop.sets/header2/header2.examples/20-mail/20-mail.ru.html)).

Например, чтобы сервису «Музыка» добавить кнопку «play/pause», следует сначала ее создать:

```js
...
{
    elem: 'action',
    elemMods: {type: 'playback'},
    js: {notice: true}
},
...
```

Затем, в JS-коде плеера, нужно найти шапку и подписаться на событие `action-change`:

```js
header.on('action-change', function(e, data) {
    if(data.type === 'playback') {
        if (data.checked) {
            // Запустить плеер
        } else {
            // Остановить плеер
        }
    }
});
```

#### `tableau` выезжающая панель c сервисами
Связана с одноименной виртуальной панелью. Слушает события переключения панели с именем `tableau`.
В качестве содержимого ожидает блок [services-table](../services-table/services-table.ru.md) – «табло сервисов». 

Пример кнопки-переключателя связанной с выезжающей панелью, которая содержит «табло сервисов»: 

```js
{
    block: 'header2',
    nav: [
        {
            elem: 'action', // кнопка раскрывающая «табло сервисов»
            elemMods: {type: 'tableau'},
            js: {panel: 'tableau'} // имя выезжающей панели, которая связана с кнопкой
        },
     ...   
    ]    
    under: [
        {
            elem: 'tableau', // выезжающая панель с сервисами
            content: {
                block: 'services-table', // блок «табло сервисов»
                mods: {type: 'ru'}
            }
        }
    ]
}       
```

---
**NB** Следует использовать с осторожностью, так как в первом мажорном релизе API шапки может измениться.

---

#### `paranja` паранджа
Темный полупрозрачный элемент, затемняющий содержимое страницы.
Паранджа исчезает при клике по ней или скролле страницы и закрывает ассоциированную панель.

Чтобы ассоциировать панель с паранджой, нужно на шапке вызвать метод `bindParanjaToPanel(name)`, где `name` – имя панели при раскрытии которой будет показываться паранджа. Подробнее можно почитать в JSDoc элемента.

#### `nameplate` шильдик-ссылка с именем сервиса
Ведет на главную страницу сервиса. У элемента есть BEMJSON-API:

  * `{String} name` — имя сервиса отображаемое на шильдике (необязательное поле);
  * `{String} url` — адрес главной страницы сервиса (необязательное поле);
  * `{String} service` — ключ сервиса.   
  
Если имя и адрес сервиса не указаны, то они будут взяты по ключу сервиса из блока [i-services](http://2-10.lego.yandex-team.ru/desktop/common/blocks/i-services). Блок `i-service` нужно добавить в зависимости.

```js
{
    block: 'header2',
    elem: 'nameplate', // шильдик с именем сервиса
    service: 'mail'
}
```

#### `progress` полоса прогресса загрузки
Распологается в нижней части шапки. 
Использует блок `progress`. Про API блока можно почитать в его [JSDoc](../progress/progress.js).

#### `gap` отступ
Стандартный отступ с шириной `20px` между соседними элементами управления в шапке. Можно использовать самостоятельно или примиксовывать к элементам управления, чтобы добавить отступ слева.

Пример использования прикладных элементов шапки:

```js
{
    block: 'header2',
    left: {
        elem: 'nameplate', // шильдик
        service: 'mail'
    },
    right: [
        {
            block: 'button',
            mods: {size: 'm', theme: 'action'},
            content: 'Написать'
        },
        {
            block: 'button',
            mix: {block: 'header2', elem: 'gap'}, // отступ между кнопками
            mods: {size: 'm'},
            content: 'Прочитать'
        }
    ],
    nav: [
        {
            elem: 'action', // кнопка расширенного поиска
            elemMods: {type: 'filter'},
            js: {notice: true} // генерируется событие action-change при переключении кнопки
        },
        {
            elem: 'action', // кнопка раскрывающая «табло сервисов»
            elemMods: {type: 'tableau'},
            js: {panel: 'tableau'} // имя выезжающей панели ассоциированной с кнопкой
        },
        { block: 'user', ...} // блок пользователя
    ],
    under: [
        { elem: 'progress' }, // полоса загрузки
        {
            elem: 'tableau', // выезжающая панель с сервисами
            content: {
                block: 'services-table',
                mods: {type: 'ru'}
            }
        }
        { elem: 'paranja' } // паранджа
    ]  
}
```

### Модификаторы блока

Все модификаторы необязательные. При использовании надо добавлять в зависимости.

#### `show-websearch` 
Реализует механизм отображения/скрытия поисковой стрелки. При установке значения модификатора в `yes` скрывает элементы `left` и `right` и разворачивает на их месте
элемент `websearch`. Анимация реализована с помощью CSS-transitions. 

#### `border`
Задает оформление нижней границы шапки. По умолчанию шапка отделена от основного содержимого страницы полупрозрачной однопиксельной линией.   
Допустимые значения:

* `transparent` – устанавливает фон шапки плавно переходящий в полупрозрачный и убирает нижнюю границу. Следует использовать совместно с модификатором `fixed` со значением `yes`;
* `white` – нижняя граница отсутствует.  
    
#### `fixed` 
Со значением `yes` задает фиксированное позиционирование шапки.

Пример использования модификаторов:

```js
{
    block: 'header2',
    mods: { 'show-websearch': 'yes', fixed: 'yes', border: 'transparent'},
    websearch: { block: 'search2-web' },
    ...
}    
```

### API блока

<a name="tbemjson"></a>
#### BEMJSON (входные данные) блока

Все поля входного BEMJSON блока – необязательные.

* `{Object|Array} left` — контейнер для элементов управления. Прижимается левым краем к логотипу. 
Содержимое передается в поле `content` элемента `left`.

* `{Object|Array} right` — контейнер для элементов управления. Прижимается правым краем к элементу `nav`. 
Содержимое передается в поле `content` элемента `right`.

* `{Object|Array} nav` — контейнер для элементов управления. Предназначен, в первую очередь, для общепортальных элементов управления, например, элементов `action` и блока `user`. [user](https://github.yandex-team.ru/lego/islands-user/blob/dev/common.blocks/user/user.ru.md). Прижимается к правому краю шапки.
Содержимое передается в поле `content` элемента `nav`.  

  В отличие от `right` и `left` не скрывается при отображении элемента `websearch`. 

* `{Object} websearch` — контейнер для поисковой стрелки. Изначально скрыт. При установке на блок модификатора
`show-websearch` в значение `yes` отображается вместо элементов `left` и `right`. Ожидает в качестве значения блок `search2-web`.
Содержимое передается в поле `content` элемента `websearch`.

```js
{
    block: 'header2',
    mods: { lang: 'ru', 'show-websearch': 'yes'},
    websearch: { block: 'search2-web' },
    nav:[...]
}
```     

* `{Object|Array} under` — контейнер для скрытых компонентов с абсолютным позиционированием: 
выпадающих панелей, паранджи, полосы загрузки и т.п. Может смещать основное содержимое страницы (под шапкой) или размещаться поверх него. 
Содержимое передается в поле `content` элемента `under`.

* `{Object} logo` — кастомный логотип. Используется в редких случаях, когда не подходит логотип Яндекса.
Значение по умолчанию `{elem: 'logo'}`.

---
**NB** При использовании полей `left`, `right`, `nav`, `websearch`, `under` нужно
добавить соответствующие элементы в зависимости.

---

<a name="jsheader"></a>
#### JS

Шапка предоставляет API для переключения виртуальных панелей. Панели идентифицируются строками.
Методы API позволяют узнать какая панель сейчас открыта, открыть/закрыть панель.
В каждый момент времени может быть открыта только одна панель. Если открывается вторая панель, первая – закроется.

При переключении панелей на шапке генерируется событие `panel-switch`, на которое могут реагировать элементы шапки или внешние блоки. 

Например, по открытию виртуальной панели `tableau` может раскрываться элемент `tableau`
и активироваться элемент `action`. 

Пример панели без паранджи — панель расширенного поиска (пока не реализованная). Она не выезжает поверх контента, а является частью поисковой выдачи, сдвигает основное содержимое страницы вниз. Является внешним по отношению к шапке блоком, но может подписываться на событие `panel-switch` и работать как остальные панели в шапке.

Подробнее методы и события шапки описаны в JSDoc блока.


### Варианты использования блока 

Минимальный BEMJSON блока:

```bemjson
{
    block: 'header2'
}
```
В этом случае, шапка будет содержать только логотип.

Развернутый пример:

```js
{
    block: 'header2',
    left: [
        {
            elem: 'nameplate', // шильдик с именем сервиса
            service: 'market'
        }
    ],
    nav: [
        {
            elem: 'action', // кнопка действия с иконкой
            elemMods: {type: 'tableau'}, // иконка и подпись определяются модификатором type
            js: {panel: 'tableau'} // кнопка управляет панелью с «табло сервисов»
        },
        {
            block: 'user',
            content: [
                {elem: 'icon'},
                {elem: 'name'}
            ]
        }
    ],
    under: [
        {
            elem: 'progress' // индикатор загрузки
        },
        {
            elem: 'tableau', // панель с «табло сервисов»
            content: {
                block: 'services-table',
                mods: {type: 'ru'}
            }
        }
    ]
}
```
<a name="migration"></a>
### Миграция с блока `header`

При переходе с предыдущей версии шапки – блок [header](../header/header.ru.md), обратите внимание, на отличия в раскладке, во входных данных и способе их задания, которые  подробно описаны в документации блоков. 

Сравнительная таблица элементов для блоков `header` и `header2`  

<table>
<tr><td><b>Элементы</b></td><td> <b>header</b></td><td><b>header2</b></td><td><b>Описание</b></td></tr>
<tr><td><b>main</b></td><td>+</td><td>+(-)</td><td>Основная видимая область шапки. В <b>header2</b> добавляется неявно.</td></tr>
<tr><td><b>logo</b></td><td>+</td><td>+</td><td><b>header</b>: левая часть шапки для размещения логотипа.
<br/> <b>header2</b>: кастомный логотип, содержит блок <b>logo</b>.</td></tr>

<tr><td><b>left</b></td><td>-</td><td>+</td><td>Левая часть шапки <b>header2</b>, прижимается к логотипу. </b></td></tr>
<tr><td><b>right</b></td><td>-</td><td>+</td><td>Правая часть <b>header2</b>, прижимается к элемкнту <b>nav</b>.</td></tr>
<tr><td><b>websearch</b></td><td>-</td><td>+</td><td>Контейнер для поисковой стрелки. Изначально скрыт. При установке блоку модификатора
<b>show-websearch_yes</b> отображается вместо элементов <b>left</b> и <b>right</b>. Ожидает в качестве значения блок <b>search2-web</b>.</td></tr>
<tr><td><b>search</b></td><td>+</td><td>-</td><td>Центральная часть <b>header</b> – поисковая, содержит блок <a href="../arrow/arrow.ru.md">arrow</a> .</td></tr>
<tr><td><b>nav</b></td><td>+</td><td>+</td><td>Контейнер для общепортальных элементов управления таких как элемент <b>action</b> и блок <b>user</b>.</td></tr>
<tr><td><b>under</b></td><td>+</td><td>+</td><td>Контейнер для скрытых компонентов шапки с абсолютным позиционированием: 
выпадающих панелей, паранджи, полосы загрузки и т.п.</td></tr>
<tr><td><b>action</b></b></td><td>+</td><td>+</td><td>Кнопка-переключатель. Тип задается модификатором <b>type</b>. Значения модификатора для шапок различаются.</td></tr>
<tr><td><b>gap</b></b></td><td>-</td><td>+</td><td>Отступ 20px.</td></tr>
<tr><td><b>progress</b></td><td>-</td><td>+</td><td>Полоса загрузки.</td></tr>
<tr><td><b>paranja</b></td><td>-</td><td>+</td><td>Паранджа.</td></tr>
<tr><td><b>nameplate</b></td><td>-</td><td>+</td><td>Имя сервиса.</td></tr>
</td><td><b>tableau</b></td><td>-</td><td>+</td><td>Панель с «табло сервисов». Ожидает в содержимом блок <b>service-table</b>.</td></tr>
</table>

В блоке `header` выезжающие панели c произвольным содержимым создаются при помощи блока [slide](../slide/slide.ru.md).








