describe('header2', function() {
    'use strict';
    var header2, events,
        bemjson = {
            block: 'header2'
        };

    beforeEach(function() {
        header2 = buildHeader2(bemjson);
        events = [];
        header2.on('panel-switch', function(e, data) {
            events.push(data);
        });
    });

    describe('#API', function() {
        describe('getOpenedPanel()', function() {
            it('изначально должен возвращать null', function() {
                expect(header2.getOpenedPanel()).toBeNull();
            });
        });

        describe('openPanel()', function() {
            it('должен открывать одну панель и закрывать другую', function() {
                header2.openPanel('first-panel');
                expect(header2.getOpenedPanel()).toBe('first-panel', 'первая панель открыта');
                header2.openPanel('second-panel');
                expect(header2.getOpenedPanel()).toBe('second-panel', 'вторая панель открыта');
                expect(events).toEqual([
                    {opening: 'first-panel', closing: null},
                    {opening: 'second-panel', closing: 'first-panel'}
                ], 'события panel-switch сгенерированы');
            });

            it('должен возвращать объект, на котором вызван', function() {
                expect(header2.openPanel('panel')).toBe(header2);
            });
        });

        describe('closePanel()', function() {
            it('должен закрывать все панели, если вызван без аргументов', function() {
                header2.openPanel('panel');
                expect(header2.getOpenedPanel()).toBe('panel', 'панель открыта');
                header2.closePanel();
                expect(header2.getOpenedPanel()).toBeNull('панель закрыта');
                expect(events).toEqual([
                    {opening: 'panel', closing: null},
                    {opening: null, closing: 'panel'}
                ], 'события panel-switch сгенерированы');
            });

            it('должен закрывать панель по имени', function() {
                header2.openPanel('panel');
                expect(header2.getOpenedPanel()).toBe('panel', 'панель открыта');
                header2.closePanel('another-panel');
                expect(header2.getOpenedPanel()).toBe('panel', 'панель ещё открыта');
                header2.closePanel('panel');
                expect(header2.getOpenedPanel()).toBeNull('панель закрыта');
                expect(events).toEqual([
                    {opening: 'panel', closing: null},
                    {opening: null, closing: 'panel'}
                ], 'события panel-switch сгенерированы');
            });

            it('должен возвращать объект, на котором вызван', function() {
                expect(header2.closePanel('panel')).toBe(header2);
            });
        });

        describe('togglePanel()', function() {
            it('должен открывать панель, если она закрыта и закрывать, если открыта', function() {
                header2.togglePanel('first-panel');
                expect(header2.getOpenedPanel()).toBe('first-panel', 'первая панель открыта');
                header2.togglePanel('second-panel');
                expect(header2.getOpenedPanel()).toBe('second-panel', 'вторая панель открыта');
                header2.togglePanel('second-panel');
                expect(header2.getOpenedPanel()).toBeNull('вторая панель закрыта');
                expect(events).toEqual([
                    {opening: 'first-panel', closing: null},
                    {opening: 'second-panel', closing: 'first-panel'},
                    {opening: null, closing: 'second-panel'}
                ], 'события panel-switch сгенерированы');
            });

            it('должен устанавливать состояние панели, если передан второй аргумент', function() {
                header2.togglePanel('first-panel', true);
                header2.togglePanel('second-panel', false);
                expect(header2.getOpenedPanel()).toBe('first-panel', 'первая панель открыта');
                header2.togglePanel('second-panel', true);
                header2.togglePanel('second-panel', true);
                expect(header2.getOpenedPanel()).toBe('second-panel', 'вторая панель открыта');
                header2.togglePanel('second-panel', false);
                expect(header2.getOpenedPanel()).toBeNull('вторая панель закрыта');
                expect(events).toEqual([
                    {opening: 'first-panel', closing: null},
                    {opening: 'second-panel', closing: 'first-panel'},
                    {opening: null, closing: 'second-panel'}
                ], 'события panel-switch сгенерированы');
            });

            it('должен возвращать объект, на котором вызван', function() {
                expect(header2.togglePanel('panel')).toBe(header2);
            });
        });
    });

    afterEach(function() {
        BEM.DOM.destruct(header2.domElem);
    });

    function buildHeader2(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem('header2');
    }
});
