## Описание
Блок `icon` – абстрактная иконка. Применяется для вставки декоративных изображений внутри других блоков.
В HTML представлен тегом `<i>` с фоновым изображением, заданным через `background-image`.

`icon` предназначен для зрячих пользователей, поэтому не должен быть доступен.
Доступность задается для родительского блока.

---
**NB** Самостоятельное использование блока `icon` для вставки изображения не рекомендуется, в отличие от блока `image`. 

---

## Техническое описание
### Варианты использования

Характеристики фонового изображения, ширина и высота иконки задаются с помощью CSS-свойств
`background-*`, `width` и `height` соответственно.

Способы задания параметров:

1. Добавить модификатор для блока `icon`;
2. Добавить модификатор или элемент для блока содержащего блок `icon`.

#### Добавление модификатора для `icon`

```js
{
    block: 'button',
    mods: {size: 'm'},
    content: [
        {
            block: 'icon',
            mods: {theme: 'serp'}
        },
        ' Иконка серпа'
    ]
}
```

Свойства иконки задаются в модификаторе блока `icon`:

```css
.icon_theme_serp
{
    width: 16px;
    height: 16px;
    background-position: -16px 0;
    background-image: url(image-sprite.png);
}
```

#### Добавление модификатора родительскому блоку

```js
{
    block: 'button',
    mods: {size: 'm', icon: 'comment'},
    content: [
        {
            block: 'icon'
        },
        ' Комментарий'
    ]
}
```

Свойства иконки задаются каскадом в модификаторе или элементе родительского блока:

```css
.button_icon_comment .icon
{
    width: 16px;
    background-image: url(icon-comment.png);
}
```
