## Описание

Блок `image` – абстрактная картинка. Создает контейнер для размещения изображения на веб-странице. Реализован посредством BEMHTML-шаблона, формирующего HTML-тэг `<img атрибуты>`.
<!--Позволяет размещать на странице векторные изображения с деградацией в растровые. -->

### Объявление блока на странице
BEMJSON для использования блока:

```js
{
    block: 'image'
}
```
По умолчанию блок без параметров выведет на веб-странице тэг `<img>` с однопиксельным прозрачным gif-файлом, путь к которому задан в атрибуте `src`, и пустым атрибутом `alt`.

### Атрибуты блока

`url`, `alt`, `width`, `height` – опциональные. Объявляются в одноименных полях входного BEMJSON блока.
В BEMHTML-шаблоне `url` преобразуется в атрибут `src`, остальные – в одноименные атрибуты тэга  `<img>` с соответствующими значениями.

### Варианты использования блока

В блоке путь к изображению задается двумя способами:

* [c помощью поля url](#iurl);
* [с помощью модификатора](#imod).

<a name="iurl"></a>
#### Задание изображения с помощью url

Этот способ рекомендуется для добавления одиночных изображений.

Путь к изображению указываем в поле `url` входного BEMJSON блока:

```js
{
    block: 'image',      // имя блока
    url: 'my-image.png', // путь к изображению
    alt: 'My image'      // альтернативный текст для изображения
}
```
Также изображению можно задать необходимую высоту и ширину.

<!-- %%image.examples/10-image/10-image%% -->

<a name="imod"></a>
#### Задание изображения с помощью добавления модификатора

Этот способ рекомендуется при использовании спрайтов.

Добавляем блоку модификатор в виде произвольной пары «ключ:значение», BEMJSON:

```js
{
    block: 'image',
    mods: {type: 'simple'}, // добавление нового модификатора
    alt: 'My image'
}
```
В CSS модификатора в стилевом свойстве `background: url(...)` задаем размеры изображения и путь к нему:

```css
.image_type_simple
{
    width: 16px;
    height: 16px;
    background: no-repeat -50px 0 url(image-sprite.png);
}
```

Этот способ подходит и для задания одиночных изображений:

```css
.image_type_simple
{
    background: no-repeat url(image-sprite.png);
}
```

###Значения по умолчанию

По умолчанию тэгу `<img>` добавляются атрибуты:

* `src`: '//yastatic.net/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif' (путь к прозрачному, однопиксельному gif-файлу);
* `alt`: пустая строка.
