(function() {
    'use strict';

    var DOM = BEM.DOM,

        KEYDOWN_EVENT = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown';

    DOM.decl({name: 'input', modName: 'suggest', modVal: 'yes'}, {

        /**
         * Ленивое получение попапа
         * @returns {BEM} блок попапа
         */
        _getPopup: function() {

            var _this = this;
            if (!_this._popup) {
                var block = _this.__self.getName(),
                    content = [{elem: 'items', tag: 'ul', mix: [{block: block, elem: 'popup-items'}]}],
                    popupMix = Array.isArray(_this.params.popupMixs) ? _this.params.popupMixs : [];

                _this._hasPopupFade() && content.push({block: block, elem: 'fade'});

                popupMix.push({
                    block: block,
                    elem: 'popup',
                    mods: _this.params.popupMods,
                    js: {uniqId: _this._uniqId}
                });

                _this._popup = $(BEMHTML.apply({
                    block: 'popup',
                    mods: {animate: 'no'},
                    mix: popupMix,
                    js: {
                        directions: 'bottom-left'
                    },
                    content: {
                        elem: 'content',
                        content: content
                    }
                })).bem('popup')
                    .on({
                        show: function() {
                            _this
                                .bindTo('keypress', _this._onKeyPress)
                                .bindTo(KEYDOWN_EVENT, _this._onKeyDown);
                        },
                        hide: function() {
                            _this
                                .unbindFrom('keypress ' + KEYDOWN_EVENT)
                                ._curItemIndex = -1;
                        }
                    });

                // при первом создании попапа подписываемся на live-события его элементов
                $.each({
                        mouseover: _this._onEnterItem,
                        mouseout: _this._onLeaveItem,
                        mousedown: _this._onSelectItem,
                        mouseup: _this._onItemMouseUp
                    }, function(e, fn) {
                        BEM.blocks['b-autocomplete-item'].on(_this._popup.domElem, e, function(e) {
                            fn.call(_this, e.block);
                        });
                    });

                DOM.init(_this._popup.domElem);
            }

            return _this._popup;

        },

        _onSelectItem: function(item, byKeyboard) {

            var selectResult = item.select(byKeyboard || false),
                needUpdate = (typeof selectResult == 'object') ?
                        selectResult.needUpdate : selectResult !== false,
                needEvent = (typeof selectResult == 'object') && selectResult.needEvent;

            this._preventRequest = true;

            if (needUpdate) {
                this._userVal = item.val();
                this.val(this._userVal, {source: 'autocomplete', itemIndex: this._curItemIndex});
            }

            if (byKeyboard) {
                this
                    .del('_preventRequest')
                    ._getPopup()
                    .hide();
            } else {
                // Возвращаем фокус обратно, чтобы popup не закрылся по mousedown
                // https://st.yandex-team.ru/ISLCOMPONENTS-768
                this._returnFocus = true;

                needUpdate || (this._preventHide = true);
                this.afterCurrentEvent(function() {
                    this
                        .setMod('focused', 'yes')
                        .del('_preventRequest', '_preventHide');
                });
            }

            (needUpdate || needEvent) && this.trigger('select', {item: item, byKeyboard: byKeyboard});

        },

        _onItemMouseUp: function() {
            this
                .del('_returnFocus')
                ._getPopup()
                .hide();
        }
    });
})();
