(function (BEM) {
    'use strict';

    var lodash = require('lodash');
    var extend = lodash.extend;

    BEM.DOM.decl('lang-switcher', {
        onSetMod: {
            js: function () {
                if (!this.params.tune) {
                    return false;
                }

                var _this = this;

                this.getPopup().domElem.on('click', '.lang-switcher__lang', function (e) {
                    return _this.switchLang(e, this);
                });
            }
        },

        /**
         * Кэширует и возвращает ссылку на попап.
         *
         * @return {BEM.DOM}
         */
        getPopup: function () {
            return this._popup ||
                (this._popup = this.findBlockOn('dropdown-menu').getPopup());
        },

        /**
         * Формирует ссылку, по которой сменится локаль пользователя.
         *
         * @param  {String} lang Язык, на который переключаем.
         * @return {String}
         */
        getUrl: function (lang) {
            var mda = $.cookie('mda');
            var tune = this.params.tune;

            if (mda === '0') {
                tune = extend({}, tune, {url : this.params.tuneWithoutMda});
            }

            var urlParams = {
                intl: lang,
                sk: tune.sk,
                retpath: window.location.toString()
            };

            var url = Object.keys(urlParams).map(function (key) {
                return key + '=' + encodeURIComponent(urlParams[key]);
            }).join('&');

            url = tune.url + '?' + url;

            return url;
        },

        /**
         * Отправляет пользователя на сервис tune.
         *
         * @param  {Event}      e DOM
         * @param  {DOMElement}   .lang-switcher__elem
         */
        switchLang: function (e, domElem) {
            var elem = $(domElem);

            var lang = this.findBlockInside(elem, 'country-flag').getMod('s16');
            lang === 'gb' && (lang = 'en');

            this.getPopup().hide();

            window.location = this.getUrl(lang);

            e.preventDefault();
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockEvent('init', 'dropdown-menu');
        }
    });
})(BEM);
