describe('lang-switcher', function () {
    'use strict';

    var tuneSk = 'u6asd';
    var tuneUrl = 'https://tune.yandex.ru/api/lang/v1.1/save.xml';

    before(function () {
        BEM.DOM.append('body', BEMHTML.apply({
            block: 'lang-switcher',
            lang: {code: 'ru', name: 'Ru'},
            noMore: true,
            js: {
                tune: {
                    sk: tuneSk,
                    url: tuneUrl
                }
            },
            content: [
                {
                    elem: 'lang',
                    lang: {code: 'en', name: 'En'}
                },
                {
                    elem: 'lang',
                    lang: {code: 'ru', name: 'Ru'},
                    mods: {selected: 'yes'}
                },
                {
                    elem: 'lang',
                    lang: {code: 'tr', name: 'Tr'}
                }
            ]
        }));
    });

    after(function () {
        BEM.DOM.destruct($('.lang-switcher'));
    });

    it('getUrl() формирует корректную ссылку', function () {
        var block = $('.lang-switcher').bem('lang-switcher');
        var url = tuneUrl + '?' + [
            'intl=en',
            'sk=' + tuneSk,
            'retpath=' + encodeURIComponent(location)
        ].join('&');

        block.getUrl('en').must.be(url);
    });
});
