/**
 * Псевдоссылка.
 * Модификация ссылки, подразумевающая действие без перехода на другую страницу.
 */
BEM.DOM.decl({'name': 'link', 'modName': 'pseudo', 'modVal': 'yes'}, {

    /**
     * @private
     */
    _onClick: function(e) {

        e.preventDefault();

        this.hasMod('disabled', 'yes') || this.afterCurrentEvent(function() {
            this.trigger('click');
        });

    },

    /**
     * @private
     */
    _onKeyUp: function(e) {

        if(e.shiftKey || e.ctrlKey || e.altKey) {
            return;
        }

        if(e.which === 13 || e.which === 32) { /* ENTER || SPACE */
            this.hasMod('disabled', 'yes') || this.afterCurrentEvent(function() {
                this.trigger('click');
            });
        }

    }
}, {

    live: function() {

        this.__base.apply(this, arguments);

        this.liveBindTo({modName: 'pseudo', modVal: 'yes'}, 'leftclick tap', function(e) {
            this._onClick(e);
        }).liveBindTo({modName: 'pseudo', modVal: 'yes'}, 'keyup', function(e) {
            this._onKeyUp(e);
        });

    }

});
