/**
 * Ссылка.
 */
BEM.DOM.decl('link', {
    getDefaultParams: function() {
        return {
            origTabindex: '0'
        };
    },

    /**
     * @private
     */
    onSetMod: {

        /**
         * Атрибуты `aria-disabled` и `tabindex` всех видов ссылок получают то же значение,
         * которое при переключении устанавливается модификатору `disabled`.
         */
        disabled: function(modName, modVal) {
            var disabled = modVal === 'yes';

            this.domElem.attr({
                'aria-disabled': disabled,
                'tabindex': disabled ? -1 : this.params.origTabindex
            });

        }

    }
});
