## Описание

Блок `link` предназначен для создания ссылок: простых, с иконками, со счетчиками, псевдо-ссылок.
Может использоваться в других блоках, например `input`.

---
**NB** Рекомендуется все ссылки делать с использованием блока `link`.

---

<a name="einner"></a>
### Элементы блока

`inner` – опциональный внутренний элемент, в который помещается текстовое содержимое ссылки. Необходим, когда ссылка содержит графический контент, например, иконку. В HTML преобразуется в тэг `<span>`.
Добавляется в BEMJSON блока [следующим образом](#addinner).

### Объявление блока на странице

BEMJSON для использования ссылки:

```js
{
    block: 'link'        // имя блока
    url: 'http://ya.ru', // адрес ресурса
    target: '_blink',    // имя окна/фрейма, в котором будет открыт документ, на который указывает ссылка
    title: 'Подсказка',  // всплывающая подсказка к тексту ссылки
    mods: {outer: 'yes', disabled: 'yes'}, // поле модификаторов ссылки. Необязательное
    content: 'Самая посещаемая страница Рунета' // текст ссылки
}
```
При наличии поля `url` на веб-странице отобразится ссылка вида `<a атрибуты> текст ссылки </a>`, при отсутствии – тэг `<span атрибуты> ... </span>`.

#### Атрибуты блока

`url`, `target`, `title`, `tabindex`, `id` – необязательные. Задаются в одноименных полях входного BEMJSON блока.

В BEMHTML-шаблоне поле `url` преобразуется в атрибут ссылки `href`, остальные – в соответствующие атрибуты тэга `<a>` с заданными значениями. По умолчанию тэгам `<a>` и `<span>` будет добавлен атрибут `tabindex=0`, если он не был явно задан во входных данных, а для `<span>` дополнительно и `role="button"`.

### Модификаторы блока
Ссылки бывают:

* **Простая ссылка**.

```js
{
   block: 'link',
   url: 'http://ya.ru',
   content: 'Самая посещаемая страница Рунета'
}
```

<!-- %%link.examples/10-link-simple/10-link-simple%% -->

<!-- %%link.examples/20-link-attributes/20-link-attributes%% -->

* **Сылка со счетчиком** (модификатор `counter` в значении `yes`).
Используется для подсчета кликов по ссылке в различных статистических данных. Вероятностью срабатывания счётчика для конкретной ссылки управляет атрибут `show-counter`. По умолчанию вероятность срабатывания счётчика — 10%.
При `show-counter` = 100 — показ счётчика гарантирован всегда.
`counter` и `showcounter` – передаются в качестве JS-параметров при инициализации блока.

```js
{
    block: 'link',
    mods: {counter: 'yes'},  // определяет ссылку со счетчиком
    url: 'http://ya.ru',
    counter: '123',          // значение счетчика
    'show-counter': '50',    // вероятность срабатывания счетчика (в половине случаев)
    content: 'Ссылка, у которой есть счётчик в половине случаев'
}
```

<!-- %%link.examples/30-link-counter-always/30-link-counter-always%% -->

* **Псевдо-ссылка** (модификатор `pseudo` в значении `yes`).
Разновидность ссылки, подразумевающая действие без перехода на другую страницу. Визуально имеет пунктирное нижнее подчеркивание.

  В HTML может быть представлена двумя способами:
    * При наличии атрибута `url` выводится `<a href=" " атрибуты>текст ссылки</a>`. При отключенном JS происходит переход по ссылке.
    * Без атрибута `url` выводится `<span атрибуты> ... </span>`.

```js
{
    block: 'link',
    mods: {pseudo: 'yes'}, // определеяет псевдо-ссылку спаном
    content: 'Псевдо-ссылка спаном'
}
```
<!-- %%link.examples/40-link-pseudo/40-link-pseudo%%  -->

* **Ссылка с вложенным элементом** (модификатор `inner` в значении `yes`).
В основном служит для использования ссылки с иконками. Наличие модификатора `_inner` позволяет добавлять во входных данных [элемент `inner`](#einner), разделяющий текст ссылки и иконку ссылки. Содержит только CSS, который переносит подчеркивание с самой ссылки на ее внутренний элемент(текст ссылки).
Это позволяет вкладывать в ссылку иконки любого размера.

<a name="addinner"></a>

```js
{
    block: 'link',
    mods: {inner: 'yes'}, // определяет ссылку с вложенным элементом
    url: '#',
    content: [
        { // добавление иконки с использованием блока `image`
            block: 'image',
            mix: [{block: 'link', elem: 'icon'}],
            url: '//yastatic.net/lego/_/q3pWfvEp2kyq8alkR67Ry863-14.png',
            alt: '16x16 icon'
        },
        { // добавление элемента `inner`, содержащего текст ссылки
            elem: 'inner',
            content: 'Ссылка с иконкой 16x16'
        }
    ]
}
```

<!-- %%link.examples/50-link-inner/50-link-inner%% -->

* **Внешняя ссылка** (модификатор `outer` в значении `yes`).
Служит для визуального выделения ссылок, ведущих на другие сайты. Содержит CSS со стилем, выделяющим ссылку цветом #070.

```js
{
    block: 'link',
    mods: {outer: 'yes'}, // определяет внешнюю ссылку
    url: 'http://ya.ru',
    content: 'Внешняя ссылка'
}
```

<!-- %%link.examples/15-link-simple-outer/15-link-simple-outer%% -->

* **Невизуальная ссылка** (модификатор `nonvisual` в значении `yes`).
Делает ссылку невидимой. Она появляется только при фокусировке на ней клавишей `Tab`.
В основном, модификация нужна для людей с ограниченными возможностями (поддержка accessibility). В данный момент используется только в шапке.

```js
{
    block: 'link',
    mods: {nonvisual: 'yes'},
    url: 'http://example.com',
    content: 'Невизуальная ссылка'
},
{
    block: 'link',
    mods: {pseudo: 'yes', nonvisual: 'yes'},
    url: 'http://example.com',
    content: 'Невизуальная псевдо-ссылка'
}
```

<!--%%link.examples/60-nonvisual/60-nonvisual%% -->

#### Состояния ссылки

При наличии модификатора `disabled` в значении `yes` любая ссылка или псевдо-ссылка становится **неактивной**, то есть будет недоступна для действий пользователя: фокусировка с помощью клавиши `Tab` и клик кнопкой мыши.
В HTML для тэгов `<a>` и `<span>` добавится атрибут `aria-disabled=true` (и только для ссылки `tabindex=-1`).
Визуально все неактивные ссылки выделяются светло-серым цветом (#ddd).

```js
{
    block: 'link',
    mods: {pseudo: 'yes', disabled: 'yes'},
    content: 'Неактивная псевдо-ссылка спаном'
},
{
    block: 'link',
    mods: {pseudo: 'yes', disabled: 'yes'},
    url: 'http://ya.ru',
    content: 'Неактивная псевдо-ссылка ссылкой'
}
```

### Значения по умолчанию

Оформление (цвет):
* ссылки и посещенной ссылки: #22c;
* внешней ссылки: #070;
* неактивной ссылки: #ddd.

Атрибуты активной ссылки: `tabindex=0` и для `<span>` дополнительно `role="button"`.
