describe('link', function() {

    var link,
        TABINDEX = '2';

    beforeEach(function() {
        link = build({block: 'link', content: 'Ссылка', url: 'http://ya.ru', tabindex: TABINDEX});
    });

    afterEach(function() {
        BEM.DOM.destruct(link.domElem);
    });

    describe('#initial', function() {
        it('должен устанавливать tabindex, согласно заданному в BEMJSON', function() {
            expect(link.domElem.attr('tabindex')).toBe(TABINDEX);
        });
        it('должен устанавливать tabindex = 0, если в BEMJSON не заданы параметр url и tabindex',
            function() {
                var link = build({block: 'link', content: 'Ссылка'});
                expect(link.domElem.attr('tabindex')).toBe('0');
                BEM.DOM.destruct(link.domElem);
            }
        );
        it('выставляется tabindex = -1, если в шаблоне установлен модификатор disabled', function() {
            var link = build({block: 'link', mods: {disabled: 'yes'}, content: 'Ссылка',
                url: 'http://ya.ru', tabindex: TABINDEX});
            expect(link.domElem.attr('tabindex')).toBe('-1', 'tabindex="-1"');
            expect(link.params.origTabindex).toBe(TABINDEX, 'params.origTabindex=2');
            BEM.DOM.destruct(link.domElem);
        });
    });

    describe('#_disabled', function() {
        beforeEach(function() {
            link.setMod('disabled', 'yes');
        });
        it('установка модификатора _disbled устанавливает tabindex = -1', function() {
            expect(link.domElem.attr('tabindex')).toBe('-1');
        });
        it('сброс модификатора _disbled устанавливает tabindex в предшествующее состояние', function() {
            link.delMod('disabled');
            expect(link.domElem.attr('tabindex')).toBe(TABINDEX);
        });
        it('должен выставлять значение атрибута aria-disabled = true при установке _disabled_yes', function() {
            expect(link.domElem.attr('aria-disabled')).toBe('true');
        });
        it('должен выставлять значение атрибута aria-disabled = false при удалении _disabled', function() {
            link.delMod('disabled');
            expect(link.domElem.attr('aria-disabled')).toBe('false');
        });
    });

    describe('#_pseudo', function() {
        var link;

        beforeEach(function() {
            link = build({block: 'link', mods: {pseudo: 'yes'}, content: 'Ссылка'});
        });

        afterEach(function() {
            BEM.DOM.destruct(link.domElem);
        });

        it('должен иметь role = button', function() {
            expect(link.domElem.attr('role')).toBe('button');
        });
    });

    function build(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem(bemjson.block);
    }

});
