module.exports = function(bh) {
    bh.match('logo', function(ctx, json) {
        var lang = bh.lib.global.lang;

        ctx
            .mod('lang', ~['en', 'tr'].indexOf(lang) ? 'en' : 'ru')
            .content({
                elem: 'link',
                content: {
                    elem: 'image',
                    alt: json.alt
                }
            });
    });

    bh.match('logo__link', function(ctx) {
        ctx
            .tag('a')
            .attr('href', bh.lib.services.serviceUrl('www'));
    });

    bh.match('logo__image', function(ctx, json) {
        ctx
            .tag('img')
            .attrs({
                alt: json.alt || bh.lib.i18n('logo', 'yandex'),
                src: '//yastatic.net/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif'
            });
    });
};
