##Описание
Блок `logo` – логотип Яндекса с кириллическим или латинским написанием (в зависимости от локали сервиса). Обычно представляет собой ссылку с изображением. Располагается в шапке (блок [header](../header/header.ru.md)) страницы. 

Для [поддерживаемых локалей](http://2-10.lego.yandex-team.ru/doc/concept/localization.wiki#Podderzhivaemyelokali), использующих латинский алфавит на страницах сервиса (`tr`, `en`), выводится слово – **Yandex** , для остальных, использующих кириллицу  – **Яндекс** (по умолчанию). 
  
В блоке, под изображением логотипа, можно разместить:
  
* обычный текст, например, как на [главной странице Яндекса](http://www.yandex.ru);
* текст в виде ссылки, например, название сервиса ([Словари](http://slovari.yandex.ru)).  

Изображение логотипа реализовано в формате `svg`. Для IE 8 и Android 2.3 – деградирует в `png`.  При отключенной в браузере загрузке изображений, будет использован логотип в формате `svg` из `data-uri`. В старых версиях браузеров, не поддерживающих формат `svg`, отобразится атрибут `alt` c незагруженным изображением. 

###Объявление блока на странице
BEMJSON, для подключения блока без текста под логотипом:

```js
{ 
    block: 'logo' // имя блока 
}
```

Блок без параметров, в зависимости от локали сервиса, будет представлен ссылкой с логотипом «Яндекс» («Yandex»).  
Ссылка ведет на главную страницу Яндекса текущей локали. Формируется на основании доменной зоны сервиса, данные для которой берутся из параметров блока [i-services](http://2-10.lego.yandex-team.ru/desktop/common/blocks/i-services).  

Блок `logo` состоит из комбинации абстрактного изображения (блок [image](./image.html)) и ссылки (блок [link](./link.html)) из библиотеки `islands-components`. По умолчанию эти блоки подмешиваются в BEMHTML-шаблоне блока `logo` к его элементам – `image` и `link` соответственно. В файловой структуре блока они не отражены, поскольку нужны лишь для формирования логотипа из уже готовых компонентов интерфейса.

Представление блока в HTML, после BEMHTML-преобразований

```html
<div class="logo logo_lang_ru">
    <a class="logo__link" href="(ссылка)" >
        <img class="logo__image" src="(ccылка на изображение)" alt="Яндекс"/>
    </a>
</div>
```

###Поля блока
Необязательные:

* `{String} url` – адрес страницы, на которую будет осуществляться переход по щелчку на логотип. По умолчанию установлена ссылка на главную страницу сервиса в текущей локали (определяется из блока [i-services](http://2-10.lego.yandex-team.ru/desktop/common/blocks/i-services)).
* `{String} alt` – альтернативный текст для изображения. Значение по умолчанию – локализованное слово «Яндекс» («Yandeх»).

  Для локализации текста в BEMJSON используется вспомогательный элемент `i18n` блока `i-bem`, который в BEMHTML-шаблоне  блока `logo` заменяется результатом вызова метода `BEM.I18N('logo', 'yandex')`. Подробнее см. [технологии i18n](http://2-10.lego.yandex-team.ru/doc/concept/localization.wiki#Texnologiyai18n) – переводы из [Танкера](http://2-10.lego.yandex-team.ru/doc/concept/localization.wiki#Tanker). 


<!-- %%logo.examples/10-logo-ru/10-logo-ru.html%% --> 

<!-- %%logo.examples/20-logo-en/20-logo-en%% -->

<!-- %%logo.examples/30-logo-tr/30-logo-tr%% -->


###Элементы блока

`text` – опциональный элемент, предназначенный для вставки [обычного текста](#stext) или [текста-ссылки](#ltext) под изображением логотипа. Реализован в технологиях CSS и BEMHTML.  

Визуально цвет текста и текста-ссылки – `#349bf3`(голубой), размер шрифта – 16px. Ссылка без нижнего подчеркивания. Распологается по центру родительского элемента. 

<a name="stext"></a>

* **обычный текст**

BEMJSON, для добавления обычного текста под логотипом:

```js
{
    block: 'logo',
    content: {
        elem: 'text',  // опциональный элемент блока logo
        content: 'DNS' //текст под логотипом
    }
}    
```

В BEMHTML-шаблоне элемент `text` заменяется на HTML-тег `<span>` c содержимым из поля `content`.

<a name="ltext"></a>

* **текст со ссылкой**

При наличии во входных данных элемента `text` поля `url`, в тег `<span>` будет вложена ссылка `<a href="">`, где атрибут `href` будет содержать значение из поля `url`.    

BEMJSON, для добавления текста-ссылки под логотипом:

```js
{
    block: 'logo',
    content: {
        elem: 'text',  
        url: '#',
        content: 'DNS'
    }
}
```

<!-- %%logo.examples/40-logo-text/40-logo-text%%-->

###Модификаторы блока

Модификатор языка логотипа `lang` добавляется автоматически в BEMHTML-шаблоне блока `logo`, в зависимости от локали. По умолчанию устанавляивается значение – `ru` (кириллица). Для локалей `en` и `tr` – `en` (латиница). Значение для языка контекста определяется из параметра `lang` блока [i-global](http://2-10.lego.yandex-team.ru/desktop/common/blocks/i-global).

В результате, исходя из установленного значения модификатора `lang`, применится соответствующий набор СSS-правил, содержащий фоновое изображение логотипа. Размер изображения - 95х37px.    

---

**NB** Необходимо гарантировать наличие у BEMHTML-шаблона блока `i-services`, модификатора `lang` и элемента `i-bem__i18n` (локализуемого блока), описав соответствующую `mustDeps` – зависимость в коде `deps.js`.

```javascript
// logo.deps.js
({
    mustDeps: [
        {mods: {lang: ['ru', 'en']}},
        {block: 'i-bem', elems ['html', 'i18n']},
        {block: 'i-services'}
    ]
});
```
